/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.exceptions.ValueHandlerAlreadyRegisteredException;
import de.bytefish.pgbulkinsert.exceptions.ValueHandlerNotRegisteredException;
import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.handlers.BigDecimalValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BooleanValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BoxValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteArrayValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.CircleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.HstoreValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet4AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet6AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.JsonbValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LineSegmentValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LineValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.MacAddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PathValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PointValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.PolygonValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.UUIDValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ValueHandlerProvider
implements IValueHandlerProvider {
    private Map<DataType, ValueHandler> valueHandlers = new HashMap<DataType, ValueHandler>();

    public ValueHandlerProvider() {
        this.add(DataType.Boolean, new BooleanValueHandler());
        this.add(DataType.Char, new ByteValueHandler());
        this.add(DataType.Numeric, new BigDecimalValueHandler());
        this.add(DataType.DoublePrecision, new DoubleValueHandler());
        this.add(DataType.SinglePrecision, new FloatValueHandler());
        this.add(DataType.Date, new LocalDateValueHandler());
        this.add(DataType.Timestamp, new LocalDateTimeValueHandler());
        this.add(DataType.Int2, new ShortValueHandler());
        this.add(DataType.Int4, new IntegerValueHandler());
        this.add(DataType.Int8, new LongValueHandler());
        this.add(DataType.Text, new StringValueHandler());
        this.add(DataType.VarChar, new StringValueHandler());
        this.add(DataType.Inet4, new Inet4AddressValueHandler());
        this.add(DataType.Inet6, new Inet6AddressValueHandler());
        this.add(DataType.Uuid, new UUIDValueHandler());
        this.add(DataType.Bytea, new ByteArrayValueHandler());
        this.add(DataType.Jsonb, new JsonbValueHandler());
        this.add(DataType.Hstore, new HstoreValueHandler());
        this.add(DataType.Point, new PointValueHandler());
        this.add(DataType.Box, new BoxValueHandler());
        this.add(DataType.Line, new LineValueHandler());
        this.add(DataType.LineSegment, new LineSegmentValueHandler());
        this.add(DataType.Path, new PathValueHandler());
        this.add(DataType.Polygon, new PolygonValueHandler());
        this.add(DataType.Circle, new CircleValueHandler());
        this.add(DataType.MacAddress, new MacAddressValueHandler());
    }

    public <TTargetType> ValueHandlerProvider add(DataType targetType, IValueHandler<TTargetType> valueHandler) {
        if (this.valueHandlers.containsKey((Object)targetType)) {
            throw new ValueHandlerAlreadyRegisteredException(String.format("TargetType '%s' has already been registered", new Object[]{targetType}));
        }
        this.valueHandlers.put(targetType, valueHandler);
        return this;
    }

    @Override
    public <TTargetType> IValueHandler<TTargetType> resolve(DataType dataType) {
        if (!this.valueHandlers.containsKey((Object)dataType)) {
            throw new ValueHandlerNotRegisteredException(String.format("DataType '%s' has not been registered", new Object[]{dataType}));
        }
        return (IValueHandler)this.valueHandlers.get((Object)dataType);
    }

    public String toString() {
        String valueHandlersString = this.valueHandlers.entrySet().stream().map(e -> ((ValueHandler)e.getValue()).toString()).collect(Collectors.joining(", "));
        return "ValueHandlerProvider{valueHandlers=[" + valueHandlersString + "]" + '}';
    }
}

