/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Collection;

public class CollectionValueHandler<TElementType, TCollectionType extends Collection<TElementType>>
extends BaseValueHandler<TCollectionType> {
    private final int oid;
    private final IValueHandler<TElementType> valueHandler;

    public CollectionValueHandler(int oid, IValueHandler<TElementType> valueHandler) {
        this.oid = oid;
        this.valueHandler = valueHandler;
    }

    @Override
    protected void internalHandle(DataOutputStream buffer, TCollectionType value) throws Exception {
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        DataOutputStream arrayOutput = new DataOutputStream(byteArrayOutput);
        arrayOutput.writeInt(1);
        arrayOutput.writeInt(1);
        arrayOutput.writeInt(this.oid);
        arrayOutput.writeInt(value.size());
        arrayOutput.writeInt(1);
        for (Object element : value) {
            this.valueHandler.handle(arrayOutput, element);
        }
        buffer.writeInt(byteArrayOutput.size());
        buffer.write(byteArrayOutput.toByteArray());
    }
}

