/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql;

import de.bytefish.pgbulkinsert.exceptions.BinaryWriteFailedException;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;

public class PgBinaryWriter
implements AutoCloseable {
    private transient DataOutputStream buffer;
    private final int bufferSize;

    public PgBinaryWriter() {
        this(65536);
    }

    public PgBinaryWriter(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void open(OutputStream out) {
        this.buffer = new DataOutputStream(new BufferedOutputStream(out, this.bufferSize));
        this.writeHeader();
    }

    private void writeHeader() {
        try {
            this.buffer.writeBytes("PGCOPY\n\u00ff\r\n\u0000");
            this.buffer.writeInt(0);
            this.buffer.writeInt(0);
        }
        catch (Exception e) {
            throw new BinaryWriteFailedException(e);
        }
    }

    public void startRow(int numColumns) {
        try {
            this.buffer.writeShort(numColumns);
        }
        catch (Exception e) {
            throw new BinaryWriteFailedException(e);
        }
    }

    public <TTargetType> void write(IValueHandler<TTargetType> handler, TTargetType value) {
        handler.handle(this.buffer, value);
    }

    @Override
    public void close() {
        try {
            this.buffer.writeShort(-1);
            this.buffer.flush();
            this.buffer.close();
        }
        catch (Exception e) {
            throw new BinaryWriteFailedException(e);
        }
    }
}

