/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert;

import de.bytefish.pgbulkinsert.IPgBulkInsert;
import de.bytefish.pgbulkinsert.configuration.Configuration;
import de.bytefish.pgbulkinsert.configuration.IConfiguration;
import de.bytefish.pgbulkinsert.exceptions.SaveEntityFailedException;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.stream.Stream;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;
import org.postgresql.copy.PGCopyOutputStream;

public class PgBulkInsert<TEntity>
implements IPgBulkInsert<TEntity> {
    private final IConfiguration configuration;
    private final AbstractMapping<TEntity> mapping;

    public PgBulkInsert(AbstractMapping mapping) {
        this(new Configuration(), mapping);
    }

    public PgBulkInsert(IConfiguration configuration, AbstractMapping mapping) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("mapping");
        }
        this.configuration = configuration;
        this.mapping = mapping;
    }

    @Override
    public void saveAll(PGConnection connection, Stream<TEntity> entities) throws SQLException {
        CopyManager cpManager = connection.getCopyAPI();
        CopyIn copyIn = cpManager.copyIn(this.mapping.getCopyCommand());
        try (PgBinaryWriter bw = new PgBinaryWriter(this.configuration.getBufferSize());){
            bw.open((OutputStream)new PGCopyOutputStream(copyIn, 1));
            entities.forEach(entity -> this.saveEntity(bw, entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEntity(PgBinaryWriter bw, TEntity entity) throws SaveEntityFailedException {
        PgBinaryWriter pgBinaryWriter = bw;
        synchronized (pgBinaryWriter) {
            bw.startRow(this.mapping.getColumns().size());
            this.mapping.getColumns().forEach(column -> {
                try {
                    column.getWrite().invoke(bw, entity);
                }
                catch (Exception e) {
                    throw new SaveEntityFailedException(e);
                }
            });
        }
    }
}

