/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.processor;

import de.bytefish.pgbulkinsert.pgsql.processor.handler.IBulkWriteHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BulkProcessor<TEntity>
implements AutoCloseable {
    private final ScheduledThreadPoolExecutor scheduler;
    private final ScheduledFuture<?> scheduledFuture;
    private volatile boolean closed = false;
    private final IBulkWriteHandler<TEntity> handler;
    private final int bulkSize;
    private List<TEntity> batchedEntities;

    public BulkProcessor(IBulkWriteHandler<TEntity> handler, int bulkSize) {
        this(handler, bulkSize, null);
    }

    public BulkProcessor(IBulkWriteHandler<TEntity> handler, int bulkSize, Duration flushInterval) {
        this.handler = handler;
        this.bulkSize = bulkSize;
        this.batchedEntities = new ArrayList<TEntity>();
        if (flushInterval != null) {
            this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
            this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Flush(), flushInterval.toMillis(), flushInterval.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.scheduler = null;
            this.scheduledFuture = null;
        }
    }

    public synchronized BulkProcessor<TEntity> add(TEntity entity) {
        this.batchedEntities.add(entity);
        this.executeIfNeccessary();
        return this;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.scheduledFuture != null) {
            BulkProcessor.cancel(this.scheduledFuture);
            this.scheduler.shutdown();
        }
        if (this.batchedEntities.size() > 0) {
            this.execute();
        }
    }

    private void executeIfNeccessary() {
        if (this.batchedEntities.size() >= this.bulkSize) {
            this.execute();
        }
    }

    private void execute() {
        List<TEntity> entities = this.batchedEntities;
        this.batchedEntities = new ArrayList<TEntity>();
        this.write(entities);
    }

    private void write(List<TEntity> entities) {
        try {
            this.handler.write(entities);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean cancel(Future<?> future) {
        if (future != null) {
            return future.cancel(false);
        }
        return false;
    }

    class Flush
    implements Runnable {
        Flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BulkProcessor bulkProcessor = BulkProcessor.this;
            synchronized (bulkProcessor) {
                if (BulkProcessor.this.closed) {
                    return;
                }
                if (BulkProcessor.this.batchedEntities.size() == 0) {
                    return;
                }
                BulkProcessor.this.execute();
            }
        }
    }
}

