/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;

public class TimeStampUtils {
    private TimeStampUtils() {
    }

    public static int toPgDays(LocalDate date) {
        LocalDateTime dateTime = date.atStartOfDay();
        long secs = TimeStampUtils.toPgSecs(TimeStampUtils.getSecondsSinceJavaEpoch(dateTime));
        return (int)TimeUnit.SECONDS.toDays(secs);
    }

    public static Long toPgSecs(LocalDateTime dateTime) {
        long secs = TimeStampUtils.toPgSecs(TimeStampUtils.getSecondsSinceJavaEpoch(dateTime));
        return TimeUnit.SECONDS.toMicros(secs);
    }

    private static long getSecondsSinceJavaEpoch(LocalDateTime localDateTime) {
        OffsetDateTime zdt = localDateTime.atOffset(ZoneOffset.UTC);
        long milliseconds = zdt.toInstant().toEpochMilli();
        return TimeUnit.MILLISECONDS.toSeconds(milliseconds);
    }

    private static long toPgSecs(long seconds) {
        long secs = seconds;
        if ((secs -= 946684800L) < -13165977600L && (secs -= 864000L) < -15773356800L) {
            int years = (int)((secs + 15773356800L) / -3155823050L);
            ++years;
            years -= years / 4;
            secs += (long)(years * 86400);
        }
        return secs;
    }
}

