/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import java.io.DataOutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;

public class UUIDValueHandler
extends BaseValueHandler<UUID> {
    @Override
    protected void internalHandle(DataOutputStream buffer, UUID value) throws Exception {
        buffer.writeInt(16);
        ByteBuffer bb = UUIDValueHandler.toByteBuffer(value);
        buffer.writeInt(bb.getInt(0));
        buffer.writeShort(bb.getShort(4));
        buffer.writeShort(bb.getShort(6));
        buffer.write(Arrays.copyOfRange(bb.array(), 8, 16));
    }

    private static ByteBuffer toByteBuffer(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb;
    }

    @Override
    public Type getTargetType() {
        return UUID.class;
    }
}

