/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert;

import de.bytefish.pgbulkinsert.IPgBulkInsert;
import de.bytefish.pgbulkinsert.exceptions.SaveEntityFailedException;
import de.bytefish.pgbulkinsert.functional.Action2;
import de.bytefish.pgbulkinsert.functional.Func2;
import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import de.bytefish.pgbulkinsert.pgsql.constants.PgTypes;
import de.bytefish.pgbulkinsert.pgsql.handlers.CollectionValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandlerProvider;
import de.bytefish.pgbulkinsert.util.StringUtils;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;
import org.postgresql.copy.PGCopyOutputStream;

public abstract class PgBulkInsert<TEntity>
implements IPgBulkInsert<TEntity> {
    private IValueHandlerProvider provider;
    private TableDefinition table;
    private List<ColumnDefinition> columns;

    public PgBulkInsert(String schemaName, String tableName) {
        this(new ValueHandlerProvider(), schemaName, tableName);
    }

    public PgBulkInsert(IValueHandlerProvider provider, String schemaName, String tableName) {
        this.provider = provider;
        this.table = new TableDefinition(schemaName, tableName);
        this.columns = new ArrayList<ColumnDefinition>();
    }

    @Override
    public void saveAll(PGConnection connection, Stream<TEntity> entities) throws SQLException {
        CopyManager cpManager = connection.getCopyAPI();
        CopyIn copyIn = cpManager.copyIn(this.getCopyCommand());
        int columnCount = this.columns.size();
        try (PgBinaryWriter bw = new PgBinaryWriter();){
            bw.open((OutputStream)new PGCopyOutputStream(copyIn));
            entities.forEach(entity -> {
                bw.startRow(columnCount);
                this.columns.forEach(column -> {
                    try {
                        column.getWrite().invoke(bw, entity);
                    }
                    catch (Exception e) {
                        throw new SaveEntityFailedException(e);
                    }
                });
            });
        }
    }

    protected <TElementType, TCollectionType extends Collection<TElementType>> void mapCollection(String columnName, Class<TElementType> type, Func2<TEntity, TCollectionType> propertyGetter) {
        IValueHandler valueHandler = this.provider.resolve(type);
        int valueOID = PgTypes.mapFrom(type);
        this.map(columnName, new CollectionValueHandler(type, valueOID, valueHandler), propertyGetter);
    }

    protected <TProperty> void map(String columnName, Class<TProperty> type, Func2<TEntity, TProperty> propertyGetter) {
        IValueHandler valueHandler = this.provider.resolve(type);
        this.map(columnName, valueHandler, propertyGetter);
    }

    protected <TProperty> void map(String columnName, IValueHandler<TProperty> valueHandler, Func2<TEntity, TProperty> propertyGetter) {
        this.addColumn(columnName, (binaryWriter, entity) -> binaryWriter.write(valueHandler, propertyGetter.invoke(entity)));
    }

    protected void mapBoolean(String columnName, Func2<TEntity, Boolean> propertyGetter) {
        this.map(columnName, Boolean.class, propertyGetter);
    }

    protected void mapByte(String columnName, Func2<TEntity, Byte> propertyGetter) {
        this.map(columnName, Byte.class, propertyGetter);
    }

    protected void mapSmallInt(String columnName, Func2<TEntity, Short> propertyGetter) {
        this.map(columnName, Short.class, propertyGetter);
    }

    protected void mapInteger(String columnName, Func2<TEntity, Integer> propertyGetter) {
        this.map(columnName, Integer.class, propertyGetter);
    }

    protected void mapBigInt(String columnName, Func2<TEntity, Long> propertyGetter) {
        this.map(columnName, Long.class, propertyGetter);
    }

    protected void mapReal(String columnName, Func2<TEntity, Float> propertyGetter) {
        this.map(columnName, Float.class, propertyGetter);
    }

    protected void mapDouble(String columnName, Func2<TEntity, Double> propertyGetter) {
        this.map(columnName, Double.class, propertyGetter);
    }

    protected void mapDate(String columnName, Func2<TEntity, LocalDate> propertyGetter) {
        this.map(columnName, LocalDate.class, propertyGetter);
    }

    protected void mapInet4Addr(String columnName, Func2<TEntity, Inet4Address> propertyGetter) {
        this.map(columnName, Inet4Address.class, propertyGetter);
    }

    protected void mapInet6Addr(String columnName, Func2<TEntity, Inet6Address> propertyGetter) {
        this.map(columnName, Inet6Address.class, propertyGetter);
    }

    protected void mapTimeStamp(String columnName, Func2<TEntity, LocalDateTime> propertyGetter) {
        this.map(columnName, LocalDateTime.class, propertyGetter);
    }

    protected void mapString(String columnName, Func2<TEntity, String> propertyGetter) {
        this.map(columnName, String.class, propertyGetter);
    }

    protected void mapUUID(String columnName, Func2<TEntity, UUID> propertyGetter) {
        this.map(columnName, UUID.class, propertyGetter);
    }

    protected void mapByteArray(String columnName, Func2<TEntity, Byte[]> propertyGetter) {
        this.map(columnName, Byte[].class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Boolean>> void mapBooleanArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Boolean.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Short>> void mapShortArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Short.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Integer>> void mapIntegerArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Integer.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Long>> void mapLongArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Long.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<String>> void mapStringArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, String.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Float>> void mapFloatArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Float.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Double>> void mapDoubleArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Double.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<UUID>> void mapUUIDArray(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, UUID.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Inet4Address>> void mapInet4Array(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Inet4Address.class, propertyGetter);
    }

    protected <TCollectionType extends Collection<Inet6Address>> void mapInet6Array(String columnName, Func2<TEntity, TCollectionType> propertyGetter) {
        this.mapCollection(columnName, Inet6Address.class, propertyGetter);
    }

    private PgBulkInsert<TEntity> addColumn(String columnName, Action2<PgBinaryWriter, TEntity> action) {
        this.columns.add(new ColumnDefinition(columnName, action));
        return this;
    }

    private String getCopyCommand() {
        String commaSeparatedColumns = this.columns.stream().map(x -> ((ColumnDefinition)x).columnName).collect(Collectors.joining(", "));
        return String.format("COPY %1$s(%2$s) FROM STDIN BINARY", this.table.GetFullQualifiedTableName(), commaSeparatedColumns);
    }

    private class ColumnDefinition {
        private String columnName;
        private Action2<PgBinaryWriter, TEntity> write;

        public ColumnDefinition(String columnName, Action2<PgBinaryWriter, TEntity> write) {
            this.columnName = columnName;
            this.write = write;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Action2<PgBinaryWriter, TEntity> getWrite() {
            return this.write;
        }

        public String toString() {
            return String.format("ColumnDefinition (ColumnName = {%1$s}, Serialize = {%2$s})", this.columnName, this.write);
        }
    }

    private class TableDefinition {
        private String schema;
        private String tableName;

        public TableDefinition(String tableName) {
            this("", tableName);
        }

        public TableDefinition(String schema, String tableName) {
            this.schema = schema;
            this.tableName = tableName;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String GetFullQualifiedTableName() {
            if (StringUtils.isNullOrWhiteSpace(this.schema)) {
                return this.tableName;
            }
            return String.format("%1$s.%2$s", this.schema, this.tableName);
        }

        public String toString() {
            return String.format("TableDefinition (Schema = {%1$s}, TableName = {%2$s})", this.schema, this.tableName);
        }
    }
}

