/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.util;

import com.sun.istack.internal.NotNull;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.exceptions.PgConnectionException;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.util.OutParameter;
import java.sql.Connection;
import java.sql.SQLException;
import org.postgresql.PGConnection;

public final class PostgreSqlUtils {
    private PostgreSqlUtils() {
    }

    public static PGConnection getPGConnection(Connection connection) throws SQLException {
        OutParameter<PGConnection> result = new OutParameter<PGConnection>();
        if (!PostgreSqlUtils.tryGetPGConnection(connection, result)) {
            throw new PgConnectionException("Could not obtain a PGConnection");
        }
        return result.get();
    }

    public static boolean tryGetPGConnection(Connection connection, @NotNull OutParameter<PGConnection> result) throws SQLException {
        if (PostgreSqlUtils.tryCastConnection(connection, result)) {
            return true;
        }
        return PostgreSqlUtils.tryUnwrapConnection(connection, result);
    }

    private static boolean tryCastConnection(Connection connection, @NotNull OutParameter<PGConnection> result) {
        if (connection instanceof PGConnection) {
            result.set((PGConnection)connection);
            return true;
        }
        return false;
    }

    private static boolean tryUnwrapConnection(Connection connection, @NotNull OutParameter<PGConnection> result) {
        try {
            if (connection.isWrapperFor(PGConnection.class)) {
                result.set(connection.unwrap(PGConnection.class));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

