/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;

public class TimeStampUtils {
    private TimeStampUtils() {
    }

    public static Long toPgSecs(LocalDate date) {
        return TimeStampUtils.toPgSecs(date.atStartOfDay());
    }

    public static Long toPgSecs(LocalDateTime dateTime) {
        OffsetDateTime zdt = dateTime.atOffset(ZoneOffset.UTC);
        long milliseconds = zdt.toInstant().toEpochMilli();
        long secs = TimeStampUtils.toPgSecs(TimeUnit.MILLISECONDS.toSeconds(milliseconds));
        return TimeUnit.SECONDS.toMicros(secs);
    }

    private static long toPgSecs(long seconds) {
        long secs = seconds;
        if ((secs -= 946684800L) < -13165977600L && (secs -= 864000L) < -15773356800L) {
            int years = (int)((secs + 15773356800L) / -3155823050L);
            ++years;
            years -= years / 4;
            secs += (long)(years * 86400);
        }
        return secs;
    }
}

