/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.exceptions.ValueHandlerAlreadyRegisteredException;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.exceptions.ValueHandlerNotRegisteredException;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.converter.LocalDateConverter;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.converter.LocalDateTimeConverter;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.BooleanValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.ByteValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandler;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ValueHandlerProvider
implements IValueHandlerProvider {
    private Map<Type, ValueHandler> valueHandlers = new HashMap<Type, ValueHandler>();

    public ValueHandlerProvider() {
        this.add(new BooleanValueHandler());
        this.add(new ByteValueHandler());
        this.add(new DoubleValueHandler());
        this.add(new FloatValueHandler());
        this.add(new LocalDateValueHandler(new LocalDateConverter()));
        this.add(new LocalDateTimeValueHandler(new LocalDateTimeConverter()));
        this.add(new IntegerValueHandler());
        this.add(new ShortValueHandler());
        this.add(new LongValueHandler());
        this.add(new StringValueHandler());
    }

    public <TTargetType> ValueHandlerProvider add(IValueHandler<TTargetType> valueHandler) {
        Type targetType = valueHandler.getTargetType();
        if (this.valueHandlers.containsKey(targetType)) {
            throw new ValueHandlerAlreadyRegisteredException(String.format("TargetType '%s' has already been registered", targetType));
        }
        this.valueHandlers.put(valueHandler.getTargetType(), valueHandler);
        return this;
    }

    @Override
    public <TTargetType> IValueHandler<TTargetType> resolve(Type targetType) {
        if (!this.valueHandlers.containsKey(targetType)) {
            throw new ValueHandlerNotRegisteredException(String.format("TargetType '%s' has not been registered", targetType));
        }
        return (IValueHandler)this.valueHandlers.get(targetType);
    }

    public <TTargetType> ValueHandlerProvider override(IValueHandler<TTargetType> valueHandler) {
        this.valueHandlers.put(valueHandler.getTargetType(), valueHandler);
        return this;
    }

    public String toString() {
        String valueHandlersString = this.valueHandlers.entrySet().stream().map(e -> ((ValueHandler)e.getValue()).toString()).collect(Collectors.joining(", "));
        return "ValueHandlerProvider{valueHandlers=[" + valueHandlersString + "]" + '}';
    }
}

