/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql;

import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.exceptions.BinaryWriteFailedException;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandlerProvider;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.handlers.ValueHandlerProvider;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;

public class PgBinaryWriter
implements AutoCloseable {
    private transient DataOutputStream buffer;
    private IValueHandler<Boolean> booleanValueHandler;
    private IValueHandler<Byte> byteValueHandler;
    private IValueHandler<Double> doubleValueHandler;
    private IValueHandler<Float> floatValueHandler;
    private IValueHandler<LocalDate> localDateValueHandler;
    private IValueHandler<LocalDateTime> localDateTimeValueHandler;
    private IValueHandler<Integer> integerValueHandler;
    private IValueHandler<Short> shortValueHandler;
    private IValueHandler<Long> longValueHandler;
    private IValueHandler<String> stringValueHandler;

    public PgBinaryWriter() {
        this(new ValueHandlerProvider());
    }

    public PgBinaryWriter(IValueHandlerProvider provider) {
        this.booleanValueHandler = provider.resolve((Type)((Object)Boolean.class));
        this.byteValueHandler = provider.resolve((Type)((Object)Byte.class));
        this.doubleValueHandler = provider.resolve((Type)((Object)Double.class));
        this.floatValueHandler = provider.resolve((Type)((Object)Float.class));
        this.localDateValueHandler = provider.resolve((Type)((Object)LocalDate.class));
        this.localDateTimeValueHandler = provider.resolve((Type)((Object)LocalDateTime.class));
        this.integerValueHandler = provider.resolve((Type)((Object)Integer.class));
        this.shortValueHandler = provider.resolve((Type)((Object)Short.class));
        this.longValueHandler = provider.resolve((Type)((Object)Long.class));
        this.stringValueHandler = provider.resolve((Type)((Object)String.class));
    }

    public void open(OutputStream out) {
        this.buffer = new DataOutputStream(new BufferedOutputStream(out));
        this.writeHeader();
    }

    private void writeHeader() {
        try {
            this.buffer.writeBytes("PGCOPY\n\u00ff\r\n\u0000");
            this.buffer.writeInt(0);
            this.buffer.writeInt(0);
        }
        catch (Exception e) {
            throw new BinaryWriteFailedException(e);
        }
    }

    public void startRow(int numColumns) {
        try {
            this.buffer.writeShort(numColumns);
        }
        catch (Exception e) {
            throw new BinaryWriteFailedException(e);
        }
    }

    public void write(Boolean value) {
        this.booleanValueHandler.handle(this.buffer, value);
    }

    public void write(Byte value) {
        this.byteValueHandler.handle(this.buffer, value);
    }

    public void write(Double value) {
        this.doubleValueHandler.handle(this.buffer, value);
    }

    public void write(Float value) {
        this.floatValueHandler.handle(this.buffer, value);
    }

    public void write(Integer value) {
        this.integerValueHandler.handle(this.buffer, value);
    }

    public void write(Short value) {
        this.shortValueHandler.handle(this.buffer, value);
    }

    public void write(Long value) {
        this.longValueHandler.handle(this.buffer, value);
    }

    public void write(LocalDate value) {
        this.localDateValueHandler.handle(this.buffer, value);
    }

    public void write(LocalDateTime value) {
        this.localDateTimeValueHandler.handle(this.buffer, value);
    }

    public void write(String value) {
        this.stringValueHandler.handle(this.buffer, value);
    }

    @Override
    public void close() {
        try {
            this.buffer.writeShort(-1);
            this.buffer.flush();
            this.buffer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

