/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert;

import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.exceptions.SaveEntityFailedException;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.functional.Action2;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.functional.Func2;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import de.bytefish.pgbulkinsert.de.bytefish.pgbulkinsert.util.StringUtils;
import java.io.OutputStream;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyIn;
import org.postgresql.copy.CopyManager;
import org.postgresql.copy.PGCopyOutputStream;

public abstract class PgBulkInsert<TEntity> {
    private TableDefinition table;
    private List<ColumnDefinition> columns;

    public PgBulkInsert(String schemaName, String tableName) {
        this.table = new TableDefinition(schemaName, tableName);
        this.columns = new ArrayList<ColumnDefinition>();
    }

    public void saveAll(PGConnection connection, Stream<TEntity> entities) throws SQLException {
        CopyManager cpManager = connection.getCopyAPI();
        CopyIn copyIn = cpManager.copyIn(this.getCopyCommand());
        int columnCount = this.columns.size();
        try (PgBinaryWriter bw = new PgBinaryWriter();){
            bw.open((OutputStream)new PGCopyOutputStream(copyIn));
            entities.forEach(entity -> {
                bw.startRow(columnCount);
                this.columns.forEach(column -> {
                    try {
                        column.getWrite().invoke(bw, entity);
                    }
                    catch (Exception e) {
                        throw new SaveEntityFailedException(e);
                    }
                });
            });
        }
    }

    protected void MapBoolean(String columnName, Func2<TEntity, Boolean> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((Boolean)propertyGetter.invoke(entity)));
    }

    protected void MapByte(String columnName, Func2<TEntity, Byte> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((Byte)propertyGetter.invoke(entity)));
    }

    protected void MapSmallInt(String columnName, Func2<TEntity, Short> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((Short)propertyGetter.invoke(entity)));
    }

    protected void MapInteger(String columnName, Func2<TEntity, Integer> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((Integer)propertyGetter.invoke(entity)));
    }

    protected void MapBigInt(String columnName, Func2<TEntity, Long> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((Long)propertyGetter.invoke(entity)));
    }

    protected void MapReal(String columnName, Func2<TEntity, Float> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((Float)propertyGetter.invoke(entity)));
    }

    protected void MapDouble(String columnName, Func2<TEntity, Double> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((Double)propertyGetter.invoke(entity)));
    }

    protected void MapDate(String columnName, Func2<TEntity, LocalDate> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((LocalDate)propertyGetter.invoke(entity)));
    }

    protected void MapTimeStamp(String columnName, Func2<TEntity, LocalDateTime> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((LocalDateTime)propertyGetter.invoke(entity)));
    }

    protected void MapString(String columnName, Func2<TEntity, String> propertyGetter) {
        this.AddColumn(columnName, (binaryWriter, entity) -> binaryWriter.write((String)propertyGetter.invoke(entity)));
    }

    private PgBulkInsert<TEntity> AddColumn(String columnName, Action2<PgBinaryWriter, TEntity> action) {
        this.columns.add(new ColumnDefinition(columnName, action));
        return this;
    }

    private String getCopyCommand() {
        String commaSeparatedColumns = this.columns.stream().map(x -> ((ColumnDefinition)x).columnName).collect(Collectors.joining(", "));
        return String.format("COPY %1$s(%2$s) FROM STDIN BINARY", this.table.GetFullQualifiedTableName(), commaSeparatedColumns);
    }

    private class ColumnDefinition {
        private String columnName;
        private Action2<PgBinaryWriter, TEntity> write;

        public ColumnDefinition(String columnName, Action2<PgBinaryWriter, TEntity> write) {
            this.columnName = columnName;
            this.write = write;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Action2<PgBinaryWriter, TEntity> getWrite() {
            return this.write;
        }

        public String toString() {
            return String.format("ColumnDefinition (ColumnName = {%1$s}, Serialize = {%2$s})", this.columnName, this.write);
        }
    }

    private class TableDefinition {
        private String schema;
        private String tableName;

        public TableDefinition(String tableName) {
            this("", tableName);
        }

        public TableDefinition(String schema, String tableName) {
            this.schema = schema;
            this.tableName = tableName;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String GetFullQualifiedTableName() {
            if (StringUtils.isNullOrWhiteSpace(this.schema)) {
                return this.tableName;
            }
            return String.format("%1$s.%2$s", this.schema, this.tableName);
        }

        public String toString() {
            return String.format("TableDefinition (Schema = {%1$s}, TableName = {%2$s})", this.schema, this.tableName);
        }
    }
}

