/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.exceptions.TypeConverterAlreadyRegisteredException;
import de.bytefish.jtinycsvparser.exceptions.TypeConverterNotRegisteredException;
import de.bytefish.jtinycsvparser.typeconverter.BigIntegerConverter;
import de.bytefish.jtinycsvparser.typeconverter.ByteConverter;
import de.bytefish.jtinycsvparser.typeconverter.DoubleConverter;
import de.bytefish.jtinycsvparser.typeconverter.DurationConverter;
import de.bytefish.jtinycsvparser.typeconverter.FloatConverter;
import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import de.bytefish.jtinycsvparser.typeconverter.ITypeConverterProvider;
import de.bytefish.jtinycsvparser.typeconverter.InstantConverter;
import de.bytefish.jtinycsvparser.typeconverter.IntegerConverter;
import de.bytefish.jtinycsvparser.typeconverter.LocalDateConverter;
import de.bytefish.jtinycsvparser.typeconverter.LocalDateTimeConverter;
import de.bytefish.jtinycsvparser.typeconverter.LongConverter;
import de.bytefish.jtinycsvparser.typeconverter.ShortConverter;
import de.bytefish.jtinycsvparser.typeconverter.StringConverter;
import de.bytefish.jtinycsvparser.typeconverter.TypeConverter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class TypeConverterProvider
implements ITypeConverterProvider {
    private Map<Type, TypeConverter> typeConverters = new HashMap<Type, TypeConverter>();

    public TypeConverterProvider() {
        this.add(new BigIntegerConverter());
        this.add(new ByteConverter());
        this.add(new DoubleConverter());
        this.add(new DurationConverter());
        this.add(new FloatConverter());
        this.add(new IntegerConverter());
        this.add(new InstantConverter());
        this.add(new LocalDateConverter());
        this.add(new LocalDateTimeConverter());
        this.add(new LongConverter());
        this.add(new ShortConverter());
        this.add(new StringConverter());
    }

    public <TTargetType> TypeConverterProvider add(ITypeConverter<TTargetType> typeConverter) {
        Type targetType = typeConverter.getTargetType();
        if (this.typeConverters.containsKey(targetType)) {
            throw new TypeConverterAlreadyRegisteredException(String.format("TargetType '%s' has already been registered", targetType));
        }
        this.typeConverters.put(typeConverter.getTargetType(), typeConverter);
        return this;
    }

    @Override
    public <TTargetType> ITypeConverter<TTargetType> resolve(Type targetType) {
        if (!this.typeConverters.containsKey(targetType)) {
            throw new TypeConverterNotRegisteredException(String.format("TargetType '%s' has not been registered", targetType));
        }
        return (ITypeConverter)this.typeConverters.get(targetType);
    }

    public <TTargetType> TypeConverterProvider override(ITypeConverter<TTargetType> typeConverter) {
        this.typeConverters.put(typeConverter.getTargetType(), typeConverter);
        return this;
    }

    public String toString() {
        String typeConvertersString = this.typeConverters.entrySet().stream().map(e -> ((TypeConverter)e.getValue()).toString()).collect(Collectors.joining(", "));
        return "TypeConverterProvider{typeConverters=[" + typeConvertersString + "]" + '}';
    }
}

