/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Locale;

public class ShortConverter
implements ITypeConverter<Short> {
    private NumberFormat numberFormat;

    public ShortConverter() {
        this(NumberFormat.getInstance(Locale.US));
    }

    public ShortConverter(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public Short convert(String value) {
        try {
            return this.numberFormat.parse(value).shortValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Short.class;
    }

    public String toString() {
        return "ShortConverter{numberFormat=" + this.numberFormat + '}';
    }
}

