/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Locale;

public class LongConverter
implements ITypeConverter<Long> {
    private NumberFormat numberFormat;

    public LongConverter() {
        this(NumberFormat.getInstance(Locale.US));
    }

    public LongConverter(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public Long convert(String value) {
        try {
            return this.numberFormat.parse(value).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Long.class;
    }

    public String toString() {
        return "LongConverter{numberFormat=" + this.numberFormat + '}';
    }
}

