/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeConverter
implements ITypeConverter<LocalDateTime> {
    private DateTimeFormatter dateTimeFormatter;

    public LocalDateTimeConverter() {
        this(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public LocalDateTimeConverter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public LocalDateTime convert(String value) {
        return LocalDateTime.parse(value, this.dateTimeFormatter);
    }

    @Override
    public Type getTargetType() {
        return LocalDateTime.class;
    }

    public String toString() {
        return "LocalDateTimeConverter{dateTimeFormatter=" + this.dateTimeFormatter + '}';
    }
}

