/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateConverter
implements ITypeConverter<LocalDate> {
    private DateTimeFormatter dateTimeFormatter;

    public LocalDateConverter() {
        this(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public LocalDateConverter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public LocalDate convert(String value) {
        return LocalDate.parse(value, this.dateTimeFormatter);
    }

    @Override
    public Type getTargetType() {
        return LocalDate.class;
    }

    public String toString() {
        return "LocalDateConverter{dateTimeFormatter=" + this.dateTimeFormatter + '}';
    }
}

