/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Locale;

public class IntegerConverter
implements ITypeConverter<Integer> {
    private NumberFormat numberFormat;

    public IntegerConverter() {
        this(NumberFormat.getInstance(Locale.US));
    }

    public IntegerConverter(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public Integer convert(String value) {
        try {
            return this.numberFormat.parse(value).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Integer.class;
    }

    public String toString() {
        return "IntegerConverter{numberFormat=" + this.numberFormat + '}';
    }
}

