/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Locale;

public class FloatConverter
implements ITypeConverter<Float> {
    private NumberFormat numberFormat;

    public FloatConverter() {
        this(NumberFormat.getInstance(Locale.US));
    }

    public FloatConverter(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public Float convert(String value) {
        try {
            return Float.valueOf(this.numberFormat.parse(value).floatValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Float.class;
    }

    public String toString() {
        return "FloatConverter{numberFormat=" + this.numberFormat + '}';
    }
}

