/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;

public class EnumConverter<E extends Enum<E>>
implements ITypeConverter<E> {
    private Class<E> enumType;

    public EnumConverter(Class<E> enumType) {
        this.enumType = enumType;
    }

    @Override
    public E convert(String value) {
        try {
            return Enum.valueOf(this.enumType, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return this.enumType;
    }

    public String toString() {
        return "IntegerConverter{, enumType=" + this.enumType + '}';
    }
}

