/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Locale;

public class DoubleConverter
implements ITypeConverter<Double> {
    private NumberFormat numberFormat;

    public DoubleConverter() {
        this(NumberFormat.getInstance(Locale.US));
    }

    public DoubleConverter(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public Double convert(String value) {
        try {
            return this.numberFormat.parse(value).doubleValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Double.class;
    }

    public String toString() {
        return "DoubleConverter{numberFormat=" + this.numberFormat + '}';
    }
}

