/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.typeconverter;

import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.Locale;

public class ByteConverter
implements ITypeConverter<Byte> {
    private NumberFormat numberFormat;

    public ByteConverter() {
        this(NumberFormat.getInstance(Locale.US));
    }

    public ByteConverter(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public Byte convert(String value) {
        try {
            return this.numberFormat.parse(value).byteValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Byte.class;
    }

    public String toString() {
        return "ByteConverter{numberFormat=" + this.numberFormat + '}';
    }
}

