/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.tokenizer;

import de.bytefish.jtinycsvparser.tokenizer.ITokenizer;
import de.bytefish.jtinycsvparser.utils.StringUtils;

public class StringSplitTokenizer
implements ITokenizer {
    private String columnDelimiter;
    private boolean trimValues;

    public StringSplitTokenizer(String columnDelimiter, boolean trimValues) {
        this.columnDelimiter = columnDelimiter;
        this.trimValues = trimValues;
    }

    @Override
    public String[] tokenize(String input) {
        String[] result = input.split(this.columnDelimiter);
        if (this.trimValues) {
            result = StringUtils.trimAllElements(result);
        }
        return result;
    }

    public String toString() {
        return "StringSplitTokenizer{columnDelimiter='" + this.columnDelimiter + '\'' + ", trimValues=" + this.trimValues + '}';
    }
}

