/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.tokenizer;

import de.bytefish.jtinycsvparser.tokenizer.ITokenizer;
import de.bytefish.jtinycsvparser.utils.StringUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuotedStringTokenizer
implements ITokenizer {
    private String columnDelimiter;
    private boolean trimValues;
    private Pattern pattern;

    public QuotedStringTokenizer(String columnDelimiter, boolean trimValues) {
        this.columnDelimiter = columnDelimiter;
        this.trimValues = trimValues;
        this.pattern = this.BuildPattern();
    }

    private Pattern BuildPattern() {
        return Pattern.compile(this.BuildRegExp());
    }

    private String BuildRegExp() {
        return String.format("((?<=\\\")[^\\\"]*(?=\\\"(%1$s|$)+)|(?<=%1$s|^)[^%1$s\\\"]*(?=%1$s|$))", this.columnDelimiter);
    }

    private String[] tokenizeWithRegExp(String input) {
        Matcher m = this.pattern.matcher(input);
        ArrayList<String> tokens = new ArrayList<String>();
        while (m.find()) {
            tokens.add(m.group(1));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    @Override
    public String[] tokenize(String input) {
        String[] result = this.tokenizeWithRegExp(input);
        if (this.trimValues) {
            result = StringUtils.trimAllElements(result);
        }
        return result;
    }

    public String toString() {
        return "QuotedStringTokenizer{columnDelimiter='" + this.columnDelimiter + '\'' + ", pattern=" + this.pattern + '}';
    }
}

