/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.mapping;

import de.bytefish.jtinycsvparser.mapping.ICsvPropertyMapping;
import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import java.util.function.BiConsumer;

public class CsvPropertyMapping<TEntity, TProperty>
implements ICsvPropertyMapping<TEntity> {
    private BiConsumer<TEntity, TProperty> setter;
    private ITypeConverter<TProperty> typeConverter;

    public CsvPropertyMapping(BiConsumer<TEntity, TProperty> setter, ITypeConverter<TProperty> typeConverter) {
        this.setter = setter;
        this.typeConverter = typeConverter;
    }

    @Override
    public boolean tryMapValue(TEntity entity, String value) {
        try {
            this.setter.accept(entity, this.typeConverter.convert(value));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "CsvPropertyMapping{setter=" + this.setter + ", typeConverter=" + this.typeConverter + '}';
    }
}

