/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser.mapping;

import de.bytefish.jtinycsvparser.builder.IObjectCreator;
import de.bytefish.jtinycsvparser.exceptions.DuplicateColumnMappingException;
import de.bytefish.jtinycsvparser.mapping.CsvMappingError;
import de.bytefish.jtinycsvparser.mapping.CsvMappingResult;
import de.bytefish.jtinycsvparser.mapping.CsvPropertyMapping;
import de.bytefish.jtinycsvparser.mapping.ICsvPropertyMapping;
import de.bytefish.jtinycsvparser.typeconverter.ITypeConverter;
import de.bytefish.jtinycsvparser.typeconverter.ITypeConverterProvider;
import de.bytefish.jtinycsvparser.typeconverter.TypeConverterProvider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public abstract class CsvMapping<TEntity> {
    private IObjectCreator creator;
    private ITypeConverterProvider typeConverterProvider;
    private ArrayList<IndexToPropertyMapping> csvPropertyMappings;

    public CsvMapping(IObjectCreator creator) {
        this(creator, new TypeConverterProvider());
    }

    public CsvMapping(IObjectCreator creator, ITypeConverterProvider typeConverterProvider) {
        this.creator = creator;
        this.typeConverterProvider = typeConverterProvider;
        this.csvPropertyMappings = new ArrayList();
    }

    public <TProperty> void MapProperty(int columnIndex, Type targetType, BiConsumer<TEntity, TProperty> setter) {
        ITypeConverter converter = this.typeConverterProvider.resolve(targetType);
        this.MapProperty(columnIndex, targetType, setter, converter);
    }

    public <TProperty> void MapProperty(int columnIndex, Type targetType, BiConsumer<TEntity, TProperty> setter, ITypeConverter<TProperty> converter) {
        if (this.csvPropertyMappings.stream().anyMatch(e -> e.getColumnIndex() == columnIndex)) {
            throw new DuplicateColumnMappingException("Duplicate Mapping for Column " + columnIndex);
        }
        this.csvPropertyMappings.add(new IndexToPropertyMapping(columnIndex, new CsvPropertyMapping<TEntity, TProperty>(setter, converter)));
    }

    public CsvMappingResult<TEntity> Map(String[] values) {
        Object entity = this.creator.create();
        for (int pos = 0; pos < this.csvPropertyMappings.size(); ++pos) {
            IndexToPropertyMapping indexToPropertyMapping = this.csvPropertyMappings.get(pos);
            int columnIndex = indexToPropertyMapping.getColumnIndex();
            if (columnIndex >= values.length) {
                return new CsvMappingResult(new CsvMappingError(columnIndex, null, String.format("Column %s Out Of Range", columnIndex)));
            }
            String value = values[columnIndex];
            if (indexToPropertyMapping.getPropertyMapping().tryMapValue(entity, value)) continue;
            return new CsvMappingResult(new CsvMappingError(columnIndex, value, "Conversion failed"));
        }
        return new CsvMappingResult(entity);
    }

    public String toString() {
        String csvPropertyMappingsString = this.csvPropertyMappings.stream().map(e -> e.toString()).collect(Collectors.joining(", "));
        return "CsvMapping{creator=" + this.creator + ", typeConverterProvider=" + this.typeConverterProvider + ", csvPropertyMappings=[" + csvPropertyMappingsString + "]" + '}';
    }

    private class IndexToPropertyMapping {
        private int index;
        private ICsvPropertyMapping<TEntity> mapping;

        public IndexToPropertyMapping(int index, ICsvPropertyMapping<TEntity> mapping) {
            this.index = index;
            this.mapping = mapping;
        }

        public int getColumnIndex() {
            return this.index;
        }

        public ICsvPropertyMapping<TEntity> getPropertyMapping() {
            return this.mapping;
        }

        public String toString() {
            return "IndexToPropertyMapping{index=" + this.index + ", mapping=" + this.mapping + '}';
        }
    }
}

