/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jtinycsvparser;

import de.bytefish.jtinycsvparser.CsvParserOptions;
import de.bytefish.jtinycsvparser.CsvReaderOptions;
import de.bytefish.jtinycsvparser.ICsvParser;
import de.bytefish.jtinycsvparser.mapping.CsvMapping;
import de.bytefish.jtinycsvparser.mapping.CsvMappingResult;
import de.bytefish.jtinycsvparser.utils.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CsvParser<TEntity>
implements ICsvParser<TEntity> {
    private CsvParserOptions options;
    private CsvMapping<TEntity> mapping;

    public CsvParser(CsvParserOptions options, CsvMapping<TEntity> mapping) {
        this.mapping = mapping;
        this.options = options;
    }

    @Override
    public Stream<CsvMappingResult<TEntity>> parse(Stream<String> stream) {
        if (this.options.getParallel()) {
            stream = (Stream)stream.parallel();
        }
        return stream.skip(this.options.getSkipHeader() ? 1L : 0L).filter(s1 -> !StringUtils.isNullOrWhiteSpace(s1)).map(s -> this.options.getTokenizer().tokenize((String)s)).map(a -> this.mapping.Map((String[])a));
    }

    public Stream<CsvMappingResult<TEntity>> parse(Iterable<String> csvData) {
        return this.parse(StreamSupport.stream(csvData.spliterator(), false));
    }

    public Stream<CsvMappingResult<TEntity>> readFromFile(Path path, Charset charset) {
        try {
            return this.parse(Files.lines(path, charset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<CsvMappingResult<TEntity>> readFromString(String csvData, CsvReaderOptions options) {
        return this.parse(Arrays.asList(csvData.split(options.getNewLine())));
    }

    public String toString() {
        return "CsvParser{options=" + this.options + ", mapping=" + this.mapping + '}';
    }
}

