/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.mapping;

import de.bytefish.jsqlserverbulkinsert.functional.Func2;
import de.bytefish.jsqlserverbulkinsert.model.ColumnDefinition;
import de.bytefish.jsqlserverbulkinsert.model.ColumnMetaData;
import de.bytefish.jsqlserverbulkinsert.model.TableDefinition;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMapping<TEntity> {
    private TableDefinition table;
    private List<ColumnDefinition<TEntity>> columns;

    public AbstractMapping(String tableName) {
        this("", tableName);
    }

    public AbstractMapping(String schemaName, String tableName) {
        this.table = new TableDefinition(schemaName, tableName);
        this.columns = new ArrayList<ColumnDefinition<TEntity>>();
    }

    protected void mapBoolean(String columnName, Func2<TEntity, Boolean> propertyGetter) {
        this.addColumn(columnName, -7, propertyGetter);
    }

    protected void mapNumeric(String columnName, int precision, int scale, Func2<TEntity, BigDecimal> propertyGetter) {
        Func2<Object, BigDecimal> wrapper = entity -> {
            BigDecimal result = ((BigDecimal)propertyGetter.invoke(entity)).setScale(scale, 4);
            return result;
        };
        this.addColumn(columnName, 2, precision, scale, false, wrapper);
    }

    protected void mapDecimal(String columnName, int precision, int scale, Func2<TEntity, BigDecimal> propertyGetter) {
        Func2<Object, BigDecimal> wrapper = entity -> {
            BigDecimal result = ((BigDecimal)propertyGetter.invoke(entity)).setScale(scale, 4);
            return result;
        };
        this.addColumn(columnName, 3, precision, scale, false, wrapper);
    }

    protected void mapReal(String columnName, Func2<TEntity, Float> propertyGetter) {
        this.addColumn(columnName, 7, propertyGetter);
    }

    protected void mapBigInt(String columnName, Func2<TEntity, BigInteger> propertyGetter) {
        Func2<Object, Long> wrapper = entity -> {
            BigInteger resultAsBigInteger = (BigInteger)propertyGetter.invoke(entity);
            return resultAsBigInteger.longValueExact();
        };
        this.addColumn(columnName, -5, wrapper);
    }

    protected void mapBigIntLong(String columnName, Func2<TEntity, Long> propertyGetter) {
        this.addColumn(columnName, -5, propertyGetter);
    }

    protected void mapDate(String columnName, Func2<TEntity, LocalDate> propertyGetter) {
        this.addColumn(columnName, 91, propertyGetter);
    }

    protected void mapDouble(String columnName, Func2<TEntity, Double> propertyGetter) {
        this.addColumn(columnName, 8, propertyGetter);
    }

    protected void mapInt(String columnName, Func2<TEntity, Integer> propertyGetter) {
        this.addColumn(columnName, 4, propertyGetter);
    }

    protected void mapSmallInt(String columnName, Func2<TEntity, Short> propertyGetter) {
        this.addColumn(columnName, 5, propertyGetter);
    }

    protected void mapTinyInt(String columnName, Func2<TEntity, Byte> propertyGetter) {
        this.addColumn(columnName, -6, propertyGetter);
    }

    protected void mapTimeWithTimeZone(String columnName, Func2<TEntity, OffsetTime> propertyGetter) {
        this.addColumn(columnName, 2013, propertyGetter);
    }

    protected void mapDateTimeWithTimeZone(String columnName, Func2<TEntity, OffsetDateTime> propertyGetter) {
        this.addColumn(columnName, 2014, propertyGetter);
    }

    protected void mapString(String columnName, Func2<TEntity, String> propertyGetter) {
        this.addColumn(columnName, -9, propertyGetter);
    }

    protected void mapVarBinary(String columnName, int maxLength, Func2<TEntity, byte[]> propertyGetter) {
        this.addColumn(columnName, -3, maxLength, 0, false, propertyGetter);
    }

    private void addColumn(String name, int type, boolean isAutoIncrement, Func2<TEntity, Object> propertyGetter) {
        ColumnMetaData columnMetaData = new ColumnMetaData(name, type, 0, 0, isAutoIncrement);
        this.addColumn(columnMetaData, propertyGetter);
    }

    private <TProperty> void addColumn(String name, int type, Func2<TEntity, TProperty> propertyGetter) {
        ColumnMetaData columnMetaData = new ColumnMetaData(name, type);
        this.addColumn(columnMetaData, propertyGetter);
    }

    private <TProperty> void addColumn(String name, int type, int precision, int scale, boolean isAutoIncrement, Func2<TEntity, TProperty> propertyGetter) {
        ColumnMetaData columnMetaData = new ColumnMetaData(name, type, precision, scale, isAutoIncrement);
        this.addColumn(columnMetaData, propertyGetter);
    }

    private <TProperty> void addColumn(ColumnMetaData columnMetaData, Func2<TEntity, TProperty> propertyGetter) {
        this.columns.add(new ColumnDefinition<TEntity>(columnMetaData, propertyGetter));
    }

    public TableDefinition getTableDefinition() {
        return this.table;
    }

    public List<ColumnDefinition<TEntity>> getColumns() {
        return this.columns;
    }
}

