/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert.records;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import de.bytefish.jsqlserverbulkinsert.model.ColumnDefinition;
import de.bytefish.jsqlserverbulkinsert.model.ColumnMetaData;
import de.bytefish.jsqlserverbulkinsert.records.SqlServerRecordBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SqlServerRecord<TEntity>
implements ISQLServerBulkRecord {
    private final Set<Integer> columnOrdinals;
    private final Iterator<TEntity> entities;
    private final List<ColumnMetaData> columnMetaData;
    private final SqlServerRecordBuilder<TEntity> builder;

    public SqlServerRecord(List<ColumnDefinition<TEntity>> columns, Iterator<TEntity> entities) {
        if (columns == null) {
            throw new IllegalArgumentException("columnDefinition");
        }
        if (entities == null) {
            throw new IllegalArgumentException("entities");
        }
        this.entities = entities;
        this.columnMetaData = columns.stream().map(ColumnDefinition::getColumnMetaData).collect(Collectors.toList());
        this.builder = new SqlServerRecordBuilder<TEntity>(columns);
        this.columnOrdinals = IntStream.range(1, this.columnMetaData.size() + 1).boxed().collect(Collectors.toSet());
    }

    public Set<Integer> getColumnOrdinals() {
        return this.columnOrdinals;
    }

    public String getColumnName(int i) {
        return this.columnMetaData.get(i - 1).getName();
    }

    public int getColumnType(int i) {
        return this.columnMetaData.get(i - 1).getType();
    }

    public int getPrecision(int i) {
        return this.columnMetaData.get(i - 1).getPrecision();
    }

    public int getScale(int i) {
        return this.columnMetaData.get(i - 1).getScale();
    }

    public boolean isAutoIncrement(int i) {
        return this.columnMetaData.get(i - 1).isAutoIncrement();
    }

    public Object[] getRowData() throws SQLServerException {
        TEntity entity = this.entities.next();
        return this.builder.build(entity);
    }

    public boolean next() throws SQLServerException {
        return this.entities.hasNext();
    }
}

