/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.jsqlserverbulkinsert;

import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import de.bytefish.jsqlserverbulkinsert.ISqlServerBulkInsert;
import de.bytefish.jsqlserverbulkinsert.mapping.AbstractMapping;
import de.bytefish.jsqlserverbulkinsert.records.SqlServerRecord;
import java.sql.Connection;
import java.util.stream.Stream;

public class SqlServerBulkInsert<TEntity>
implements ISqlServerBulkInsert<TEntity> {
    private final AbstractMapping<TEntity> mapping;

    public SqlServerBulkInsert(AbstractMapping<TEntity> mapping) {
        this.mapping = mapping;
    }

    @Override
    public void saveAll(Connection connection, Stream<TEntity> entities) {
        this.saveAll(connection, new SQLServerBulkCopyOptions(), entities);
    }

    public void saveAll(Connection connection, SQLServerBulkCopyOptions options, Stream<TEntity> entities) {
        try (SQLServerBulkCopy sqlServerBulkCopy = new SQLServerBulkCopy(connection);){
            sqlServerBulkCopy.setBulkCopyOptions(options);
            sqlServerBulkCopy.setDestinationTableName(this.mapping.getTableDefinition().GetFullQualifiedTableName());
            SqlServerRecord<TEntity> record = new SqlServerRecord<TEntity>(this.mapping.getColumns(), entities.iterator());
            sqlServerBulkCopy.writeToServer(record);
        }
        catch (SQLServerException e) {
            throw new RuntimeException(e);
        }
    }
}

