/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.settings;

import de.bytefish.fcmjava.client.utils.PropertiesUtils;
import de.bytefish.fcmjava.constants.Constants;
import de.bytefish.fcmjava.http.options.IFcmClientSettings;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Properties;

public class PropertiesBasedSettings
implements IFcmClientSettings {
    private final String fcmUrl;
    private final String fcmApiKey;

    protected PropertiesBasedSettings(Properties properties) {
        this.fcmUrl = properties.getProperty("fcm.api.url", Constants.FCM_URL);
        this.fcmApiKey = properties.getProperty("fcm.api.key");
    }

    public String getFcmUrl() {
        return this.fcmUrl;
    }

    public String getApiKey() {
        return this.fcmApiKey;
    }

    public static PropertiesBasedSettings createFromDefault() {
        String defaultPropertiesLocationString = System.getProperty("user.home") + "/.fcmjava/fcmjava.properties";
        Path defaultPropertiesLocationPath = FileSystems.getDefault().getPath(defaultPropertiesLocationString, new String[0]);
        return PropertiesBasedSettings.createFromFile(defaultPropertiesLocationPath, StandardCharsets.UTF_8);
    }

    public static PropertiesBasedSettings createFromFile(Path path, Charset charset) {
        Properties properties = PropertiesUtils.loadProperties(path, charset);
        return new PropertiesBasedSettings(properties);
    }

    public static PropertiesBasedSettings createFromSystemProperties() {
        Properties properties = System.getProperties();
        return new PropertiesBasedSettings(properties);
    }
}

