/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.elasticsearch6.utils;

import de.bytefish.elasticutils.elasticsearch6.mapping.IElasticSearchMapping;
import de.bytefish.elasticutils.exceptions.CreateIndexFailedException;
import de.bytefish.elasticutils.exceptions.IndicesExistsFailedException;
import de.bytefish.elasticutils.exceptions.PutMappingFailedException;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;

public class ElasticSearchUtils {
    private static final Logger log = Loggers.getLogger(ElasticSearchUtils.class, (String[])new String[]{ElasticSearchUtils.class.getName()});

    private ElasticSearchUtils() {
    }

    public static IndicesExistsResponse indexExist(Client client, String indexName) {
        try {
            return (IndicesExistsResponse)client.admin().indices().prepareExists(new String[]{indexName}).execute().actionGet();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Checking Index Exist", (Throwable)e);
            }
            throw new IndicesExistsFailedException(indexName, (Throwable)e);
        }
    }

    public static CreateIndexResponse createIndex(Client client, String indexName) {
        try {
            return ElasticSearchUtils.internalCreateIndex(client, indexName);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Creating Index", (Throwable)e);
            }
            throw new CreateIndexFailedException(indexName, (Throwable)e);
        }
    }

    public static AcknowledgedResponse putMapping(Client client, String indexName, IElasticSearchMapping mapping) {
        try {
            return ElasticSearchUtils.internalPutMapping(client, indexName, mapping);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Error Creating Index", (Throwable)e);
            }
            throw new PutMappingFailedException(indexName, (Throwable)e);
        }
    }

    private static CreateIndexResponse internalCreateIndex(Client client, String indexName) throws IOException {
        CreateIndexRequestBuilder createIndexRequestBuilder = client.admin().indices().prepareCreate(indexName);
        CreateIndexResponse indexResponse = (CreateIndexResponse)createIndexRequestBuilder.execute().actionGet();
        if (log.isDebugEnabled()) {
            log.debug("CreatedIndexResponse: isAcknowledged {}", (Object)indexResponse.isAcknowledged());
        }
        return indexResponse;
    }

    private static AcknowledgedResponse internalPutMapping(Client client, String indexName, IElasticSearchMapping mapping) throws IOException {
        String json = Strings.toString((XContentBuilder)mapping.getMapping());
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName}).type(mapping.getIndexType()).source(json, XContentType.JSON);
        AcknowledgedResponse putMappingResponse = (AcknowledgedResponse)client.admin().indices().putMapping(putMappingRequest).actionGet();
        if (log.isDebugEnabled()) {
            log.debug("PutMappingResponse: isAcknowledged {}", (Object)putMappingResponse.isAcknowledged());
        }
        return putMappingResponse;
    }
}

