/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.client.bulk.listener;

import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;

public class LoggingBulkProcessorListener
implements BulkProcessor.Listener {
    private static final ESLogger log = ESLoggerFactory.getLogger((String)LoggingBulkProcessorListener.class.getName());

    public void beforeBulk(long executionId, BulkRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("ExecutionId = {}, Actions = {}, Estimated Size = {}", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes()});
        }
    }

    public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
        if (log.isDebugEnabled()) {
            log.debug("ExecutionId = {}, Actions = {}, Estimated Size = {}", new Object[]{executionId, request.numberOfActions(), request.estimatedSizeInBytes()});
        }
    }

    public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
        if (log.isErrorEnabled()) {
            log.error("ExecutionId = {}, Error = {}", new Object[]{executionId, failure});
        }
    }
}

