/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.client;

import de.bytefish.elasticutils.client.IElasticSearchClient;
import de.bytefish.elasticutils.client.bulk.configuration.BulkProcessorConfiguration;
import de.bytefish.elasticutils.mapping.IElasticSearchMapping;
import de.bytefish.elasticutils.utils.JsonUtilities;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;

public class ElasticSearchClient<TEntity>
implements IElasticSearchClient<TEntity> {
    private final Client client;
    private final String indexName;
    private final IElasticSearchMapping mapping;
    private final BulkProcessor bulkProcessor;

    public ElasticSearchClient(Client client, String indexName, IElasticSearchMapping mapping, BulkProcessorConfiguration bulkProcessorConfiguration) {
        this.client = client;
        this.indexName = indexName;
        this.mapping = mapping;
        this.bulkProcessor = bulkProcessorConfiguration.build(client);
    }

    @Override
    public void index(TEntity entity) {
        this.index(Arrays.asList(entity));
    }

    @Override
    public void index(List<TEntity> entities) {
        this.index(entities.stream());
    }

    @Override
    public void index(Stream<TEntity> entities) {
        entities.map(x -> JsonUtilities.convertJsonToBytes(x)).filter(x -> x.isPresent()).map(x -> this.createIndexRequest((byte[])x.get())).forEach(arg_0 -> ((BulkProcessor)this.bulkProcessor).add(arg_0));
    }

    private IndexRequest createIndexRequest(byte[] messageBytes) {
        return (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex().setIndex(this.indexName)).setType(this.mapping.getIndexType()).setSource(messageBytes).request();
    }

    @Override
    public void flush() {
        this.bulkProcessor.flush();
    }

    @Override
    public synchronized boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        return this.bulkProcessor.awaitClose(timeout, unit);
    }

    @Override
    public void close() throws Exception {
        this.bulkProcessor.close();
    }
}

