/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;

public class JsonUtilities {
    private static final ESLogger log = ESLoggerFactory.getLogger((String)JsonUtilities.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <TEntity> Optional<byte[]> convertJsonToBytes(TEntity entity) {
        try {
            Optional.empty();
            return Optional.of(mapper.writeValueAsBytes(entity));
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(String.format("Failed to convert entity %s to JSON", entity), (Throwable)e, new Object[0]);
            }
            return Optional.empty();
        }
    }
}

