/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.mapping;

import de.bytefish.elasticutils.exceptions.GetMappingFailedException;
import de.bytefish.elasticutils.mapping.ElasticSearchMapping;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public abstract class BaseElasticSearchMapping
implements ElasticSearchMapping {
    private final String indexType;
    private final String version;

    public BaseElasticSearchMapping(String indexType, String version) {
        this.indexType = indexType;
        this.version = version;
    }

    @Override
    public XContentBuilder getMapping() {
        try {
            return this.internalGetMapping();
        }
        catch (Exception e) {
            throw new GetMappingFailedException(this.indexType, e);
        }
    }

    @Override
    public String getIndexType() {
        return this.indexType;
    }

    public XContentBuilder internalGetMapping() throws IOException {
        RootObjectMapper.Builder rootObjectMapperBuilder = this.getRootObjectBuilder();
        Settings.Builder settingsBuilder = this.getSettingsBuilder();
        Mapping mapping = new Mapping(Version.fromString((String)this.version), (RootObjectMapper)rootObjectMapperBuilder.build(new Mapper.BuilderContext(settingsBuilder.build(), new ContentPath())), new MetadataFieldMapper[0], new Mapping.SourceTransform[0], null);
        return mapping.toXContent(JsonXContent.contentBuilder().startObject(), ToXContent.EMPTY_PARAMS);
    }

    private Settings.Builder getSettingsBuilder() {
        Settings.Builder settingsBuilder = Settings.builder();
        this.configure(settingsBuilder);
        return settingsBuilder;
    }

    private RootObjectMapper.Builder getRootObjectBuilder() {
        RootObjectMapper.Builder rootObjectMapperBuilder = new RootObjectMapper.Builder(this.indexType);
        this.configure(rootObjectMapperBuilder);
        return rootObjectMapperBuilder;
    }

    protected abstract void configure(RootObjectMapper.Builder var1);

    protected abstract void configure(Settings.Builder var1);
}

