/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.elasticutils.client;

import de.bytefish.elasticutils.client.bulk.configuration.BulkProcessorConfiguration;
import de.bytefish.elasticutils.mapping.ElasticSearchMapping;
import de.bytefish.elasticutils.utils.ElasticSearchUtils;
import de.bytefish.elasticutils.utils.JsonUtilities;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;

public class ElasticSearchClient<TEntity>
implements AutoCloseable {
    private final Client client;
    private final String indexName;
    private final ElasticSearchMapping mapping;
    private final BulkProcessor bulkProcessor;

    public ElasticSearchClient(Client client, String indexName, ElasticSearchMapping mapping, BulkProcessorConfiguration bulkProcessorConfiguration) {
        this.client = client;
        this.indexName = indexName;
        this.mapping = mapping;
        this.bulkProcessor = bulkProcessorConfiguration.build(client);
    }

    public void createIndex() {
        if (!ElasticSearchUtils.indexExist(this.client, this.indexName).isExists()) {
            ElasticSearchUtils.createIndex(this.client, this.indexName);
        }
    }

    public void createMapping() {
        if (ElasticSearchUtils.indexExist(this.client, this.indexName).isExists()) {
            ElasticSearchUtils.putMapping(this.client, this.indexName, this.mapping);
        }
    }

    public void index(TEntity entity) {
        this.index(Arrays.asList(entity));
        this.bulkProcessor.flush();
    }

    public void index(List<TEntity> entities) {
        this.index(entities.stream());
    }

    public void index(Stream<TEntity> entities) {
        entities.map(x -> JsonUtilities.convertJsonToBytes(x)).filter(x -> x.isPresent()).map(x -> this.createIndexRequest((byte[])x.get())).forEach(arg_0 -> ((BulkProcessor)this.bulkProcessor).add(arg_0));
    }

    private IndexRequest createIndexRequest(byte[] messageBytes) {
        return (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex().setId(UUID.randomUUID().toString()).setIndex(this.indexName)).setType(this.mapping.getIndexType()).setSource(messageBytes).request();
    }

    @Override
    public void close() throws Exception {
    }
}

