/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.TestUtils;
import de.bwaldvogel.mongo.entity.Account;
import de.bwaldvogel.mongo.entity.Person;
import de.bwaldvogel.mongo.repository.AccountRepository;
import de.bwaldvogel.mongo.repository.PersonRepository;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@ContextConfiguration(classes={TestConfig.class})
public abstract class AbstractBackendSpringDataTest {
    public static final String DATABASE_NAME = "testdb";
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    private AccountRepository accountRepository;

    @Before
    public void deleteAll() throws Exception {
        this.accountRepository.deleteAll();
        this.personRepository.deleteAll();
    }

    @Test
    public void testSaveFindModifyAndUpdate() throws Exception {
        Person billy = (Person)this.personRepository.save(new Person("Billy", 123));
        this.personRepository.save(new Person("Joe", 456));
        Person savedBilly = this.personRepository.findOneByName(billy.getName());
        Assertions.assertThat((Comparable)savedBilly.getId()).isNotNull();
        Assertions.assertThat((String)savedBilly.getName()).isEqualTo((Object)billy.getName());
        Assertions.assertThat((int)savedBilly.getSocialSecurityNumber()).isEqualTo(billy.getSocialSecurityNumber());
        Assertions.assertThat(savedBilly.getAccounts()).isNull();
        for (Person person : this.personRepository.findAll()) {
            person.addAccount((Account)this.accountRepository.save(new Account(BigDecimal.ZERO)));
            this.personRepository.save(person);
        }
        savedBilly = this.personRepository.findOneByName(billy.getName());
        savedBilly.addAccount((Account)this.accountRepository.save(new Account(new BigDecimal("8915.35"))));
        this.personRepository.save(savedBilly);
        Person updatedPerson = this.personRepository.findOneByName(billy.getName());
        Assertions.assertThat(updatedPerson.getAccounts()).hasSize(2);
        List databaseNames = TestUtils.toArray(this.mongoClient.listDatabaseNames());
        Assertions.assertThat(databaseNames).containsOnly((Object[])new String[]{DATABASE_NAME});
        MongoDatabase database = this.mongoClient.getDatabase(DATABASE_NAME);
        List collectionNames = TestUtils.toArray(database.listCollectionNames());
        Assertions.assertThat(collectionNames).containsOnly((Object[])new String[]{"person", "account", "system.indexes"});
        Assertions.assertThat(TestUtils.toArray(this.personRepository.findAll())).hasSize(2);
        Assertions.assertThat((long)this.personRepository.count()).isEqualTo(2L);
        Assertions.assertThat((long)this.accountRepository.count()).isEqualTo(3L);
    }

    @Test
    public void testInsertDuplicateThrows() throws Exception {
        this.personRepository.save(new Person("Billy", 1));
        this.personRepository.save(new Person("Alice", 2));
        try {
            this.personRepository.save(new Person("Joe", 1));
            Assert.fail((String)"DuplicateKeyException expected");
        }
        catch (DuplicateKeyException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"duplicate key error"});
        }
    }

    @EnableMongoRepositories(value={"de.bwaldvogel.mongo.repository"})
    static class TestConfig {
        TestConfig() {
        }

        @Bean(destroyMethod="shutdown")
        public MongoServer mongoServer(MongoBackend backend) {
            return new MongoServer(backend);
        }

        @Bean(destroyMethod="close")
        public MongoClient mongoClient(MongoServer mongoServer) {
            InetSocketAddress serverAddress = mongoServer.bind();
            return new MongoClient(new ServerAddress(serverAddress));
        }

        @Bean
        public MongoDbFactory mongoDbFactory(MongoClient client) throws Exception {
            return new SimpleMongoDbFactory(client, AbstractBackendSpringDataTest.DATABASE_NAME);
        }

        @Bean
        public MongoTemplate mongoTemplate(MongoDbFactory factory) throws Exception {
            return new MongoTemplate(factory);
        }
    }
}

