/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.Assert;
import org.junit.Test;

public abstract class MongoServerTest {
    protected abstract MongoBackend createBackend() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testStopListening() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        MongoClient client = null;
        try {
            InetSocketAddress serverAddress = server.bind();
            client = new MongoClient(new ServerAddress(serverAddress));
            this.pingServer(client);
            server.stopListenting();
            this.pingServer(client);
            client.close();
            try (Socket socket = new Socket();){
                socket.connect(serverAddress);
                Assert.fail((String)"IOException expected");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
            server.shutdownNow();
        }
    }

    @Test(timeout=10000L)
    public void testShutdownNow() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        InetSocketAddress serverAddress = server.bind();
        MongoClient client = new MongoClient(new ServerAddress(serverAddress));
        this.pingServer(client);
        server.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testGetLocalAddress() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        Assertions.assertThat((Object)server.getLocalAddress()).isNull();
        try {
            InetSocketAddress serverAddress = server.bind();
            InetSocketAddress localAddress = server.getLocalAddress();
            Assertions.assertThat((Object)localAddress).isEqualTo((Object)serverAddress);
        }
        finally {
            server.shutdownNow();
        }
        Assertions.assertThat((Object)server.getLocalAddress()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testShutdownAndRestart() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        try {
            InetSocketAddress serverAddress = server.bind();
            try (MongoClient client = new MongoClient(new ServerAddress(serverAddress));){
                this.pingServer(client);
                server.shutdownNow();
                try {
                    this.pingServer(client);
                    Assert.fail((String)"MongoException expected");
                }
                catch (MongoException mongoException) {
                    // empty catch block
                }
                server.bind((SocketAddress)serverAddress);
                this.pingServer(client);
            }
        }
        finally {
            server.shutdownNow();
        }
    }

    private void pingServer(MongoClient client) {
        client.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
    }
}

