/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel;

import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoQueryException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class RealMongoDatabaseTest {
    private MongoClient mongoClient;
    private MongoCollection<Document> collection;

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((boolean)Boolean.getBoolean(this.getClass().getName() + ".enabled"));
        this.mongoClient = new MongoClient("localhost");
        this.collection = this.mongoClient.getDatabase("testdb").getCollection(this.getClass().getSimpleName());
        this.collection.deleteMany((Bson)new Document());
    }

    @After
    public void tearDown() throws Exception {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Test
    public void testEmptyArrayQuery() throws Exception {
        this.collection.insertOne((Object)TestUtils.json("_id: 1"));
        try {
            this.collection.find(Filters.and((Bson[])new Bson[0])).first();
            Assert.fail((String)"MongoQueryException expected");
        }
        catch (MongoQueryException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"must be a nonempty array"});
        }
    }

    @Test
    public void testFindAllReferences() throws Exception {
        this.collection.insertOne((Object)new Document("_id", (Object)1).append("ref", (Object)new DBRef("coll1", (Object)1)));
        this.collection.insertOne((Object)new Document("_id", (Object)2).append("ref", (Object)new DBRef("coll1", (Object)2)));
        this.collection.insertOne((Object)new Document("_id", (Object)3).append("ref", (Object)new DBRef("coll2", (Object)1)));
        this.collection.insertOne((Object)new Document("_id", (Object)4).append("ref", (Object)new DBRef("coll2", (Object)2)));
        List documents = TestUtils.toArray(this.collection.find((Bson)TestUtils.json("ref: {$ref: 'coll1', $id: 1}")).projection((Bson)TestUtils.json("_id: 1")));
        Assertions.assertThat(documents).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1")});
    }
}

