/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.ReadOnlyProxy;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractReadOnlyProxyTest {
    private MongoClient readOnlyClient;
    private MongoServer mongoServer;
    private MongoServer writeableServer;
    private MongoClient writeClient;

    protected abstract MongoBackend createBackend() throws Exception;

    @Before
    public void setUp() throws Exception {
        MongoBackend mongoBackend = this.createBackend();
        this.writeableServer = new MongoServer(mongoBackend);
        this.writeClient = new MongoClient(new ServerAddress(this.writeableServer.bind()));
        this.mongoServer = new MongoServer((MongoBackend)new ReadOnlyProxy(mongoBackend));
        this.readOnlyClient = new MongoClient(new ServerAddress(this.mongoServer.bind()));
    }

    @After
    public void tearDown() {
        this.writeClient.close();
        this.readOnlyClient.close();
        this.mongoServer.shutdownNow();
        this.writeableServer.shutdownNow();
    }

    @Test
    public void testMaxBsonSize() throws Exception {
        int maxBsonObjectSize = this.readOnlyClient.getMaxBsonObjectSize();
        Assertions.assertThat((int)maxBsonObjectSize).isEqualTo(0x1000000);
    }

    @Test
    public void testServerStatus() throws Exception {
        this.readOnlyClient.getDatabase("admin").runCommand((Bson)new Document("serverStatus", (Object)1));
    }

    @Test
    public void testCurrentOperations() throws Exception {
        Document currentOperations = (Document)this.readOnlyClient.getDatabase("admin").getCollection("$cmd.sys.inprog").find().first();
        Assertions.assertThat((Map)currentOperations).isNotNull();
    }

    @Test
    public void testStats() throws Exception {
        Document stats = this.readOnlyClient.getDatabase("testdb").runCommand((Bson)TestUtils.json("dbStats:1"));
        Assertions.assertThat((long)((Number)stats.get((Object)"objects")).longValue()).isZero();
    }

    @Test
    public void testListDatabaseNames() throws Exception {
        Assertions.assertThat((Iterable)this.readOnlyClient.listDatabaseNames()).isEmpty();
        this.writeClient.getDatabase("testdb").getCollection("testcollection").insertOne((Object)new Document());
        Assertions.assertThat(TestUtils.toArray(this.readOnlyClient.listDatabaseNames())).containsExactly((Object[])new String[]{"testdb"});
        this.writeClient.getDatabase("bar").getCollection("testcollection").insertOne((Object)new Document());
        Assertions.assertThat(TestUtils.toArray(this.readOnlyClient.listDatabaseNames())).containsExactly((Object[])new String[]{"bar", "testdb"});
    }

    @Test
    public void testIllegalCommand() throws Exception {
        try {
            this.readOnlyClient.getDatabase("testdb").runCommand((Bson)TestUtils.json("foo:1"));
            Assert.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no such cmd"});
        }
        try {
            this.readOnlyClient.getDatabase("bar").runCommand((Bson)TestUtils.json("foo:1"));
            Assert.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no such cmd"});
        }
    }

    @Test
    public void testQuery() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).first();
        Assertions.assertThat((Map)obj).isNull();
        Assertions.assertThat((long)collection.count()).isEqualTo(0L);
    }

    @Test
    public void testDistinctQuery() {
        MongoCollection collection = this.writeClient.getDatabase("testdb").getCollection("testcollection");
        collection.insertOne((Object)new Document("n", (Object)1));
        collection.insertOne((Object)new Document("n", (Object)2));
        collection.insertOne((Object)new Document("n", (Object)1));
        collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Assertions.assertThat(TestUtils.toArray(collection.distinct("n", Integer.class))).containsExactly((Object[])new Integer[]{1, 2});
    }

    @Test
    public void testInsert() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Assertions.assertThat((long)collection.count()).isEqualTo(0L);
        try {
            collection.insertOne((Object)TestUtils.json("{}"));
            Assert.fail((String)"exception expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdate() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Document object = new Document("_id", (Object)1);
        Document newObject = new Document("_id", (Object)1);
        try {
            collection.replaceOne((Bson)object, (Object)newObject);
            Assert.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no such cmd: update"});
        }
    }

    @Test
    public void testUpsert() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        try {
            collection.updateMany((Bson)TestUtils.json("{}"), Updates.set((String)"foo", (Object)"bar"), new UpdateOptions().upsert(true));
            Assert.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no such cmd: update"});
        }
    }

    @Test
    public void testDropDatabase() throws Exception {
        try {
            this.readOnlyClient.dropDatabase("testdb");
            Assert.fail((String)"MongoException expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    @Test
    public void testDropCollection() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("foo");
        try {
            collection.drop();
            Assert.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no such cmd: drop"});
        }
    }
}

