/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoDatabase;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TestUtils {
    private TestUtils() {
    }

    public static <T> List<T> toArray(Iterable<T> iterable) {
        ArrayList<T> array = new ArrayList<T>();
        for (T obj : iterable) {
            array.add(obj);
        }
        return array;
    }

    public static Document json(String string) {
        if (!(string = string.trim()).startsWith("{")) {
            string = "{" + string + "}";
        }
        return Document.parse((String)string);
    }

    public static List<Document> jsonList(String ... json) {
        return Stream.of(json).map(TestUtils::json).collect(Collectors.toList());
    }

    public static Document getCollectionStatistics(MongoDatabase database, String collectionName) {
        Document collStats = new Document("collStats", (Object)collectionName);
        return database.runCommand((Bson)collStats);
    }

    static Instant instant(String value) {
        return Instant.parse(value);
    }

    static Date date(String value) {
        return Date.from(TestUtils.instant(value));
    }

    public static InetSocketAddress toInetSocketAddress(String connectionString) {
        return TestUtils.toInetSocketAddress(new ConnectionString(connectionString));
    }

    public static InetSocketAddress toInetSocketAddress(ConnectionString connectionString) {
        String hostAndPort = (String)CollectionUtils.getSingleElement((Iterable)connectionString.getHosts());
        String[] hostAndPortArray = hostAndPort.split(":");
        String hostname = hostAndPortArray[0];
        int port = Integer.parseInt(hostAndPortArray[1]);
        return new InetSocketAddress(hostname, port);
    }
}

