/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestSubscriber<T>
implements Subscriber<T> {
    private static final Logger log = LoggerFactory.getLogger(TestSubscriber.class);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private T value;
    private Throwable throwable;
    private Subscription subscription;

    TestSubscriber() {
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(T value) {
        log.debug("onNext: {}", value);
        Assert.isNull(this.value, () -> "Got a second value: " + this.value + " and " + value);
        this.value = value;
        this.subscription.cancel();
        this.countDownLatch.countDown();
    }

    public void onError(Throwable throwable) {
        log.error("onError", throwable);
        this.throwable = throwable;
    }

    public void onComplete() {
        log.info("onComplete", this.throwable);
    }

    T awaitSingleValue() throws Exception {
        boolean success = this.countDownLatch.await(30L, TimeUnit.SECONDS);
        Assert.isTrue((boolean)success, () -> "Failed waiting countdown latch");
        if (this.throwable != null) {
            throw new RuntimeException(this.throwable);
        }
        Assert.notNull(this.value, () -> "Got no value yet");
        return this.value;
    }
}

