/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.TestClock;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractTest.class);
    protected static final String ADMIN_DB_NAME = "admin";
    protected static final String TEST_DATABASE_NAME = "testdb";
    protected static final TestClock clock = TestClock.defaultClock();
    protected static MongoClient syncClient;
    protected static MongoDatabase db;
    protected static MongoCollection<Document> collection;
    static com.mongodb.reactivestreams.client.MongoCollection<Document> asyncCollection;
    static com.mongodb.reactivestreams.client.MongoDatabase asyncDb;
    private static MongoServer mongoServer;
    private static com.mongodb.reactivestreams.client.MongoClient asyncClient;
    protected static ConnectionString connectionString;
    protected static MongoBackend backend;

    protected abstract MongoBackend createBackend() throws Exception;

    @BeforeEach
    public void setUp() throws Exception {
        clock.reset();
        if (connectionString == null) {
            this.setUpBackend();
            AbstractTest.setUpClients();
        } else {
            this.dropAllDatabases();
        }
    }

    @AfterEach
    void assertNoOpenCursors() throws Exception {
        for (int i = 0; i < 50; ++i) {
            long numberOfOpenCursors = this.getNumberOfOpenCursors();
            if (numberOfOpenCursors == 0L) {
                return;
            }
            log.warn("Found {} open cursors. Waiting trial {}", (Object)numberOfOpenCursors, (Object)(i + 1));
            Thread.sleep(100L);
        }
        AbstractTest.assertThat(this.getNumberOfOpenCursors()).isZero();
    }

    protected void dropAllDatabases() {
        for (String databaseName : syncClient.listDatabaseNames()) {
            if (databaseName.equals(ADMIN_DB_NAME) || databaseName.equals("local")) continue;
            syncClient.getDatabase(databaseName).drop();
        }
    }

    protected void killCursors(List<Long> cursorIds) {
        mongoServer.closeCursors(cursorIds);
    }

    @AfterAll
    public static void tearDown() {
        AbstractTest.closeClients();
        AbstractTest.tearDownBackend();
    }

    private static void setUpClients() throws Exception {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).uuidRepresentation(UuidRepresentation.STANDARD).build();
        syncClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
        asyncClient = com.mongodb.reactivestreams.client.MongoClients.create((ConnectionString)connectionString);
        db = syncClient.getDatabase(TEST_DATABASE_NAME);
        collection = db.getCollection("testcoll");
        MongoNamespace namespace = collection.getNamespace();
        asyncDb = asyncClient.getDatabase(namespace.getDatabaseName());
        asyncCollection = asyncDb.getCollection(namespace.getCollectionName());
    }

    protected void setUpBackend() throws Exception {
        backend = this.createBackend();
        mongoServer = new MongoServer(backend);
        connectionString = new ConnectionString(mongoServer.bindAndGetConnectionString());
    }

    private static void closeClients() {
        if (syncClient != null) {
            syncClient.close();
        }
        if (asyncClient != null) {
            asyncClient.close();
        }
    }

    private static void tearDownBackend() {
        if (mongoServer != null) {
            mongoServer.shutdownNow();
            mongoServer = null;
        }
        connectionString = null;
    }

    protected void restart() throws Exception {
        AbstractTest.tearDown();
        this.setUp();
    }

    protected static MapAssert<String, Object> assertThat(Document actual) {
        return Assertions.assertThat((Map)actual);
    }

    protected static AbstractLongAssert<?> assertThat(Long actual) {
        return Assertions.assertThat((Long)actual);
    }

    protected static AbstractDoubleAssert<?> assertThat(Double actual) {
        return Assertions.assertThat((Double)actual);
    }

    protected static AbstractStringAssert<?> assertThat(String actual) {
        return Assertions.assertThat((String)actual);
    }

    protected static <T> ObjectAssert<T> assertThat(T actual) {
        return Assertions.assertThat(actual);
    }

    protected static AbstractIntegerAssert<?> assertThat(Integer actual) {
        return Assertions.assertThat((Integer)actual);
    }

    protected static AbstractBooleanAssert<?> assertThat(Boolean actual) {
        return Assertions.assertThat((Boolean)actual);
    }

    protected static <T> IterableAssert<T> assertThat(Iterable<T> actual) {
        List<T> values = TestUtils.toArray(actual);
        return Assertions.assertThat(values);
    }

    protected static AbstractThrowableAssert<?, ? extends Throwable> assertThat(Throwable actual) {
        return Assertions.assertThat((Throwable)actual);
    }

    protected List<String> listDatabaseNames() {
        ArrayList<String> databaseNames = new ArrayList<String>();
        for (String databaseName : syncClient.listDatabaseNames()) {
            databaseNames.add(databaseName);
        }
        return databaseNames;
    }

    protected Document runCommand(String commandName) {
        return this.runCommand(new Document(commandName, (Object)1));
    }

    protected Document runCommand(Document command) {
        return this.getAdminDb().runCommand((Bson)command);
    }

    protected MongoDatabase getAdminDb() {
        return syncClient.getDatabase(ADMIN_DB_NAME);
    }

    protected long getNumberOfOpenCursors() {
        Document serverStatus = this.runCommand("serverStatus");
        AbstractTest.assertThat(serverStatus.getDouble((Object)"ok")).isEqualTo(1.0);
        Document metrics = (Document)serverStatus.get((Object)"metrics", Document.class);
        Document cursorMetrics = (Document)metrics.get((Object)"cursor", Document.class);
        Document openCursors = (Document)cursorMetrics.get((Object)"open", Document.class);
        return openCursors.getLong((Object)"total");
    }

    protected void awaitNumberOfOpenCursors(long expectedNumberOfOpenCursors) throws Exception {
        long numberOfOpenCursors = 0L;
        for (int i = 0; i < 10; ++i) {
            numberOfOpenCursors = this.getNumberOfOpenCursors();
            if (numberOfOpenCursors == expectedNumberOfOpenCursors) {
                return;
            }
            Thread.sleep(10L);
        }
        throw new RuntimeException("Failed waiting for " + expectedNumberOfOpenCursors + " open cursors. Current: " + numberOfOpenCursors + " open cursors");
    }
}

