/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.client.model.UpdateOptions;
import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.TestUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPerformanceTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractPerformanceTest.class);

    @Test
    @EnabledIfSystemProperty(named="run-mongo-java-server-performance-tests", matches="true")
    public void testComplexUpsert() throws Exception {
        Document incUpdate = new Document();
        Document updateQuery = new Document("$inc", (Object)incUpdate);
        incUpdate.put("version", (Object)1);
        for (int hour = 0; hour < 24; ++hour) {
            for (int minute = 0; minute < 60; ++minute) {
                incUpdate.put("data." + hour + "." + minute + ".requests", (Object)0);
                incUpdate.put("data." + hour + "." + minute + ".responses", (Object)0);
                incUpdate.put("data." + hour + "." + minute + ".duration", (Object)0);
            }
        }
        for (int i = 0; i < 10; ++i) {
            long start = System.currentTimeMillis();
            collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)updateQuery, new UpdateOptions().upsert(true));
            long stop = System.currentTimeMillis();
            log.info("Update took {} ms", (Object)(stop - start));
        }
    }
}

