/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.DBRef;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerCursor;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.bson.BsonInt32;
import org.bson.BsonJavaScript;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public abstract class AbstractBackendTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractBackendTest.class);
    protected static final String OTHER_TEST_DATABASE_NAME = "bar";
    private static final Duration DEFAULT_TEST_TIMEOUT = Duration.ofSeconds(30L);

    protected MongoCollection<Document> getCollection(String collectionName) {
        return db.getCollection(collectionName);
    }

    private String getCollectionName() {
        return collection.getNamespace().getCollectionName();
    }

    @Test
    public void testSimpleInsert() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testSimpleCursor() {
        int expectedCount = 20;
        int batchSize = 10;
        for (int i = 0; i < expectedCount; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)(100 + i)));
        }
        MongoCursor cursor = collection.find().sort((Bson)TestUtils.json("_id: 1")).batchSize(batchSize).cursor();
        ArrayList<Document> retrievedDocuments = new ArrayList<Document>();
        while (cursor.hasNext()) {
            retrievedDocuments.add((Document)cursor.next());
        }
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MongoCursor)cursor).next()).withMessage(null);
        AbstractBackendTest.assertThat(retrievedDocuments).hasSize(expectedCount);
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).first()).isEqualTo((Object)TestUtils.json("_id: 100"));
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).last()).isEqualTo((Object)TestUtils.json("_id: 119"));
    }

    @Test
    public void testCursor_skipDocuments() {
        int totalCount = 20;
        int numToSkip = 5;
        int expectedCount = totalCount - numToSkip;
        int batchSize = 10;
        for (int i = 0; i < totalCount; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)(100 + i)));
        }
        MongoCursor cursor = collection.find().sort((Bson)TestUtils.json("_id: 1")).skip(numToSkip).batchSize(batchSize).cursor();
        ArrayList<Document> retrievedDocuments = new ArrayList<Document>();
        while (cursor.hasNext()) {
            retrievedDocuments.add((Document)cursor.next());
        }
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MongoCursor)cursor).next()).withMessage(null);
        AbstractBackendTest.assertThat(retrievedDocuments).hasSize(expectedCount);
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).first()).isEqualTo((Object)TestUtils.json("_id: 105"));
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).last()).isEqualTo((Object)TestUtils.json("_id: 119"));
    }

    @Test
    public void testCursor_skipAndLimitDocuments() {
        int totalCount = 50;
        int numToSkip = 5;
        int limit = 20;
        int batchSize = 10;
        for (int i = 0; i < totalCount; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)(100 + i)));
        }
        MongoCursor cursor = collection.find().sort((Bson)TestUtils.json("_id: 1")).skip(numToSkip).limit(limit).batchSize(batchSize).cursor();
        ArrayList<Document> retrievedDocuments = new ArrayList<Document>();
        while (cursor.hasNext()) {
            retrievedDocuments.add((Document)cursor.next());
        }
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MongoCursor)cursor).next()).withMessage(null);
        AbstractBackendTest.assertThat(retrievedDocuments).hasSize(limit);
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).first()).isEqualTo((Object)TestUtils.json("_id: 105"));
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).last()).isEqualTo((Object)TestUtils.json("_id: 124"));
    }

    @Test
    public void testCursor_withProjection() {
        int totalCount = 50;
        int numToSkip = 5;
        int limit = 20;
        int batchSize = 10;
        for (int i = 0; i < totalCount; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)(100 + i)).append("x", (Object)(1000 + i)));
        }
        MongoCursor cursor = collection.find().sort((Bson)TestUtils.json("_id: 1")).skip(numToSkip).limit(limit).batchSize(batchSize).projection((Bson)TestUtils.json("_id: 0, x: 1")).cursor();
        ArrayList<Document> retrievedDocuments = new ArrayList<Document>();
        while (cursor.hasNext()) {
            retrievedDocuments.add((Document)cursor.next());
        }
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((MongoCursor)cursor).next()).withMessage(null);
        AbstractBackendTest.assertThat(retrievedDocuments).hasSize(limit);
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).first()).isEqualTo((Object)TestUtils.json("x: 1005"));
        ((ObjectAssert)AbstractBackendTest.assertThat(retrievedDocuments).last()).isEqualTo((Object)TestUtils.json("x: 1024"));
    }

    @Test
    public void testCloseCursor() {
        int count;
        int expectedCount = 20;
        int batchSize = 5;
        for (int i = 0; i < expectedCount; ++i) {
            collection.insertOne((Object)new Document("value", (Object)i));
        }
        MongoCursor cursor = collection.find().batchSize(batchSize).cursor();
        for (count = 0; cursor.hasNext() && count < 10; ++count) {
            cursor.next();
        }
        cursor.close();
        AbstractBackendTest.assertThat(count).isEqualTo(10);
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((MongoCursor)cursor).next()).withMessage("Cursor has been closed");
    }

    @Test
    public void testCursor_iteratingACursorThatNoLongerExists() {
        int expectedCount = 20;
        for (int i = 0; i < expectedCount; ++i) {
            collection.insertOne((Object)new Document("name", (Object)"testUser1"));
        }
        MongoCursor cursor = collection.find().batchSize(1).cursor();
        cursor.next();
        this.killCursors(Collections.singletonList(cursor.getServerCursor().getId()));
        Assertions.assertThatExceptionOfType(MongoCursorNotFoundException.class).isThrownBy(() -> ((MongoCursor)cursor).next()).withMessageMatching("Command failed with error 43 \\(CursorNotFound\\): 'Cursor id \\d+ does not exist'.+");
    }

    @Test
    void testKillCursor() throws Exception {
        for (int i = 0; i < 20; ++i) {
            collection.insertOne((Object)TestUtils.json(""));
        }
        MongoCursor cursor = collection.find().batchSize(1).cursor();
        ServerCursor serverCursor = cursor.getServerCursor();
        String collectionName = collection.getNamespace().getCollectionName();
        Document result = this.runCommand(new Document("killCursors", (Object)collectionName).append("cursors", Arrays.asList(serverCursor.getId())));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(result.get((Object)"cursorsKilled")).isEqualTo(Arrays.asList(serverCursor.getId()));
        AbstractBackendTest.assertThat(result.get((Object)"cursorsNotFound")).isEqualTo(Collections.emptyList());
    }

    @Test
    void testKillCursor_unknownCursorId() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        String collectionName = collection.getNamespace().getCollectionName();
        Document result = this.runCommand(new Document("killCursors", (Object)collectionName).append("cursors", Arrays.asList(987654321L)));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(result.get((Object)"cursorsKilled")).isEqualTo(Collections.emptyList());
        AbstractBackendTest.assertThat(result.get((Object)"cursorsNotFound")).isEqualTo(Arrays.asList(987654321L));
    }

    @Test
    public void testSimpleInsertDelete() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.deleteOne((Bson)TestUtils.json("_id: 1"));
    }

    @Test
    public void testCreateCollection() throws Exception {
        String newCollectionName = "some-collection";
        AbstractBackendTest.assertThat(db.listCollectionNames()).doesNotContain((Object[])new String[]{newCollectionName});
        db.createCollection(newCollectionName, new CreateCollectionOptions());
        AbstractBackendTest.assertThat(db.listCollectionNames()).contains((Object[])new String[]{newCollectionName});
    }

    @Test
    public void testCreateCappedCollection_invalidOptions() throws Exception {
        String newCollectionName = "some-collection";
        AbstractBackendTest.assertThat(db.listCollectionNames()).doesNotContain((Object[])new String[]{newCollectionName});
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.createCollection("some-collection", new CreateCollectionOptions().capped(true))).withMessageContaining("Command failed with error 72 (InvalidOptions): 'the 'size' field is required when 'capped' is true'");
    }

    @Test
    public void testCreateCollectionAlreadyExists() throws Exception {
        db.createCollection("some-collection", new CreateCollectionOptions());
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.createCollection("some-collection", new CreateCollectionOptions())).withMessageContaining("Command failed with error 48 (NamespaceExists): 'a collection 'testdb.some-collection' already exists'");
    }

    @Test
    public void testUnsupportedModifier() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$foo: {}")), 9, "FailedToParse", "Unknown modifier: $foo. Expected a valid update modifier or pipeline-style update specified as an array");
    }

    @Test
    public void testUpsertWithInc() {
        Document query = TestUtils.json("_id: {f: 'ca', '1': {l: 2}, t: {t: 11}}");
        Document update = TestUtils.json("'$inc': {'n.!' : 1 , 'n.a.b:false' : 1}");
        collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        query.putAll((Map)TestUtils.json("n: {'!': 1, a: {'b:false': 1}}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)query);
    }

    @Test
    public void testBasicUpdate() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, b: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.replaceOne((Bson)TestUtils.json("_id: 2"), (Object)TestUtils.json("_id: 2, a: 5"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 2")).first()).isEqualTo((Object)TestUtils.json("_id: 2, a: 5"));
    }

    @Test
    public void testCollectionStats_newCollection() throws Exception {
        Document stats = this.getCollStats();
        AbstractBackendTest.assertThat(stats.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"count")).isEqualTo(0);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"size")).isEqualTo(0);
        AbstractBackendTest.assertThat(stats).doesNotContainKey((Object)"avgObjSize");
        AbstractBackendTest.assertThat(db.listCollectionNames()).doesNotContain((Object[])new String[]{this.getCollectionName()});
    }

    @Test
    public void testCollectionStats() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        collection.insertOne((Object)TestUtils.json("abc: 'foo'"));
        Document stats = this.getCollStats();
        AbstractBackendTest.assertThat(stats.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"count")).isEqualTo(2);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"size")).isEqualTo(57);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"avgObjSize")).isEqualTo(28);
    }

    private Document getCollStats() {
        String collectionName = this.getCollectionName();
        return TestUtils.getCollectionStatistics(db, collectionName);
    }

    @Test
    public void testGetLogStartupWarnings() throws Exception {
        Document startupWarnings = this.runCommand(TestUtils.json("getLog: 'startupWarnings'"));
        AbstractBackendTest.assertThat(startupWarnings.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(startupWarnings.get((Object)"totalLinesWritten")).isInstanceOf(Number.class);
        AbstractBackendTest.assertThat(startupWarnings.get((Object)"log")).isEqualTo(Collections.emptyList());
    }

    @Test
    public void testGetLogWhichDoesNotExist() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.runCommand(TestUtils.json("getLog: 'illegal'"))).withMessageContaining("Command failed with error -1: 'no RamLog named: illegal'");
    }

    @Test
    public void testCompoundDateIdUpserts() {
        Document query = TestUtils.json("_id: {$lt: {n: 'a', t: 10}, $gte: {n: 'a', t: 1}}");
        List<Document> toUpsert = Arrays.asList(TestUtils.json("_id: {n: 'a', t: 1}"), TestUtils.json("_id: {n: 'a', t: 2}"), TestUtils.json("_id: {n: 'a', t: 3}"), TestUtils.json("_id: {n: 'a', t: 11}"));
        for (Document dbo : toUpsert) {
            collection.replaceOne((Bson)dbo, (Object)new Document((Map)dbo).append("foo", (Object)OTHER_TEST_DATABASE_NAME), new ReplaceOptions().upsert(true));
        }
        AbstractBackendTest.assertThat(collection.find((Bson)query)).containsExactly((Object[])new Document[]{TestUtils.json("_id: {n: 'a', t: 1}, foo: 'bar'"), TestUtils.json("_id: {n: 'a', t: 2}, foo: 'bar'"), TestUtils.json("_id: {n: 'a', t: 3}, foo: 'bar'")});
    }

    @Test
    public void testCompoundSort() {
        collection.insertOne((Object)TestUtils.json("a:1, _id: 1"));
        collection.insertOne((Object)TestUtils.json("a:2, _id: 5"));
        collection.insertOne((Object)TestUtils.json("a:1, _id: 2"));
        collection.insertOne((Object)TestUtils.json("a:2, _id: 4"));
        collection.insertOne((Object)TestUtils.json("a:1, _id: 3"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("a:1, _id: -1"))).containsExactly((Object[])new Document[]{TestUtils.json("a: 1, _id: 3"), TestUtils.json("a: 1, _id: 2"), TestUtils.json("a: 1, _id: 1"), TestUtils.json("a: 2, _id: 5"), TestUtils.json("a: 2, _id: 4")});
    }

    @Test
    public void testCountCommand() {
        AbstractBackendTest.assertThat(db.runCommand((Bson)new Document("count", (Object)this.getCollectionName()))).isEqualTo((Object)TestUtils.json("ok: 1.0, n: 0"));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractBackendTest.assertThat(db.runCommand((Bson)new Document("count", (Object)this.getCollectionName()).append("query", (Object)TestUtils.json("_id: 2")))).isEqualTo((Object)TestUtils.json("ok: 1.0, n: 1"));
        AbstractBackendTest.assertThat(db.runCommand((Bson)new Document("count", (Object)this.getCollectionName()).append("query", (Object)TestUtils.json("")))).isEqualTo((Object)TestUtils.json("ok: 1.0, n: 3"));
        AbstractBackendTest.assertThat(db.runCommand((Bson)new Document("count", (Object)this.getCollectionName()).append("query", (Object)TestUtils.json("_id: 4")))).isEqualTo((Object)TestUtils.json("ok: 1.0, n: 0"));
        AbstractBackendTest.assertThat(db.runCommand((Bson)new Document("count", (Object)this.getCollectionName()).append("maxTimeMS", (Object)5000))).isEqualTo((Object)TestUtils.json("ok: 1.0, n: 3"));
    }

    @Test
    public void testNonPrimaryCountCommand() {
        AbstractBackendTest.assertThat(collection.withReadPreference(ReadPreference.nearest()).countDocuments()).isZero();
    }

    @Test
    public void testCountCommandWithQuery() {
        collection.insertOne((Object)TestUtils.json("n:1"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("n:2"))).isEqualTo(2L);
    }

    @Test
    public void testCountCommandWithSkipAndLimit() {
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.insertOne((Object)TestUtils.json("x: 2"));
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.insertOne((Object)TestUtils.json("x: 2"));
        collection.insertOne((Object)TestUtils.json("x: 1"));
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("x: 1"), new CountOptions().skip(4).limit(2))).isEqualTo(0L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("x: 1"), new CountOptions().limit(3))).isEqualTo(3L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("x: 1"), new CountOptions().limit(10))).isEqualTo(4L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("x: 1"), new CountOptions().skip(1))).isEqualTo(3L);
    }

    @Test
    public void testCountDocuments() throws Exception {
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testCountDocumentsWithQuery() {
        collection.insertOne((Object)TestUtils.json("n:1"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("n:2"))).isEqualTo(2L);
    }

    @Test
    public void testEstimatedDocumentCount() throws Exception {
        AbstractBackendTest.assertThat(collection.estimatedDocumentCount()).isEqualTo(0L);
        collection.insertOne((Object)TestUtils.json("n:1"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        AbstractBackendTest.assertThat(collection.estimatedDocumentCount()).isEqualTo(3L);
        AbstractBackendTest.assertThat(collection.estimatedDocumentCount(new EstimatedDocumentCountOptions().maxTime(1L, TimeUnit.SECONDS))).isEqualTo(3L);
    }

    @Test
    public void testCreateIndexes() {
        collection.createIndex((Bson)new Document("n", (Object)1));
        collection.createIndex((Bson)new Document("b", (Object)1));
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {n: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"n_1").append("v", (Object)2), TestUtils.json("key: {b: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"b_1").append("v", (Object)2)});
    }

    @Test
    public void testCreateIndexesWithoutNamespace() {
        collection.insertOne((Object)TestUtils.json("_id: 1, b: 1"));
        Document result = db.runCommand((Bson)TestUtils.json("createIndexes: 'testcoll', indexes: [{key: {b: 1}, name: 'b_1'}]"));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {b: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"b_1").append("v", (Object)2)});
    }

    @Test
    public void testCreateSecondPrimaryKeyIndex() {
        collection.insertOne((Object)TestUtils.json("_id: 1, b: 1"));
        Document result = db.runCommand((Bson)TestUtils.json("createIndexes: 'testcoll', indexes: [{key: {_id: 1}, name: '_id_1'}]"));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2)});
        db.drop();
    }

    @Test
    public void testCreateIndexOnNonExistingDatabase() {
        db.drop();
        Document result = db.runCommand((Bson)TestUtils.json("createIndexes: 'sometable', indexes: [{key: {_id: 1}, name: '_id_1'}]"));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        db.drop();
    }

    @Test
    public void testDropAndRecreateIndex() throws Exception {
        collection.createIndex((Bson)new Document("n", (Object)1));
        collection.createIndex((Bson)new Document("b", (Object)1));
        collection.createIndex((Bson)new Document("c", (Object)1), new IndexOptions().unique(true));
        collection.dropIndex((Bson)new Document("n", (Object)1));
        collection.insertOne((Object)TestUtils.json("_id: 1, c: 10"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.dropIndex((Bson)new Document("n", (Object)1))).withMessageContaining("Command failed with error 27 (IndexNotFound): 'can't find index with key: { n: 1 }'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 2, c: 10")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: c_1 dup key: { c: 10 }");
        collection.dropIndex((Bson)new Document("c", (Object)1));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.dropIndex((Bson)new Document("c", (Object)1))).withMessageContaining("Command failed with error 27 (IndexNotFound): 'can't find index with key: { c: 1 }'");
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {b: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"b_1").append("v", (Object)2)});
        collection.insertOne((Object)TestUtils.json("_id: 2, c: 10"));
        Assertions.assertThatExceptionOfType(DuplicateKeyException.class).isThrownBy(() -> collection.createIndex((Bson)new Document("c", (Object)1), new IndexOptions().unique(true))).withMessageContaining("Write failed with error code 11000 and error message 'E11000 duplicate key error collection: testdb.testcoll index: c_1 dup key:");
        collection.deleteOne((Bson)TestUtils.json("_id: 1"));
        collection.createIndex((Bson)new Document("c", (Object)1), new IndexOptions().unique(true));
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {b: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"b_1").append("v", (Object)2), TestUtils.json("key: {c: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"c_1").append("unique", (Object)true).append("v", (Object)2)});
    }

    @Test
    void testDropIndexes() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, c: 10"));
        collection.createIndex((Bson)new Document("c", (Object)1), new IndexOptions().unique(true));
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {c: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"c_1").append("unique", (Object)true).append("v", (Object)2)});
        collection.dropIndexes();
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2)});
        collection.dropIndexes();
        collection.drop();
        collection.dropIndexes();
    }

    @Test
    void testDropIndex_string() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, c: 10"));
        String indexName = collection.createIndex((Bson)new Document("c", (Object)1), new IndexOptions().unique(true));
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(2);
        collection.dropIndex(indexName);
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(1);
        collection.insertOne((Object)TestUtils.json("_id: 2, c: 10"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.dropIndex(indexName)).withMessageContaining("Command failed with error 27 (IndexNotFound): 'index not found with name [c_1]'");
    }

    @Test
    void testDropIndex_null() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, c: 10"));
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> collection.dropIndex((String)null)).withMessage("indexName can not be null");
    }

    @Test
    void testDropIndexes_twoIndexesWithTheSameKey() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, c: 10"));
        MongoCollection<Document> otherCollection = this.getCollection("other");
        otherCollection.insertOne((Object)TestUtils.json("_id: 1, c: 10"));
        collection.createIndex((Bson)new Document("c", (Object)1));
        otherCollection.createIndex((Bson)new Document("c", (Object)1));
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {c: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"c_1").append("v", (Object)2)});
        AbstractBackendTest.assertThat(otherCollection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)otherCollection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {c: 1}").append("ns", (Object)otherCollection.getNamespace().getFullName()).append("name", (Object)"c_1").append("v", (Object)2)});
        collection.dropIndex((Bson)TestUtils.json("c: 1"));
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2)});
        AbstractBackendTest.assertThat(otherCollection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)otherCollection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {c: 1}").append("ns", (Object)otherCollection.getNamespace().getFullName()).append("name", (Object)"c_1").append("v", (Object)2)});
    }

    @Test
    public void testCurrentOperations() throws Exception {
        Document currentOperations = (Document)this.getAdminDb().getCollection("$cmd.sys.inprog").find().first();
        AbstractBackendTest.assertThat(currentOperations).isNotNull();
        AbstractBackendTest.assertThat(currentOperations.get((Object)"inprog")).isInstanceOf(List.class);
    }

    @Test
    public void testListCollectionsEmpty() throws Exception {
        Document result = db.runCommand((Bson)TestUtils.json("listCollections: 1"));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        Document cursor = (Document)result.get((Object)"cursor");
        AbstractBackendTest.assertThat(cursor.keySet()).containsExactly((Object[])new String[]{"id", "ns", "firstBatch"});
        AbstractBackendTest.assertThat(cursor.get((Object)"id")).isEqualTo((Object)0L);
        AbstractBackendTest.assertThat(cursor.get((Object)"ns")).isEqualTo((Object)(db.getName() + ".$cmd.listCollections"));
        List firstBatch = (List)cursor.get((Object)"firstBatch");
        AbstractBackendTest.assertThat(firstBatch).isEmpty();
    }

    @Test
    public void testListCollections() throws Exception {
        List<String> collections = Arrays.asList("coll1", "coll2", "coll3");
        for (String collection : collections) {
            this.getCollection(collection).insertOne((Object)TestUtils.json("_id: 1"));
        }
        Document result = db.runCommand((Bson)TestUtils.json("listCollections: 1"));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        Document cursor = (Document)result.get((Object)"cursor");
        AbstractBackendTest.assertThat(cursor.keySet()).containsExactly((Object[])new String[]{"id", "ns", "firstBatch"});
        AbstractBackendTest.assertThat(cursor.get((Object)"id")).isEqualTo((Object)0L);
        AbstractBackendTest.assertThat(cursor.get((Object)"ns")).isEqualTo((Object)(db.getName() + ".$cmd.listCollections"));
        AbstractBackendTest.assertThat(cursor.get((Object)"firstBatch")).isInstanceOf(List.class);
        List firstBatch = (List)cursor.get((Object)"firstBatch");
        AbstractBackendTest.assertThat(firstBatch).hasSameSizeAs(collections);
        HashSet<String> collectionNames = new HashSet<String>();
        for (Document collection : firstBatch) {
            AbstractBackendTest.assertThat(collection).containsOnlyKeys((Object[])new String[]{"name", "options", "type", "idIndex", "info"});
            String name = (String)collection.get((Object)"name");
            AbstractBackendTest.assertThat(collection.get((Object)"options")).isEqualTo((Object)TestUtils.json(""));
            AbstractBackendTest.assertThat(collection.get((Object)"name")).isInstanceOf(String.class);
            AbstractBackendTest.assertThat(collection.get((Object)"type")).isEqualTo((Object)"collection");
            AbstractBackendTest.assertThat(collection.get((Object)"idIndex")).isEqualTo((Object)TestUtils.json("key: {_id: 1}, name: '_id_', ns: 'testdb." + name + "', v: 2"));
            AbstractBackendTest.assertThat(collection.get((Object)"info")).isInstanceOf(Document.class);
            collectionNames.add(name);
        }
        AbstractBackendTest.assertThat(collectionNames).containsExactlyInAnyOrderElementsOf(collections);
    }

    @Test
    public void testGetCollectionNames() throws Exception {
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection(OTHER_TEST_DATABASE_NAME).insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertThat(db.listCollectionNames()).containsExactlyInAnyOrder((Object[])new String[]{"foo", OTHER_TEST_DATABASE_NAME});
    }

    @Test
    public void testSystemNamespaces() throws Exception {
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection(OTHER_TEST_DATABASE_NAME).insertOne((Object)TestUtils.json(""));
        MongoCollection namespaces = db.getCollection("system.namespaces");
        AbstractBackendTest.assertThat(namespaces.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("name: 'testdb.foo'"), TestUtils.json("name: 'testdb.bar'")});
    }

    @Test
    public void testDatabaseStats() throws Exception {
        Document stats = db.runCommand((Bson)new Document("dbStats", (Object)1).append("scale", (Object)1));
        AbstractBackendTest.assertThat(stats.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"objects")).isZero();
        AbstractBackendTest.assertThat(stats.getInteger((Object)"collections")).isZero();
        AbstractBackendTest.assertThat(stats.getInteger((Object)"indexes")).isZero();
        AbstractBackendTest.assertThat(stats.getInteger((Object)"dataSize")).isZero();
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection(OTHER_TEST_DATABASE_NAME).insertOne((Object)TestUtils.json(""));
        stats = db.runCommand((Bson)new Document("dbStats", (Object)1).append("scale", (Object)1));
        AbstractBackendTest.assertThat(stats.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"objects")).isEqualTo(3);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"collections")).isEqualTo(2);
        AbstractBackendTest.assertThat(stats.getInteger((Object)"indexes")).isEqualTo(2);
        AbstractBackendTest.assertThat(stats.getDouble((Object)"dataSize")).isEqualTo(66.0);
    }

    @Test
    public void testDeleteDecrementsCount() {
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
        collection.deleteOne((Bson)TestUtils.json(""));
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testDeleteInSystemNamespace() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.getCollection("system.foobar").deleteOne((Bson)TestUtils.json(""))).withMessageContaining("Command failed with error 73 (InvalidNamespace): 'cannot write to 'testdb.system.foobar'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.getCollection("system.namespaces").deleteOne((Bson)TestUtils.json(""))).withMessageContaining("Command failed with error 73 (InvalidNamespace): 'cannot write to 'testdb.system.namespaces'");
    }

    @Test
    public void testUpdateInSystemNamespace() throws Exception {
        for (String collectionName : Arrays.asList("system.foobar", "system.namespaces")) {
            MongoCollection<Document> collection = this.getCollection(collectionName);
            AbstractBackendTest.assertMongoWriteException(() -> collection.updateMany(Filters.eq((String)"some", (Object)"value"), Updates.set((String)"field", (Object)"value")), 10156, "cannot update system collection");
        }
    }

    @Test
    public void testDistinctQuery() {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, n: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 3, n: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 4, n: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 5, n: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 6, n: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 7, n: -0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 8, n: 0"));
        AbstractBackendTest.assertThat(collection.distinct("n", Integer.class)).containsExactly((Object[])new Integer[]{null, 0, 1, 2, 3});
        AbstractBackendTest.assertThat(collection.distinct("n", (Bson)TestUtils.json("n: {$gt: 1}"), Integer.class)).containsExactly((Object[])new Integer[]{2, 3});
        AbstractBackendTest.assertThat(collection.distinct("foobar", String.class)).isEmpty();
        AbstractBackendTest.assertThat(collection.distinct("_id", Integer.class)).hasSize((int)collection.countDocuments());
    }

    @Test
    public void testDistinctUuids_legacy() throws Exception {
        MongoClientSettings legacyUuidSettings = MongoClientSettings.builder().applyConnectionString(connectionString).uuidRepresentation(UuidRepresentation.JAVA_LEGACY).build();
        try (MongoClient clientWithLegacyUuid = MongoClients.create((MongoClientSettings)legacyUuidSettings);){
            MongoCollection collectionWithLegacyUuid = clientWithLegacyUuid.getDatabase(collection.getNamespace().getDatabaseName()).getCollection(collection.getNamespace().getCollectionName());
            collectionWithLegacyUuid.insertOne((Object)TestUtils.json("_id: 1, n: null"));
            collectionWithLegacyUuid.insertOne((Object)TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)));
            collectionWithLegacyUuid.insertOne((Object)TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L)));
            collectionWithLegacyUuid.insertOne((Object)TestUtils.json("_id: 4").append("n", (Object)new UUID(0L, 2L)));
            collectionWithLegacyUuid.insertOne((Object)TestUtils.json("_id: 5").append("n", (Object)new UUID(1L, 1L)));
            collectionWithLegacyUuid.insertOne((Object)TestUtils.json("_id: 6").append("n", (Object)new UUID(1L, 0L)));
            AbstractBackendTest.assertThat(collectionWithLegacyUuid.distinct("n", UUID.class)).containsExactly((Object[])new UUID[]{null, new UUID(0L, 1L), new UUID(0L, 2L), new UUID(1L, 0L), new UUID(1L, 1L)});
        }
    }

    @Test
    public void testDistinctUuids() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L)));
        collection.insertOne((Object)TestUtils.json("_id: 4").append("n", (Object)new UUID(0L, 2L)));
        collection.insertOne((Object)TestUtils.json("_id: 5").append("n", (Object)new UUID(1L, 1L)));
        collection.insertOne((Object)TestUtils.json("_id: 6").append("n", (Object)new UUID(1L, 0L)));
        AbstractBackendTest.assertThat(collection.distinct("n", UUID.class)).containsExactly((Object[])new UUID[]{null, new UUID(0L, 1L), new UUID(0L, 2L), new UUID(1L, 0L), new UUID(1L, 1L)});
    }

    @Test
    public void testDistinctArrayField() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2").append("n", Arrays.asList(1, 2, 3)));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("n", Arrays.asList(3, 4, 5)));
        collection.insertOne((Object)TestUtils.json("_id: 4").append("n", (Object)6));
        AbstractBackendTest.assertThat(collection.distinct("n", Integer.class)).containsExactly((Object[])new Integer[]{null, 1, 2, 3, 4, 5, 6});
    }

    @Test
    public void testDistinct_documentArray() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, n: [{item: 1}, {item: 2}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, n: {item: 3}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, n: {item: [4, 5]}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, n: {}"));
        AbstractBackendTest.assertThat(collection.distinct("n.item", Integer.class)).containsExactly((Object[])new Integer[]{1, 2, 3, 4, 5});
    }

    @Test
    public void testDistinct_missingCollection() throws Exception {
        MongoCollection missingCollection = db.getCollection("does-not-exist");
        AbstractBackendTest.assertThat(missingCollection.distinct("x", Integer.class)).isEmpty();
    }

    @Test
    public void testInsertQueryAndSortBinaryTypes() throws Exception {
        byte[] highBytes = new byte[16];
        Arrays.fill(highBytes, (byte)-1);
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L)));
        collection.insertOne((Object)TestUtils.json("_id: 4, n: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, n: 17"));
        collection.insertOne((Object)TestUtils.json("_id: 6, n: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 7").append("n", (Object)new byte[]{0, 0, 0, 1}));
        collection.insertOne((Object)TestUtils.json("_id: 8").append("n", (Object)highBytes));
        collection.insertOne((Object)TestUtils.json("_id: 9").append("n", (Object)new byte[0]));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("n: {$type: 5}")).sort((Bson)TestUtils.json("n: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 9").append("n", (Object)new Binary(new byte[0])), TestUtils.json("_id: 7").append("n", (Object)new Binary(new byte[]{0, 0, 0, 1})), TestUtils.json("_id: 8").append("n", (Object)new Binary(highBytes)), TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)), TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L))});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("n", (Object)new UUID(1L, 0L)))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L))});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("n: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, n: null"), TestUtils.json("_id: 6, n: [1, 2, 3]"), TestUtils.json("_id: 5, n: 17"), TestUtils.json("_id: 4, n: 'abc'"), TestUtils.json("_id: 9").append("n", (Object)new Binary(new byte[0])), TestUtils.json("_id: 7").append("n", (Object)new Binary(new byte[]{0, 0, 0, 1})), TestUtils.json("_id: 8").append("n", (Object)new Binary(highBytes)), TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)), TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L))});
    }

    @Test
    public void testUuidAsId() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)new UUID(0L, 1L)));
        collection.insertOne((Object)new Document("_id", (Object)new UUID(0L, 2L)));
        collection.insertOne((Object)new Document("_id", (Object)new UUID(999999L, 128L)));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)new Document("_id", (Object)new UUID(0L, 1L))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: UUID(\"00000000-0000-0000-0000-000000000001\") }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)new Document("_id", (Object)new UUID(999999L, 128L))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: UUID(\"00000000-000f-423f-0000-000000000080\") }");
        collection.deleteOne((Bson)new Document("_id", (Object)new UUID(0L, 2L)));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactlyInAnyOrder((Object[])new Document[]{new Document("_id", (Object)new UUID(0L, 1L)), new Document("_id", (Object)new UUID(999999L, 128L))});
    }

    @Test
    public void testTypeMatching() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 'abc'"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 123}}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '2'}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$type: 2.0}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'abc'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$type: [16, 'string']}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 'abc'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$type: 'number'}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: {'$numberDecimal': '2'}")});
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("n: {$type: []}")).first()).withMessageContaining("Command failed with error 9 (FailedToParse): 'n must match at least one type'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("'a.b.c': {$type: []}")).first()).withMessageContaining("Command failed with error 9 (FailedToParse): 'a.b.c must match at least one type'");
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {b: {$type: []}}"))).isEmpty();
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("n: {$type: 'abc'}")).first()).withMessageContaining("Command failed with error 2 (BadValue): 'Unknown type name alias: abc'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("n: {$type: null}")).first()).withMessageContaining("Command failed with error 14 (TypeMismatch): 'type must be represented as a number or a string'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("_id: {$type: 16.3}")).first()).withMessageContaining("Command failed with error 2 (BadValue): 'Invalid numerical type code: 16.3'");
    }

    @Test
    public void testDistinctQueryWithDot() {
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 2}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 3}"));
        collection.insertOne((Object)TestUtils.json("a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("a: null"));
        AbstractBackendTest.assertThat(collection.distinct("a.b", Integer.class)).containsExactly((Object[])new Integer[]{null, 1, 2, 3});
        AbstractBackendTest.assertThat(collection.distinct("a.c", Integer.class)).isEmpty();
    }

    @Test
    public void testDropCollection() throws Exception {
        collection.createIndex((Bson)new Document("n", (Object)1));
        collection.createIndex((Bson)new Document("b", (Object)1));
        collection.insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertThat(db.listCollectionNames()).contains((Object[])new String[]{this.getCollectionName()});
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {n: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"n_1").append("v", (Object)2), TestUtils.json("key: {b: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"b_1").append("v", (Object)2)});
        collection.drop();
        AbstractBackendTest.assertThat(db.listCollectionNames()).doesNotContain((Object[])new String[]{this.getCollectionName()});
        AbstractBackendTest.assertThat(collection.listIndexes()).isEmpty();
    }

    @Test
    public void testDropCollectionAlsoDropsFromDB() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        collection.drop();
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
        AbstractBackendTest.assertThat(db.listCollectionNames()).doesNotContain((Object[])new String[]{this.getCollectionName()});
    }

    @Test
    public void testDropDatabaseAlsoDropsCollectionData() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        db.drop();
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testDropDatabaseDropsAllData() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        MongoCollection<Document> collection2 = this.getCollection("testcoll2");
        collection2.insertOne((Object)TestUtils.json("_id: 1"));
        db.drop();
        AbstractBackendTest.assertThat(this.listDatabaseNames()).doesNotContain((Object[])new String[]{db.getName()});
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
        AbstractBackendTest.assertThat(db.listCollectionNames()).doesNotContain((Object[])new String[]{this.getCollectionName(), collection2.getNamespace().getCollectionName()});
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection2.insertOne((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testDropEmptyDatabase() throws Exception {
        String emptyDatabaseName = "empty-db";
        MongoDatabase database = syncClient.getDatabase(emptyDatabaseName);
        database.drop();
        AbstractBackendTest.assertThat(syncClient.listDatabaseNames()).doesNotContain((Object[])new String[]{emptyDatabaseName});
    }

    @Test
    public void testDropDatabaseAfterAddingIndexMultipleTimes() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10"));
        for (int i = 0; i < 3; ++i) {
            collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        }
        db.drop();
    }

    @Test
    public void testAddIndexAgainWithDifferentOptions() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10"));
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true).sparse(true))).withMessageContaining("Command failed with error 85 (IndexOptionsConflict): 'Index with name: a_1 already exists with different options'");
    }

    @Test
    public void testEmbeddedSort() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, counts: {done: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, counts: {done: 2}"));
        AbstractBackendTest.assertThat(collection.find(Filters.ne((String)"c", (Object)true)).sort((Bson)TestUtils.json("'counts.done': -1, _id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 5, counts: {done: 2}"), TestUtils.json("_id: 4, counts: {done: 1}"), TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testEmbeddedSort_arrayOfDocuments() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, counts: {done: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, counts: {done: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, counts: [{done: 2}, {done: 1}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, counts: [{done: 4}, {done: 2}]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, counts: {done: [3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 7, counts: {done: [1, 2]}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, counts: [1, 2]"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("\"counts.done\": -1, _id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 5, counts: [{done: 4}, {done: 2}]"), TestUtils.json("_id: 6, counts: {done: [3]}"), TestUtils.json("_id: 3, counts: {done: 2}"), TestUtils.json("_id: 4, counts: [{done: 2}, {done: 1}]"), TestUtils.json("_id: 7, counts: {done: [1, 2]}"), TestUtils.json("_id: 2, counts: {done: 1}"), TestUtils.json("_id: 1"), TestUtils.json("_id: 8, counts: [1, 2]")});
    }

    @Test
    public void testFindAndModifyCommandEmpty() throws Exception {
        Document cmd = new Document("findandmodify", (Object)this.getCollectionName());
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)cmd)).withMessageContaining("Command failed with error 9 (FailedToParse): 'Either an update or remove=true must be specified'");
    }

    @Test
    public void testFindAndModifyCommandIllegalOp() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document cmd = new Document("findAndModify", (Object)this.getCollectionName());
        cmd.put("query", (Object)TestUtils.json("_id: 1"));
        cmd.put("update", (Object)new Document("$inc", (Object)TestUtils.json("_id: 1")));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)cmd)).withMessageContaining("Command failed with error 66 (ImmutableField): 'Performing an update on the path '_id' would modify the immutable field '_id'");
    }

    @Test
    public void testFindAndModifyCommandUpdate() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document cmd = new Document("findAndModify", (Object)this.getCollectionName());
        cmd.put("query", (Object)TestUtils.json("_id: 1"));
        cmd.put("update", (Object)TestUtils.json("$inc: {a: 1}"));
        Document result = db.runCommand((Bson)cmd);
        AbstractBackendTest.assertThat(result.get((Object)"lastErrorObject")).isEqualTo((Object)TestUtils.json("updatedExisting: true, n: 1"));
        AbstractBackendTest.assertThat(result.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindAndModifyCommand_UpdateSameFields() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {x: 0, a: 1}, $set: {a: 2}"))).withMessageContaining("Command failed with error 40 (ConflictingUpdateOperators): 'Updating the path 'a' would create a conflict at 'a'");
    }

    @Test
    public void testFindAndModifyCommand_UpdateFieldAndItsSubfield() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: {c: 1}}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'x': 1, 'a.b': {c: 1}}, $inc: {'a.b.c': 1}"))).withMessageContaining("Command failed with error 40 (ConflictingUpdateOperators): 'Updating the path 'a.b.c' would create a conflict at 'a.b'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'x': 1, 'a.b.c': 1}, $unset: {'a.b': 1}"))).withMessageContaining("Command failed with error 40 (ConflictingUpdateOperators): 'Updating the path 'a.b' would create a conflict at 'a.b'");
    }

    @Test
    public void testFindOneAndUpdateError() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {_id: 1}"))).withMessageContaining("Command failed with error 66 (ImmutableField): 'Performing an update on the path '_id' would modify the immutable field '_id'");
    }

    @Test
    public void testFindOneAndUpdateFields() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: 2"));
    }

    @Test
    public void testFineOneAndUpdateNotFound() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$inc", (Object)TestUtils.json("a: 1")));
        AbstractBackendTest.assertThat(result).isNull();
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
    }

    @Test
    public void testFineOneAndUpdateRemove() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Document result = (Document)collection.findOneAndDelete((Bson)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testFineOneAndUpdateReturnNew() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$inc: {a: 1, 'b.c': 1}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: {c: 2}"));
    }

    @Test
    public void testFineOneAndUpdateMax() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$max: {a: 2, 'b.c': 2, d : 'd'}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: {c: 2}, d : 'd'"));
    }

    @Test
    public void testFineOneAndUpdateMin() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 2, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$min: {a: 1, 'b.c': 2, d : 'd'}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}, d : 'd'"));
    }

    @Test
    public void testFindOneAndUpdateReturnOld() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$inc: {a: 1, 'b.c': 1}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.BEFORE));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)query).first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: {c: 2}"));
    }

    @Test
    public void testFindOneAndUpdateSorted() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 15"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 20"));
        Document order = TestUtils.json("a: 1");
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json(""), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().sort((Bson)order).returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 2, a: 11"));
        order = TestUtils.json("a: -1");
        result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json(""), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().sort((Bson)order).returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 3, a: 21"));
    }

    @Test
    public void testFindOneAndUpdateUpsert() {
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindOneAndUpdateUpsertReturnBefore() {
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.BEFORE));
        AbstractBackendTest.assertThat(result).isNull();
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindOneAndUpdateWithArrayFilters() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [95, 102, 90, 150]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: [[1, 2, 3], 'other']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: [1, 2, 3]}"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [95, 'abc', 90, 'abc']"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'grades.$[element]': 1}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 'abc'"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [95, null, 90, null]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[element]': 1}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 90"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [95, null, 91, null]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$pull: {'values.$[element]': 2}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$type: 'array'}"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 2")).first()).isEqualTo((Object)TestUtils.json("_id: 2, values: [[1, 3], 'other']"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$mul: {'a.b.$[element]': 10}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 2"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 3")).first()).isEqualTo((Object)TestUtils.json("_id: 3, a: {b: [1, 20, 3]}"));
    }

    @Test
    public void testUpdateManyWithArrayFilters() {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [9, 102, 90, 150]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: [1, 2, 3, 50]"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'values.$[x]': 20}"), new UpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gt: 20}"))));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [9, 20, 20, 20]"), TestUtils.json("_id: 2, values: [1, 2, 3, 20]")});
    }

    @Test
    public void testUpdateOneWithArrayFilter() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [{name: 'A', active: false}, {name: 'B', active: false}]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'values.$[elem].active': true}"), new UpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'elem.name': {$in: ['A']}"))));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [{name: 'A', active: true}, {name: 'B', active: false}]")});
    }

    @Test
    public void testUpsertWithArrayFilters() {
        collection.updateOne((Bson)TestUtils.json("_id: 1, values: [0, 1]"), (Bson)TestUtils.json("$set: {'values.$[x]': 20}"), new UpdateOptions().upsert(true).arrayFilters(Arrays.asList(TestUtils.json("x: 0"))));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [20, 1]")});
    }

    @Test
    public void testUpdateWithMultipleArrayFilters() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [9, 102, 90, 150]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: [1, 2, 30, 50]"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'values.$[tooLow]': 10, 'values.$[tooHigh]': 40}"), new UpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("tooLow: {$lte: 10}"), TestUtils.json("tooHigh: {$gt: 40}"))));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [10, 40, 40, 40]"), TestUtils.json("_id: 2, values: [10, 10, 30, 40]")});
    }

    @Test
    public void testUpdateWithMultipleComplexArrayFilters() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, products: [{id: 1, charges: [{type: 'A', min: 0, max: 1}, {type: 'A', min: 0, max: 2}, {type: 'B', min: 0, max: 1}, ]}, {id: 2, charges: [{type: 'A', min: 0, max: 1}, ]}, ]"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'products.$[product].charges.$[charge].amount': 10}"), new UpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'product.id': 1"), TestUtils.json("'charge.type': 'A', 'charge.min': 0, 'charge.max': 2"))));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, products: [{id: 1, charges: [{type: 'A', min: 0, max: 1}, {type: 'A', min: 0, max: 2, amount: 10}, {type: 'B', min: 0, max: 1}, ]}, {id: 2, charges: [{type: 'A', min: 0, max: 1}, ]}, ]")});
    }

    @Test
    public void testFindOneAndUpdate_IllegalArrayFilters() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: 'abc', a: {b: 123}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))))).withMessageContaining("Command failed with error 9 (FailedToParse): 'The array filter for identifier 'element' was not used in the update { $set: { grades: \"abc\" } }'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"), TestUtils.json("element: {$lt: 100}"))))).withMessageContaining("Command failed with error 9 (FailedToParse): 'Found multiple array filters with the same top-level field name element'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("a: {$gte: 100}, b: {$gte: 100}, c: {$gte: 10}"))))).withMessageContaining("Command failed with error 9 (FailedToParse): 'Error parsing array filter :: caused by :: Expected a single top-level field name, found 'a' and 'b'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json(""))))).withMessageContaining("Command failed with error 9 (FailedToParse): 'Cannot use an expression without a top-level field name in arrayFilters'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))))).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element grades: \"abc\"'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'$[element]': 10}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 2"))))).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot have array filter identifier (i.e. '$[<id>]') element in the first position in path '$[element]'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.subGrades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))))).withMessageContaining("Command failed with error 2 (BadValue): 'The path 'grades.subGrades' must exist in the document in order to apply array updates.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[some value]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'some value': {$gte: 100}"))))).withMessageContaining("Command failed with error 2 (BadValue): 'Error parsing array filter :: caused by :: The top-level field name must be an alphanumeric string beginning with a lowercase letter, found 'some value''");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[x]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gte: 100}"))))).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element b: 123'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'a.b': 10, b: 12"))))).withMessageContaining("Command failed with error 9 (FailedToParse): 'Error parsing array filter :: caused by :: Expected a single top-level field name, found 'a' and 'b''");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'a.b': 10"), TestUtils.json("'a.c': 10"))))).withMessageContaining("Command failed with error 9 (FailedToParse): 'Found multiple array filters with the same top-level field name a'");
    }

    @Test
    public void testFindOneAndUpdate_IllegalArrayFiltersPaths() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: 'abc', a: {b: [1, 2, 3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, grades: 'abc', a: {b: [{c: 1}, {c: 2}, {c: 3}]}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, grades: 'abc', a: {b: [[[1, 2], [3, 4]]]}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[x].c': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gt: 1}"))))).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {1: 2}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[x].c.d': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gt: 1}"))))).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {1: 2}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$set: {'a.b.$[].c.$[]': 'abc'}"))).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element c: 1");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$set: {'a.b.$[].0.c': 'abc'}"))).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {0: [ 1, 2 ]}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$set: {'a.b.$[].0.$[].c': 'abc'}"))).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {0: 1}");
    }

    @Test
    public void testFindAndRemoveFromEmbeddedList() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [1]"));
        Document result = (Document)collection.findOneAndDelete((Bson)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: [1]"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testFindOne() {
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        Document result = (Document)collection.find().first();
        AbstractBackendTest.assertThat(result).isNotNull();
        AbstractBackendTest.assertThat(result.get((Object)"_id")).isNotNull();
    }

    @Test
    public void testFindOneById() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document result = (Document)collection.find((Bson)TestUtils.json("_id: 1")).first();
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 2")).first()).isNull();
    }

    @Test
    public void testFindOneIn() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document result = (Document)collection.find((Bson)TestUtils.json("_id: {$in: [1, 2]}")).first();
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testFindWithLimit() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(2)).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2")});
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(-2)).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2")});
    }

    @Test
    public void testFindInReverseNaturalOrder() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("$natural: -1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2"), TestUtils.json("_id: 1")});
    }

    @Test
    public void testFindWithPattern() {
        collection.insertOne((Object)TestUtils.json("_id: 'marta'"));
        collection.insertOne((Object)TestUtils.json("_id: 'john', foo: 'bar'"));
        collection.insertOne((Object)TestUtils.json("_id: 'jon', foo: 'ba'"));
        collection.insertOne((Object)TestUtils.json("_id: 'jo'"));
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("_id", (Object)Pattern.compile("mart")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'marta'")});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("foo", (Object)Pattern.compile("ba")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'john', foo: 'bar'"), TestUtils.json("_id: 'jon', foo: 'ba'")});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("foo", (Object)Pattern.compile("ba$")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'jon', foo: 'ba'")});
    }

    @Test
    public void testFindWithQuery() {
        collection.insertOne((Object)TestUtils.json("name: 'jon'"));
        collection.insertOne((Object)TestUtils.json("name: 'leo'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil'"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("name: 'neil'"))).hasSize(2);
    }

    @Test
    public void testFindWithSkipLimit() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(2).skip(2)).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3"), TestUtils.json("_id: 4")});
    }

    @Test
    public void testFindWithSkipLimitInReverseOrder() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: -1")).limit(2).skip(2)).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2"), TestUtils.json("_id: 1")});
    }

    @Test
    public void testFindWithSkipLimitAfterDelete() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        collection.deleteOne((Bson)TestUtils.json("_id: 1"));
        collection.deleteOne((Bson)TestUtils.json("_id: 3"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(2).skip(2)).containsExactly((Object[])new Document[]{TestUtils.json("_id: 5")});
    }

    @Test
    public void testFullUpdateWithSameId() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, b: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.replaceOne((Bson)TestUtils.json("_id: 2, b: 5"), (Object)TestUtils.json("_id: 2, a: 5"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 2")).first()).isEqualTo((Object)TestUtils.json("_id: 2, a: 5"));
    }

    @Test
    public void testGetCollection() {
        MongoCollection<Document> collection = this.getCollection("coll");
        this.getCollection("coll").insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertThat(collection).isNotNull();
        AbstractBackendTest.assertThat(db.listCollectionNames()).contains((Object[])new String[]{"coll"});
    }

    @Test
    public void testNullId() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: null, name: 'test'"));
        Document result = (Document)collection.find((Bson)TestUtils.json("name: 'test'")).first();
        AbstractBackendTest.assertThat(result).isNotNull();
        AbstractBackendTest.assertThat(result.getObjectId((Object)"_id")).isNull();
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: null }");
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: null")).first()).isEqualTo((Object)TestUtils.json("_id: null, name: 'test'"));
        collection.deleteOne((Bson)TestUtils.json("_id: null"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testIdInQueryResultsInIndexOrder() {
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$in: [3, 2, 1]}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$in: [[1, 2, 3]]}"))).isEmpty();
    }

    @Test
    public void testInQuery_Arrays() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, v: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: [1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 4, v: null"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("v: {$in: [[1, 2, 3], 50]}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, v: [1, 2, 3]"), TestUtils.json("_id: 3, v: 50")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("v: {$not: {$in: [[1, 2, 3], 50]}}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, v: [1, 2]"), TestUtils.json("_id: 4, v: null"), TestUtils.json("_id: 5")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("v: {$not: {$in: [2, 50]}}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 4, v: null"), TestUtils.json("_id: 5")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("v: {$not: {$in: [[1, 2], 50, null]}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, v: [1, 2, 3]")});
    }

    @Test
    public void testIdNotAllowedToBeUpdated() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 2, a: 4")), 66, "ImmutableField", "After applying the update, the (immutable) field '_id' was found to have been altered to _id: 2");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("_id: 2"))), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
    }

    @Test
    public void testIllegalCommand() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)TestUtils.json("foo: 1"))).withMessageContaining("Command failed with error 59 (CommandNotFound): 'no such command: 'foo'");
    }

    @Test
    public void testInsert() throws Exception {
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(0L);
        for (int i = 0; i < 3; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)i));
        }
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(3L);
        collection.insertOne((Object)TestUtils.json("foo: [1, 2, 3]"));
        collection.insertOne((Object)new Document("foo", (Object)new byte[10]));
        Document insertedObject = new Document("foo", (Object)UUID.randomUUID());
        collection.insertOne((Object)insertedObject);
        Document document = (Document)collection.find((Bson)insertedObject).first();
        AbstractBackendTest.assertThat(document).isEqualTo((Object)insertedObject);
    }

    @Test
    public void testInsertDuplicate() throws Exception {
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(0L);
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 1.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 1.0 }");
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
    }

    @Test
    public void testInsertDuplicateThrows() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 1")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 1 }");
    }

    @Test
    public void testInsertDuplicateWithConcernThrows() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne((Object)TestUtils.json("_id: 1")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 1 }");
    }

    @Test
    public void testInsertIncrementsCount() {
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
    }

    @Test
    public void testInsertQuery() throws Exception {
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(0L);
        Document insertedObject = TestUtils.json("_id: 1");
        insertedObject.put("foo", (Object)OTHER_TEST_DATABASE_NAME);
        collection.insertOne((Object)insertedObject);
        AbstractBackendTest.assertThat((Document)collection.find((Bson)insertedObject).first()).isEqualTo((Object)insertedObject);
        AbstractBackendTest.assertThat((Document)collection.find((Bson)new Document("_id", (Object)1L)).first()).isEqualTo((Object)insertedObject);
        AbstractBackendTest.assertThat((Document)collection.find((Bson)new Document("_id", (Object)1.0)).first()).isEqualTo((Object)insertedObject);
        AbstractBackendTest.assertThat((Document)collection.find((Bson)new Document("_id", (Object)Float.valueOf(1.0001f))).first()).isNull();
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("foo: 'bar'")).first()).isEqualTo((Object)insertedObject);
    }

    @Test
    public void testInsertRemove() throws Exception {
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)TestUtils.json("_id: 1"));
            AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
            collection.deleteOne((Bson)TestUtils.json("_id: 1"));
            AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
            collection.insertOne((Object)new Document("_id", (Object)i));
            collection.deleteOne((Bson)new Document("_id", (Object)i));
        }
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
        collection.deleteOne((Bson)TestUtils.json("'doesnt exist': 1"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testInsertInSystemNamespace() throws Exception {
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection("system.foobar").insertOne((Object)TestUtils.json("")), 16459, "attempt to insert in system namespace");
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection("system.namespaces").insertOne((Object)TestUtils.json("")), 16459, "attempt to insert in system namespace");
    }

    @Test
    public void testListDatabaseNames() throws Exception {
        AbstractBackendTest.assertThat(this.listDatabaseNames()).isEmpty();
        collection.insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertThat(this.listDatabaseNames()).containsExactly((Object[])new String[]{db.getName()});
        this.getDatabase().getCollection("some-collection").insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertThat(this.listDatabaseNames()).containsExactly((Object[])new String[]{OTHER_TEST_DATABASE_NAME, db.getName()});
    }

    private MongoDatabase getDatabase() {
        return syncClient.getDatabase(OTHER_TEST_DATABASE_NAME);
    }

    @Test
    public void testQuery() throws Exception {
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).first();
        AbstractBackendTest.assertThat(obj).isNull();
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(0L);
    }

    @Test
    public void testQueryAll() throws Exception {
        ArrayList<Document> inserted = new ArrayList<Document>();
        for (int i = 0; i < 10; ++i) {
            Document obj = new Document("_id", (Object)i);
            collection.insertOne((Object)obj);
            inserted.add(obj);
        }
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(10L);
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactlyElementsOf(inserted);
    }

    @Test
    public void testQueryCount() throws Exception {
        for (int i = 0; i < 100; ++i) {
            collection.insertOne((Object)TestUtils.json(""));
        }
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(100L);
        Document obj = TestUtils.json("_id: 1");
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)obj)).isEqualTo(0L);
        collection.insertOne((Object)obj);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)obj)).isEqualTo(1L);
    }

    @Test
    public void testQueryLimitEmptyQuery() throws Exception {
        for (int i = 0; i < 5; ++i) {
            collection.insertOne((Object)TestUtils.json(""));
        }
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().limit(1))).isEqualTo(1L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().limit(-1))).isEqualTo(5L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json(""))).isEqualTo(5L);
    }

    @Test
    public void testQueryLimitSimpleQuery() throws Exception {
        for (int i = 0; i < 5; ++i) {
            collection.insertOne((Object)TestUtils.json("a: 1"));
        }
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().limit(1))).isEqualTo(1L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().limit(-1))).isEqualTo(5L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("a: 1"))).isEqualTo(5L);
    }

    @Test
    public void testQueryNull() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("foo: null")).first()).isEqualTo((Object)object);
    }

    @Test
    public void testQuerySkipLimitEmptyQuery() throws Exception {
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(3))).isEqualTo(0L);
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)TestUtils.json(""));
        }
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(3))).isEqualTo(7L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(15))).isEqualTo(0L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(3).limit(5))).isEqualTo(5L);
    }

    @Test
    public void testQuerySkipLimitSimpleQuery() throws Exception {
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(3))).isEqualTo(0L);
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)TestUtils.json("a: 1"));
        }
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(3))).isEqualTo(7L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(3).limit(5))).isEqualTo(5L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(15).limit(5))).isEqualTo(0L);
    }

    @Test
    public void testQuerySort() throws Exception {
        Random random = new Random(4711L);
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)random.nextDouble()));
        }
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).extracting(d -> d.getDouble((Object)"_id")).isSorted();
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: -1"))).extracting(d -> d.getDouble((Object)"_id")).isSortedAccordingTo(Comparator.comparingDouble(Double::doubleValue).reversed());
    }

    @Test
    public void testQueryWithFieldSelector() throws Exception {
        collection.insertOne((Object)TestUtils.json("foo: 'bar'"));
        collection.insertOne((Object)TestUtils.json("foo: null"));
        Document obj = (Document)collection.find((Bson)TestUtils.json("")).projection((Bson)TestUtils.json("foo: 1")).first();
        AbstractBackendTest.assertThat(obj).containsOnlyKeys((Object[])new String[]{"_id", "foo"});
        obj = (Document)collection.find((Bson)TestUtils.json("foo: 'bar'")).projection((Bson)TestUtils.json("_id: 1")).first();
        AbstractBackendTest.assertThat(obj).containsOnlyKeys((Object[])new String[]{"_id"});
        obj = (Document)collection.find((Bson)TestUtils.json("foo: null")).projection((Bson)TestUtils.json("_id: 0, foo: 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("foo: null"));
        obj = (Document)collection.find((Bson)TestUtils.json("foo: 'bar'")).projection((Bson)TestUtils.json("_id: 0, foo: 1")).first();
        AbstractBackendTest.assertThat(obj).containsOnlyKeys((Object[])new String[]{"foo"});
    }

    @Test
    public void testQueryWithDotNotationFieldSelector() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, index: false, foo: {a: 'a1', b: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, foo: {a: null, b: null}"));
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a': 1, 'foo.b': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {a: 'a1', b: 0}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {a: 'a1'}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a': 1, index: 1, _id: 0")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("foo: {a: 'a1'}, index: false"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("foo: 1, _id: 0")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("foo: {a: 'a1', b: 0}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a.b.c.d': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo..': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("'foo.a.b': 1, 'foo.b': 1, 'foo.c': 1, 'foo.c.d': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 2, foo: {b: null}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("'foo.a': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 2, foo: {a: null}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("'foo.c': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 2, foo: {}"));
    }

    @Test
    public void testQueryWithDotNotationFieldSelector_Array() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [1, 2, {x: 100, y: 10}, {x: 200}]"));
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'values.0': 1, 'values.x': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 1, values: [{x: 100}, {x: 200}]"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'values.y': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 1, values: [{y: 10}, {}]"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'values.x': 1, 'values.y': 1")).first();
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("_id: 1, values: [{x: 100, y: 10}, {x: 200}]"));
    }

    @Test
    public void testQueryWithIllegalFieldSelection() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {x: 1, y: 1}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '>1 field in obj: { x: 1, y: 1 }'");
    }

    @Test
    public void testQuerySystemNamespace() throws Exception {
        AbstractBackendTest.assertThat((Document)this.getCollection("system.foobar").find().first()).isNull();
        AbstractBackendTest.assertThat(db.listCollectionNames()).isEmpty();
        collection.insertOne((Object)TestUtils.json(""));
        Document expectedObj = new Document("name", (Object)collection.getNamespace().getFullName());
        Document coll = (Document)this.getCollection("system.namespaces").find((Bson)expectedObj).first();
        AbstractBackendTest.assertThat(coll).isEqualTo((Object)expectedObj);
    }

    @Test
    public void testQueryAllExpression() throws Exception {
        collection.insertOne((Object)TestUtils.json("a: [{x: 1}, {x: 2}]"));
        collection.insertOne((Object)TestUtils.json("a: [{x: 2}, {x: 3}]"));
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("'a.x': {$all: [1, 2]}"))).isEqualTo(1L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)TestUtils.json("'a.x': {$all: [2, 3]}"))).isEqualTo(1L);
    }

    @Test
    public void testAndQueryWithAllAndNin() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, tags: ['A', 'B']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, tags: ['A', 'D']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, tags: ['A', 'C']"));
        collection.insertOne((Object)TestUtils.json("_id: 4, tags: ['C', 'D']"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("$and: [{'tags': {$all: ['A']}}, {'tags': {$nin: ['B', 'C']}}]"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, tags: ['A', 'D']")});
    }

    @Test
    public void testAndQueryWithAllAndSize() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, list: ['A', 'B']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, list: ['A', 'B', 'C']"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("$and: [{list: {$size: 2}}, {list: {$all: ['A', 'B']}}]}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, list: ['A', 'B']")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("list: {$all: ['A', 'B'], $size: 2}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, list: ['A', 'B']")});
    }

    @Test
    public void testMatchesAllWithEmptyCollection() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, text: 'TextA', tags: []"));
        collection.insertOne((Object)TestUtils.json("_id: 2, text: 'TextB', tags: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, text: 'TextA', tags: ['A']"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("$and: [{'text': 'TextA'}, {'tags': {$all: []}}]"))).isEmpty();
    }

    @Test
    public void testQueryWithSubdocumentIndex() throws Exception {
        collection.createIndex((Bson)TestUtils.json("action: {actionId: 1}"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("action: {actionId: 1}, value: 'a'"));
        collection.insertOne((Object)TestUtils.json("action: {actionId: 2}, value: 'b'"));
        collection.insertOne((Object)TestUtils.json("action: {actionId: 3}, value: 'c'"));
        Document foundWithNestedDocument = (Document)collection.find((Bson)TestUtils.json("action: {actionId: 2}")).first();
        AbstractBackendTest.assertThat(foundWithNestedDocument.get((Object)"value")).isEqualTo((Object)"b");
        Document foundWithDotNotation = (Document)collection.find((Bson)TestUtils.json("'action.actionId': 2")).first();
        AbstractBackendTest.assertThat(foundWithDotNotation.get((Object)"value")).isEqualTo((Object)"b");
    }

    @Test
    public void testQueryBinaryData() throws Exception {
        byte[] firstBytes = new byte[]{1, 2, 3};
        byte[] secondBytes = new byte[]{3, 2, 1};
        collection.insertOne((Object)new Document("_id", (Object)1).append("test", (Object)firstBytes));
        collection.insertOne((Object)new Document("_id", (Object)2).append("test", (Object)secondBytes));
        Document first = (Document)collection.find((Bson)new Document("test", (Object)firstBytes)).first();
        AbstractBackendTest.assertThat(first).isNotNull();
        AbstractBackendTest.assertThat(first.get((Object)"_id")).isEqualTo((Object)1);
        Document second = (Document)collection.find((Bson)new Document("test", (Object)secondBytes)).first();
        AbstractBackendTest.assertThat(second).isNotNull();
        AbstractBackendTest.assertThat(second.get((Object)"_id")).isEqualTo((Object)2);
    }

    @Test
    public void testRemove() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.deleteOne((Bson)TestUtils.json("_id: 2"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 2")).first()).isNull();
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(3L);
        collection.deleteMany((Bson)TestUtils.json("_id: {$gte: 3}"));
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(1L);
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testRemoveSingle() throws Exception {
        Document obj = new Document("_id", (Object)ObjectId.get());
        collection.insertOne((Object)obj);
        collection.deleteOne((Bson)obj);
    }

    @Test
    public void testRemoveReturnsModifiedDocumentCount() {
        collection.insertOne((Object)TestUtils.json(""));
        collection.insertOne((Object)TestUtils.json(""));
        DeleteResult result = collection.deleteMany((Bson)TestUtils.json(""));
        AbstractBackendTest.assertThat(result.getDeletedCount()).isEqualTo(2L);
        result = collection.deleteMany((Bson)TestUtils.json(""));
        AbstractBackendTest.assertThat(result.getDeletedCount()).isEqualTo(0L);
    }

    @Test
    public void testReservedCollectionNames() throws Exception {
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection("foo$bar").insertOne((Object)TestUtils.json("")), 10093, "cannot insert into reserved $ collection");
        String veryLongString = AbstractBackendTest.repeat("verylongstring", 5);
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection(veryLongString).insertOne((Object)TestUtils.json("")), 10080, "ns name too long, max size is 128");
    }

    private static String repeat(String str, int num) {
        String repeated = str;
        for (int i = 0; i < num; ++i) {
            repeated = repeated + repeated;
        }
        return repeated;
    }

    @Test
    public void testServerStatus() throws Exception {
        Document serverStatus = this.runCommand("serverStatus");
        AbstractBackendTest.assertThat(serverStatus.getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(serverStatus.get((Object)"uptime")).isInstanceOf(Number.class);
        AbstractBackendTest.assertThat(serverStatus.get((Object)"uptimeMillis")).isInstanceOf(Long.class);
        Instant serverTime = ((Date)serverStatus.get((Object)"localTime")).toInstant();
        AbstractBackendTest.assertThat(serverTime).isEqualTo((Object)clock.instant());
        Document connections = (Document)serverStatus.get((Object)"connections");
        AbstractBackendTest.assertThat(connections.get((Object)"current")).isNotNull();
    }

    @Test
    void testServerStatusWithOpenCursors() throws Exception {
        for (int i = 0; i < 20; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)(i + 1)));
        }
        try (MongoCursor cursor1 = collection.find().batchSize(10).cursor();
             MongoCursor cursor2 = collection.find().batchSize(10).cursor();){
            log.debug("Opened {} and {}", (Object)cursor1.getServerCursor(), (Object)cursor2.getServerCursor());
            Document serverStatus = this.runCommand("serverStatus");
            AbstractBackendTest.assertThat(serverStatus.getDouble((Object)"ok")).isEqualTo(1.0);
            Document metrics = (Document)serverStatus.get((Object)"metrics", Document.class);
            Document cursorMetrics = (Document)metrics.get((Object)"cursor", Document.class);
            AbstractBackendTest.assertThat(cursorMetrics.getLong((Object)"timedOut")).isZero();
            Document openCursors = (Document)cursorMetrics.get((Object)"open", Document.class);
            AbstractBackendTest.assertThat(openCursors.getLong((Object)"noTimeout")).isZero();
            AbstractBackendTest.assertThat(openCursors.getLong((Object)"pinned")).isZero();
            AbstractBackendTest.assertThat(openCursors.getLong((Object)"total")).isEqualTo(2L);
        }
    }

    @Test
    public void testPing() throws Exception {
        AbstractBackendTest.assertThat(this.runCommand("ping").getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(this.runCommand(TestUtils.json("ping: true")).getDouble((Object)"ok")).isEqualTo(1.0);
        AbstractBackendTest.assertThat(this.runCommand(TestUtils.json("ping: 2.0")).getDouble((Object)"ok")).isEqualTo(1.0);
    }

    @Test
    public void testReplSetGetStatus() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.runCommand("replSetGetStatus")).withMessageContaining("Command failed with error 76 (NoReplicationEnabled): 'not running with --replSet'");
    }

    @Test
    public void testWhatsMyUri() throws Exception {
        for (String dbName : new String[]{"admin", "local", "test"}) {
            Document result = syncClient.getDatabase(dbName).runCommand((Bson)new Document("whatsmyuri", (Object)1));
            AbstractBackendTest.assertThat(result.get((Object)"you")).isNotNull();
            AbstractBackendTest.assertThat(result.get((Object)"you").toString()).matches((CharSequence)"\\d+\\.\\d+\\.\\d+\\.\\d+:\\d*");
        }
    }

    @Test
    public void testSortDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {c: 1}"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("a: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: 3"), TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: {b: 2}"), TestUtils.json("_id: 4, a: {c: 1}")});
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("a: -1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 4, a: {c: 1}"), TestUtils.json("_id: 2, a: {b: 2}"), TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 3, a: 3")});
    }

    @Test
    public void testSort() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 9, a: 1.0"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("a: 1, _id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: null"), TestUtils.json("_id: 4"), TestUtils.json("_id: 2, a: 1"), TestUtils.json("_id: 9, a: 1.0"), TestUtils.json("_id: 3, a: 2"), TestUtils.json("_id: 5, a: 3"), TestUtils.json("_id: 6, a: 4"), TestUtils.json("_id: 7, a: 'abc'"), TestUtils.json("_id: 8, a: 'zzz'")});
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("a: -1, _id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 8, a: 'zzz'"), TestUtils.json("_id: 7, a: 'abc'"), TestUtils.json("_id: 6, a: 4"), TestUtils.json("_id: 5, a: 3"), TestUtils.json("_id: 3, a: 2"), TestUtils.json("_id: 2, a: 1"), TestUtils.json("_id: 9, a: 1.0"), TestUtils.json("_id: 1, a: null"), TestUtils.json("_id: 4")});
    }

    @Test
    public void testSortByEmbeddedKey() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: 3}"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("'a.b': -1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: {b: 3}"), TestUtils.json("_id: 2, a: {b: 2}"), TestUtils.json("_id: 1, a: {b: 1}")});
    }

    @Test
    public void testUpdate() throws Exception {
        Document object = TestUtils.json("_id: 1");
        Document newObject = TestUtils.json("_id: 1, foo: 'bar'");
        collection.insertOne((Object)object);
        UpdateResult result = collection.replaceOne((Bson)object, (Object)newObject);
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(1L);
        AbstractBackendTest.assertThat(result.getUpsertedId()).isNull();
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)newObject);
    }

    @Test
    public void testUpdateNothing() throws Exception {
        Document object = TestUtils.json("_id: 1");
        UpdateResult result = collection.replaceOne((Bson)object, (Object)object);
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(0L);
        AbstractBackendTest.assertThat(result.getMatchedCount()).isEqualTo(0L);
        AbstractBackendTest.assertThat(result.getUpsertedId()).isNull();
    }

    @Test
    public void testUpdateBlank() throws Exception {
        Document document = TestUtils.json("'': 1, _id: 2, a: 3, b: 4");
        collection.insertOne((Object)document);
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {c: 5}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("'': 1, _id: 2, a: 3, b: 4, c: 5"));
    }

    @Test
    public void testUpdateEmptyPositional() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.$.b': 1}")), 2, "BadValue", "The positional operator did not find the match needed from the query.");
    }

    @Test
    public void testUpdateMultiplePositional() throws Exception {
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("'a.b.c': 1"), (Bson)TestUtils.json("$set: {'a.$.b.$.c': 1}")), 2, "BadValue", "Too many positional (i.e. '$') elements found in path 'a.$.b.$.c'");
    }

    @Test
    public void testUpdateIllegalFieldName() throws Exception {
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$set: {y: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$set: {$z: 1}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$z' in '$z' is not valid for storage.");
        collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$unset: {$z: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$inc: {$z: 1}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$z' in '$z' is not valid for storage.");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$push: {$z: [1, 2, 3]}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$z' in '$z' is not valid for storage.");
    }

    @Test
    public void testUpdateSubdocument() throws Exception {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("'a.b.c': 123"))).withMessage("All update operators must start with '$', but 'a.b.c' does not");
    }

    @ParameterizedTest
    @ValueSource(strings={"a.", "a..", "a.b", "a.b.", "a.....111"})
    void testInsertWithSpecialFieldNames(String specialFieldName) throws Exception {
        Document document = TestUtils.json("_id: 1").append(specialFieldName, (Object)1);
        collection.insertOne((Object)document);
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)document);
    }

    @Test
    public void testUpdateIdNoChange() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: 5"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 5"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {_id: 1, b: 3}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 5, b: 3"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {_id: 1, a: 7}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 7, b: 3"));
    }

    @Test
    public void testUpdatePush() throws Exception {
        Document idObj = TestUtils.json("_id: 1");
        collection.insertOne((Object)idObj);
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$push: {'field.subfield.subsubfield': 'value'}"));
        Document expected = TestUtils.json("_id: 1, field: {subfield: {subsubfield: ['value']}}");
        AbstractBackendTest.assertThat((Document)collection.find((Bson)idObj).first()).isEqualTo((Object)expected);
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$set: {field: 'value'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$push: {field: 'value'}")), 2, "BadValue", "The field 'field' must be an array but is of type string in document {_id: 1}");
        Document pushObj = TestUtils.json("$push: {field1: 'value', field2: 'value2'}");
        collection.updateOne((Bson)idObj, (Bson)pushObj);
        expected = TestUtils.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']");
        AbstractBackendTest.assertThat((Document)collection.find((Bson)idObj).first()).isEqualTo((Object)expected);
        pushObj = TestUtils.json("$push: {field1: 'value'}");
        collection.updateOne((Bson)idObj, (Bson)pushObj);
        expected.put("field1", Arrays.asList("value", "value"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)idObj).first()).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdatePushEach() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: [0]"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 2, 3, {key: 'value'}]}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, value: [1, 2, 3, {key: 'value'}]"), TestUtils.json("_id: 2, value: [0, 1, 2, 3, {key: 'value'}]")});
    }

    @Test
    public void testUpdatePushSlice() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: ['a', 'b', 'c'], $slice: 4}}"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 2, 3], $slice: 4}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: ['a', 'b', 'c', 1]")});
    }

    @Test
    public void testUpdatePushWithNegativeAndZeroSlice() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: ['a', 'b', 'c'], $slice: -2}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: ['b', 'c']")});
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 2], $slice: -5}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: ['b', 'c', 1, 2]")});
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: ['x', 'y', 'z'], $slice: 0}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: []")});
    }

    @Test
    public void testUpdatePushSort() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 5, 6, 3], $sort: -1}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: [6, 5, 3, 1]")});
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [{value: 1}, {value: 3}, {value: 2}], $sort: {value: 1}}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: [6, 5, 3, 1, {value: 1}, {value: 2}, {value: 3}]")});
    }

    @Test
    public void testUpdatePushSortAndSlice() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, quizzes: [{wk: 2, score: 9}, {wk: 1, score: 10}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {quizzes: {$each: [{wk: 5, score: 8}, {wk: 6, score: 7}, {wk: 7, score: 6}],$sort: { score: -1 },$slice: 3}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, quizzes: [{wk: 1, score: 10},{wk: 2, score: 9},{wk: 5, score: 8}]")});
    }

    @Test
    public void testUpdatePushPosition() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: [1, 2]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [3, 4], $position: 10}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: [1, 2, 3, 4]")});
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: ['x'], $position: 2}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: [1, 2, 'x', 3, 4]")});
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: ['y'], $position: -2}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: [1, 2, 'x', 'y', 3, 4]")});
    }

    @Test
    public void testUpdatePushEach_unknownModifier() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 2, 3], $illegal: 1}}")), 2, "BadValue", "Unrecognized clause in $push: $illegal");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$position: 1}}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$position' in 'value..$position' is not valid for storage.");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$illegal: 1}}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$illegal' in 'value..$illegal' is not valid for storage.");
    }

    @Test
    public void testUpdatePushEach_illegalOptions() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 2, 3], $slice: 'abc'}}")), 2, "BadValue", "The value for $slice must be an integer value but was given type: string");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 2, 3], $sort: 'abc'}}")), 2, "BadValue", "The $sort is invalid: use 1/-1 to sort the whole element, or {field:1/-1} to sort embedded fields");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$push: {value: {$each: [1, 2, 3], $position: 'abc'}}")), 2, "BadValue", "The value for $position must be an integer value, not of type: string");
    }

    @Test
    public void testUpdatePushAll() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$pushAll: {field: 'value'}")), 9, "FailedToParse", "Unknown modifier: $pushAll. Expected a valid update modifier or pipeline-style update specified as an array");
    }

    @Test
    public void testUpdateAddToSet() throws Exception {
        Document idObj = TestUtils.json("_id: 1");
        collection.insertOne((Object)idObj);
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {'field.subfield.subsubfield': 'value'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)idObj).first()).isEqualTo((Object)TestUtils.json("_id: 1, field: {subfield: {subsubfield: ['value']}}"));
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$set: {field: 'value'}"));
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {field: 'value'}"))).withMessageContaining("Cannot apply $addToSet to non-array field. Field named 'field' has non-array type string");
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {field1: 'value', field2: 'value2'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)idObj).first()).isEqualTo((Object)TestUtils.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']"));
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {field1: 'value'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)idObj).first()).isEqualTo((Object)TestUtils.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']"));
    }

    @Test
    public void testUpdateAddToSetEach() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(6, 5, 4)));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: [6, 5, 4]")});
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(3, 2, 1)));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: [6, 5, 4, 3, 2, 1]")});
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(7, 7, 9, 2)));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: [6, 5, 4, 3, 2, 1, 7, 9]")});
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(12, 13, 12)));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: [6, 5, 4, 3, 2, 1, 7, 9, 12, 13]")});
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$addToSet: {value: {key: 'x'}}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: [{key: 'x'}]")});
    }

    @Test
    public void testUpdateAddToSetEach_unknownModifier() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$addToSet: {value: {$each: [1, 2, 3], $slice: 2}}")), 2, "BadValue", "Found unexpected fields after $each in $addToSet: { $each: [ 1, 2, 3 ], $slice: 2 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$addToSet: {value: {$each: [1, 2, 3], value: 2}}")), 2, "BadValue", "Found unexpected fields after $each in $addToSet: { $each: [ 1, 2, 3 ], value: 2 }");
        String expectedPathPrefix = this.getExpectedPathPrefix_testUpdateAddToSetEach_unknownModifier();
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$addToSet: {value: {key: 2, $each: [1, 2, 3]}}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$each' in '" + expectedPathPrefix + ".$each' is not valid for storage.");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$addToSet: {value: {$slice: 2, $each: [1, 2, 3]}}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$slice' in '" + expectedPathPrefix + ".$slice' is not valid for storage.");
    }

    protected String getExpectedPathPrefix_testUpdateAddToSetEach_unknownModifier() {
        return "value.";
    }

    @Test
    public void testUpdateDatasize() throws Exception {
        Document obj = TestUtils.json("_id: 1, a: {x: [1, 2, 3]}");
        collection.insertOne((Object)obj);
        Integer oldSize = this.getCollStats().getInteger((Object)"size");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.set((String)"a.x.0", (Object)3));
        AbstractBackendTest.assertThat(((Document)collection.find().first()).get((Object)"a")).isEqualTo((Object)TestUtils.json("x: [3, 2, 3]"));
        Integer newSize = this.getCollStats().getInteger((Object)"size");
        AbstractBackendTest.assertThat(newSize).isEqualTo((Object)oldSize);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.set((String)"a.x.0", (Object)"abc"));
        Integer yetNewSize = this.getCollStats().getInteger((Object)"size");
        AbstractBackendTest.assertThat(yetNewSize - oldSize).isEqualTo(4);
    }

    @Test
    public void testUpdatePull() throws Exception {
        Document obj = TestUtils.json("_id: 1");
        collection.insertOne((Object)obj);
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pull: {field1: 'value2', field2: 'value3'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)obj).first()).isEqualTo((Object)obj);
        collection.updateOne((Bson)obj, Updates.set((String)"field", (Object)"value"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, Updates.pull((String)"field", (Object)"value")), 2, "BadValue", "Cannot apply $pull to a non-array value");
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field: ['value1', 'value2', 'value1']}"));
        collection.updateOne((Bson)obj, Updates.pull((String)"field", (Object)"value1"));
        AbstractBackendTest.assertThat(((Document)collection.find((Bson)obj).first()).get((Object)"field")).isEqualTo(Collections.singletonList("value2"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field1: ['value1', 'value2', 'value1']}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field2: ['value3', 'value3', 'value1']}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pull: {field1: 'value2', field2: 'value3'}"));
        AbstractBackendTest.assertThat(((Document)collection.find((Bson)obj).first()).get((Object)"field1")).isEqualTo(Arrays.asList("value1", "value1"));
        AbstractBackendTest.assertThat(((Document)collection.find((Bson)obj).first()).get((Object)"field2")).isEqualTo(Collections.singletonList("value1"));
    }

    @Test
    public void testUpdatePullValueWithCondition() {
        collection.insertOne((Object)TestUtils.json("_id: 1, votes: [ 3, 5, 6, 7, 7, 8 ]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$pull: {votes: {$gte: 6}}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, votes: [3, 5]"));
    }

    @Test
    public void testUpdatePullDocuments() {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [{item: 'A', score: 5}, {item: 'B', score: 8, comment: 'foobar'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, results: [{item: 'C', score: 8, comment: 'foobar'}, {item: 'B', score: 4}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$pull: {results: {score: 8 , item: 'B'}}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, results: [{item: 'A', score: 5}]"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 2")).first()).isEqualTo((Object)TestUtils.json("_id: 2, results: [{item: 'C', score: 8, comment: 'foobar'}, {item: 'B', score: 4}]"));
    }

    @Test
    public void testUpdatePullLeavesEmptyArray() {
        Document obj = TestUtils.json("_id: 1");
        collection.insertOne((Object)obj);
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field: [{'key1': 'value1', 'key2': 'value2'}]}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pull: {field: {'key1': 'value1'}}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)obj).first()).isEqualTo((Object)TestUtils.json("_id: 1, field: []"));
    }

    @Test
    public void testUpdatePullAll() throws Exception {
        Document obj = TestUtils.json("_id: 1");
        collection.insertOne((Object)obj);
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field: 'value'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pullAll: {field: 'value'}")), 2, "BadValue", "$pullAll requires an array argument but was given a string");
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field1: ['value1', 'value2', 'value1', 'value3', 'value4', 'value3']}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pullAll: {field1: ['value1', 'value3']}"));
        AbstractBackendTest.assertThat(((Document)collection.find((Bson)obj).first()).get((Object)"field1")).isEqualTo(Arrays.asList("value2", "value4"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pullAll: {field1: 'bar'}")), 2, "BadValue", "$pullAll requires an array argument but was given a string");
    }

    @Test
    public void testUpdatePullAll_Documents() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, persons: [{id: 1}, {id: 2}, {id: 5}, {id: 5}, {id: 1}, {id: 0}]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$pullAll: {persons: [{id: 0.0}, {id: 5}]}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, persons: [{id: 1}, {id: 2}, {id: 1}]")});
    }

    @Test
    public void testUpdateSet() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {foo: 'bar'}"));
        Document expected = TestUtils.json("");
        expected.putAll((Map)object);
        expected.put("foo", (Object)OTHER_TEST_DATABASE_NAME);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {bar: 'bla'}"));
        expected.put(OTHER_TEST_DATABASE_NAME, (Object)"bla");
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'foo.bar': 'bla'}")), 28, "PathNotViable", "Cannot create field 'bar' in element {foo: \"bar\"}");
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.foo': '123'}"));
        expected.putAll((Map)TestUtils.json("other: {foo: '123'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.foo': 42}"));
        expected.putAll((Map)TestUtils.json("other: {foo: 42}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.bar': 'x'}"));
        expected.putAll((Map)TestUtils.json("other: {foo: 42, bar: 'x'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.bar': null}"));
        expected.putAll((Map)TestUtils.json("other: {foo: 42, bar: null}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.missing': null}"));
        expected.putAll((Map)TestUtils.json("other: {foo: 42, bar: null, missing: null}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other': null}"));
        expected.putAll((Map)TestUtils.json("other: null"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdateSet_arrayOfDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, foo: [{bar: 1}, {bar: 2}]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'foo.bar': 3}")), 28, "PathNotViable", "Cannot create field 'bar' in element {foo: [ { bar: 1 }, { bar: 2 } ]}");
    }

    @Test
    public void testUpdateSetOnInsert() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {b: 3}, $setOnInsert: {a: 3}"), new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, b: 3, a: 3"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {b: 4}, $setOnInsert: {a: 5}"), new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, b: 4, a: 3"));
    }

    @Test
    public void testUpdateSetWithArrayIndices() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{x: 0}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.0.x': 3}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.1.z': 17}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3}, {z: 17}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.0.y': 7}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3, y: 7}, {z: 17}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.1': 'test'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3, y: 7}, 'test']"));
    }

    @Test
    public void testUpdateUnsetWithArrayIndices() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{x: 0}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$unset: {'a.0.x': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [{}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$unset: {'a.0': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [null]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$unset: {'a.10': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [null]"));
    }

    @Test
    public void testUpdateMax() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': 10}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': -100}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': '1'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : '1'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': null}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : '1'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': '2', 'buz' : 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : '2'}, buz : 1"));
    }

    @Test
    public void testUpdateMin() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 'b'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 'b'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 'a'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 'a'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 10}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 10}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 100}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': null}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : null}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 'a'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : null}"));
    }

    @Test
    public void testUpdateMinMaxWithLists() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [1, 2], b: [3, 4]"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: null, b: null"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'abc', b: 'xyz'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 1, b: 2"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$min: {a: [2, 3], b: [1, 2]}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: [1, 2], b: [1, 2]"), TestUtils.json("_id: 2, a: [2, 3], b: [1, 2]"), TestUtils.json("_id: 3, a: null, b: null"), TestUtils.json("_id: 4, a: 'abc', b: 'xyz'"), TestUtils.json("_id: 5, a: 1, b: 2")});
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$max: {a: [1, 3], b: [2, 3]}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: [1, 3], b: [2, 3]"), TestUtils.json("_id: 2, a: [2, 3], b: [2, 3]"), TestUtils.json("_id: 3, a: [1, 3], b: [2, 3]"), TestUtils.json("_id: 4, a: [1, 3], b: [2, 3]"), TestUtils.json("_id: 5, a: [1, 3], b: [2, 3]")});
    }

    @Test
    public void testUpdateMaxCompareNumbers() throws Exception {
        Document object = TestUtils.json("_id: 1, highScore: 800, lowScore: 200");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$max: {highScore: 950}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 950, lowScore: 200"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$max: {highScore: 870}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 950, lowScore: 200"));
    }

    @Test
    public void testUpdateMaxCompareDates() throws Exception {
        Document object = new Document("_id", (Object)1).append("desc", (Object)"crafts").append("dateEntered", (Object)TestUtils.instant("2013-10-01T05:00:00Z")).append("dateExpired", (Object)TestUtils.instant("2013-10-01T16:38:16Z"));
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$max", (Object)new Document("dateExpired", (Object)TestUtils.instant("2013-09-30T00:00:00Z"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)TestUtils.date("2013-10-01T05:00:00Z")).append("dateExpired", (Object)TestUtils.date("2013-10-01T16:38:16Z")));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$max", (Object)new Document("dateExpired", (Object)TestUtils.instant("2014-01-07T00:00:00Z"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)TestUtils.date("2013-10-01T05:00:00Z")).append("dateExpired", (Object)TestUtils.date("2014-01-07T00:00:00Z")));
    }

    @Test
    public void testUpdateMinCompareNumbers() throws Exception {
        Document object = TestUtils.json("_id: 1, highScore: 800, lowScore: 200");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$min: {lowScore: 150}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 800, lowScore: 150"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$min: {lowScore: 250}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 800, lowScore: 150"));
    }

    @Test
    public void testUpdateMinCompareDates() throws Exception {
        Document object = new Document("_id", (Object)1).append("desc", (Object)"crafts").append("dateEntered", (Object)TestUtils.instant("2013-10-01T05:00:00Z")).append("dateExpired", (Object)TestUtils.instant("2013-10-01T16:38:16Z"));
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$min", (Object)new Document("dateEntered", (Object)TestUtils.instant("2013-09-25T00:00:00Z"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)TestUtils.date("2013-09-25T00:00:00Z")).append("dateExpired", (Object)TestUtils.date("2013-10-01T16:38:16Z")));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$min", (Object)new Document("dateEntered", (Object)TestUtils.instant("2014-01-07T00:00:00Z"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)TestUtils.date("2013-09-25T00:00:00Z")).append("dateExpired", (Object)TestUtils.date("2013-10-01T16:38:16Z")));
    }

    @Test
    public void testUpdatePop() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'foo.bar': [1, 2, 3]}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo: {bar: [1, 2, 3]}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 1.0}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo: {bar: [1, 2]}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': -1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, foo: {bar: [2]}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': null}")), 9, "FailedToParse", "Expected a number in: foo.bar: null");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 'x'}")), 9, "FailedToParse", "Expected a number in: foo.bar: \"x\"");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 2}")), 9, "FailedToParse", "$pop expects 1 or -1, found: 2");
    }

    @Test
    public void testUpdateUnset() throws Exception {
        Document obj = TestUtils.json("_id: 1, a: 1, b: null, c: 'value'");
        collection.insertOne((Object)obj);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, (Bson)TestUtils.json("$unset: {_id: ''}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'a.b.z': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 1, b: null, c: 'value'"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$unset: {a: '', b: ''}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, c: 'value'"));
        collection.updateOne((Bson)obj, Updates.unset((String)"c.y"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, c: 'value'"));
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("a: {b: 'foo', c: 'bar'}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'a.b': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: {c: 'bar'}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'a.b.z': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: {c: 'bar'}"));
    }

    @Test
    public void testUpdateWithIdIn() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document update = TestUtils.json("$push: {n: {_id: 2, u: 3}}, $inc: {c: 4}");
        Document expected = TestUtils.json("_id: 1, n: [{_id: 2, u: 3}], c: 4");
        collection.updateOne((Bson)TestUtils.json("_id: {$in: [1]}"), (Bson)update);
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdateMulti() throws Exception {
        collection.insertOne((Object)TestUtils.json("a: 1"));
        collection.insertOne((Object)TestUtils.json("a: 1"));
        UpdateResult result = collection.updateOne((Bson)TestUtils.json("a: 1"), (Bson)TestUtils.json("$set: {b: 2}"));
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(1L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)new Document("b", (Object)2))).isEqualTo(1L);
        result = collection.updateMany((Bson)TestUtils.json("a: 1"), (Bson)TestUtils.json("$set: {b: 3}"));
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(2L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)new Document("b", (Object)2))).isEqualTo(0L);
        AbstractBackendTest.assertThat(collection.countDocuments((Bson)new Document("b", (Object)3))).isEqualTo(2L);
    }

    @Test
    public void testUpdateIllegalInt() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {x: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}")), 14, "TypeMismatch", "Cannot apply $inc to a value of non-numeric type. {_id: 1} has the field 'a' of non-numeric type object");
        Assertions.assertThatExceptionOfType(MongoServerException.class).isThrownBy(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'a.x': 'b'}"))).withMessageContaining("Cannot increment with non-numeric argument: {a.x: \"b\"}");
    }

    @Test
    public void testUpdateWithIdInMulti() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1"), TestUtils.json("_id: 2")));
        collection.updateMany((Bson)TestUtils.json("_id: {$in: [1, 2]}"), (Bson)TestUtils.json("$set: {n: 1}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, n: 1"), TestUtils.json("_id: 2, n: 1")});
    }

    @Test
    public void testUpdateWithIdInMultiReturnModifiedDocumentCount() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1"), TestUtils.json("_id: 2")));
        UpdateResult result = collection.updateMany((Bson)TestUtils.json("_id: {$in: [1, 2]}"), (Bson)TestUtils.json("$set: {n: 1}"));
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(2L);
    }

    @Test
    public void testUpdateWithIdQuery() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1"), TestUtils.json("_id: 2")));
        collection.updateMany((Bson)TestUtils.json("_id: {$gt:1}"), (Bson)TestUtils.json("$set: {n: 1}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2, n: 1")});
    }

    @Test
    public void testUpdateWithObjectId() {
        collection.insertOne((Object)TestUtils.json("_id: {n: 1}"));
        UpdateResult result = collection.updateOne((Bson)TestUtils.json("_id: {n: 1}"), (Bson)TestUtils.json("$set: {a: 1}"));
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(1L);
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: {n: 1}, a: 1"));
    }

    @Test
    public void testUpdateArrayMatch() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{x: 1, y: 1}, {x: 2, y: 2}, {x: 3, y: 3}]"));
        collection.updateOne((Bson)TestUtils.json("'a.x': 2"), (Bson)TestUtils.json("$inc: {'a.$.y': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("'a.x': 2")).first()).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 1, y: 1}, {x: 2, y: 3}, {x: 3, y: 3}]"));
        collection.insertOne((Object)TestUtils.json("'array': [{'123a': {'name': 'old'}}]"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("'array.123a.name': 'old'")).first()).isNotNull();
        collection.updateOne((Bson)TestUtils.json("'array.123a.name': 'old'"), (Bson)TestUtils.json("$set: {'array.$.123a.name': 'new'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("'array.123a.name': 'new'")).first()).isNotNull();
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("'array.123a.name': 'old'")).first()).isNull();
    }

    @Test
    public void testUpdateArrayMatch_MultipleFields() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{x: 1, y: 1}, {x: 2, y: 2}, {x: 3, y: 3}]"));
        collection.updateOne((Bson)TestUtils.json("'a.x': 2"), (Bson)TestUtils.json("$inc: {'a.$.y': 1, 'a.$.x': 1}, $set: {'a.$.foo': 1, 'a.$.foo2': 1}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json(""))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: [{x: 1, y: 1}, {x: 3, y: 3, foo: 1, foo2: 1}, {x: 3, y: 3}]")});
    }

    @Test
    public void testUpdateArrayMatch_updateMany() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [{id: 1, value: 90}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, grades: [{id: 1, value: 85}, {id: 2, value: 80}, {id: 3, value: 80}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, grades: [{id: 1, value: 50}, {id: 1, value: 80}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.updateMany((Bson)TestUtils.json("'grades.value': 80"), (Bson)TestUtils.json("$set: {'grades.$.value': 82, 'grades.$.changed': true}"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, grades: [{id: 1, value: 90}]"), TestUtils.json("_id: 2, grades: [{id: 1, value: 85}, {id: 2, value: 82, changed: true}, {id: 3, value: 80}]"), TestUtils.json("_id: 3, grades: [{id: 1, value: 50}, {id: 1, value: 82, changed: true}]"), TestUtils.json("_id: 4")});
    }

    @Test
    public void testUpdateWithNotAndSizeOperator() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, array: ['a', 'b']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, array: ['b']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, array: ['a']"));
        collection.updateMany((Bson)TestUtils.json("array: {$not: {$size: 1}}"), (Bson)TestUtils.json("$pull: {array: 'a'}"));
        AbstractBackendTest.assertThat(collection.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, array: ['b']"), TestUtils.json("_id: 2, array: ['b']"), TestUtils.json("_id: 3, array: ['a']")});
    }

    @Test
    public void testMultiUpdateArrayMatch() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 99"));
        collection.updateMany((Bson)TestUtils.json("x: 2"), (Bson)TestUtils.json("$inc: {'x.$': 1}"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2, x: [1, 3, 3]"), TestUtils.json("_id: 3, x: 99")});
    }

    @Test
    public void testUpsert() {
        UpdateResult result = collection.updateMany((Bson)TestUtils.json("n:'jon'"), (Bson)TestUtils.json("$inc: {a: 1}"), new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(0L);
        Document object = (Document)collection.find().first();
        AbstractBackendTest.assertThat(result.getUpsertedId()).isEqualTo((Object)new BsonObjectId(object.getObjectId((Object)"_id")));
        object.remove((Object)"_id");
        AbstractBackendTest.assertThat(object).isEqualTo((Object)TestUtils.json("n: 'jon', a: 1"));
        result = collection.updateOne((Bson)TestUtils.json("_id: 17, n: 'jon'"), (Bson)TestUtils.json("$inc: {a: 1}"), new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat(result.getUpsertedId()).isEqualTo((Object)new BsonInt32(17));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 17")).first()).isEqualTo((Object)TestUtils.json("_id: 17, n: 'jon', a: 1"));
    }

    @Test
    public void testUpsertFieldOrder() throws Exception {
        collection.updateOne((Bson)TestUtils.json("'x.y': 2"), (Bson)TestUtils.json("$inc: {a: 7}"), new UpdateOptions().upsert(true));
        Document obj = (Document)collection.find().first();
        obj.remove((Object)"_id");
        AbstractBackendTest.assertThat(obj).isEqualTo((Object)TestUtils.json("x: {y: 2}, a: 7"));
    }

    @Test
    public void testUpsertWithoutId() {
        UpdateResult result = collection.updateOne(Filters.eq((String)"a", (Object)1), Updates.set((String)"a", (Object)2), new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(0L);
        AbstractBackendTest.assertThat(result.getUpsertedId()).isNotNull();
        AbstractBackendTest.assertThat(((Document)collection.find().first()).get((Object)"_id")).isInstanceOf(ObjectId.class);
        AbstractBackendTest.assertThat(((Document)collection.find().first()).get((Object)"a")).isEqualTo((Object)2);
    }

    @Test
    public void testUpsertOnIdWithPush() {
        Document update1 = TestUtils.json("$push: {c: {a: 1, b: 2}}");
        Document update2 = TestUtils.json("$push: {c: {a: 3, b: 4}}");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)update1, new UpdateOptions().upsert(true));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)update2, new UpdateOptions().upsert(true));
        Document expected = TestUtils.json("_id: 1, c: [{a: 1, b: 2}, {a: 3, b: 4}]");
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("'c.a':3, 'c.b':4")).first()).isEqualTo((Object)expected);
    }

    @Test
    public void testUpsertWithConditional() {
        Document query = TestUtils.json("_id: 1, b: {$gt: 5}");
        Document update = TestUtils.json("$inc: {a: 1}");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat(updateResult.getModifiedCount()).isZero();
        AbstractBackendTest.assertThat(updateResult.getMatchedCount()).isZero();
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testUpsertWithoutChange() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 2, b: 3"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$set: {a: 2}");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat(updateResult.getModifiedCount()).isZero();
        AbstractBackendTest.assertThat(updateResult.getMatchedCount()).isOne();
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: 3"));
    }

    @Test
    public void testUpsertWithEmbeddedQuery() {
        collection.updateOne((Bson)TestUtils.json("_id: 1, 'e.i': 1"), (Bson)TestUtils.json("$set: {a: 1}"), new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, e: {i: 1}, a: 1"));
    }

    @Test
    public void testUpsertWithIdIn() throws Exception {
        Document query = TestUtils.json("_id: {$in: [1]}");
        Document update = TestUtils.json("$push: {n: {_id: 2 ,u : 3}}, $inc: {c: 4}");
        Document expected = TestUtils.json("_id: 1, n: [{_id: 2 ,u : 3}], c: 4");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat(updateResult.getModifiedCount()).isZero();
        AbstractBackendTest.assertThat(updateResult.getMatchedCount()).isZero();
        Document actual = (Document)collection.find().first();
        AbstractBackendTest.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void testUpsertWithId() throws Exception {
        Document query = TestUtils.json("somekey: 'somevalue'");
        Document update = TestUtils.json("$set: { _id: 'someid', somekey: 'some value' }");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        AbstractBackendTest.assertThat(updateResult.getModifiedCount()).isZero();
        AbstractBackendTest.assertThat(updateResult.getMatchedCount()).isZero();
        AbstractBackendTest.assertThat(updateResult.getUpsertedId()).isEqualTo((Object)new BsonString("someid"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'someid', somekey: 'some value' ")});
    }

    @Test
    public void testUpsertWithId_duplicateKey() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 'someid', somekey: 'other value'"));
        Document query = TestUtils.json("somekey: 'some value'");
        Document update = TestUtils.json("$set: { _id: 'someid', somekey: 'some value' }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true)), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: \"someid\" }");
    }

    @Test
    public void testReplaceOneWithId() throws Exception {
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, value: 'abc'"), new ReplaceOptions().upsert(true));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: 'abc'")});
        collection.replaceOne((Bson)TestUtils.json("value: 'xyz'"), (Object)TestUtils.json("_id: 2, value: 'xyz'"), new ReplaceOptions().upsert(true));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: 'abc'"), TestUtils.json("_id: 2, value: 'xyz'")});
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("value: 'z'"), (Object)TestUtils.json("_id: 2, value: 'z'"), new ReplaceOptions().upsert(true)), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 2 }");
    }

    @Test
    public void testReplaceOneWithIdAndRevision() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, revision: 1"));
        collection.createIndex((Bson)TestUtils.json("revision: 1"));
        UpdateResult firstUpdateResult = collection.replaceOne((Bson)TestUtils.json("_id: 1, revision: 1"), (Object)TestUtils.json("_id: 1, revision: 2, value: 'abc'"));
        AbstractBackendTest.assertThat(firstUpdateResult.getModifiedCount()).isEqualTo(1L);
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, revision: 2, value: 'abc'")});
        UpdateResult secondUpdateResult = collection.replaceOne((Bson)TestUtils.json("_id: 1, revision: 1"), (Object)TestUtils.json("_id: 1, revision: 3, value: 'xyz'"));
        AbstractBackendTest.assertThat(secondUpdateResult.getModifiedCount()).isZero();
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, revision: 2, value: 'abc'")});
    }

    @Test
    public void testReplaceOneUpsertsWithGeneratedId() throws Exception {
        collection.replaceOne((Bson)TestUtils.json("value: 'abc'"), (Object)TestUtils.json("value: 'abc'"), new ReplaceOptions().upsert(true));
        AbstractBackendTest.assertThat(collection.find()).extracting(document -> document.get((Object)"value")).containsExactly(new Object[]{"abc"});
        AbstractBackendTest.assertThat(((Document)collection.find().first()).get((Object)"_id")).isInstanceOf(ObjectId.class);
    }

    @Test
    public void testBulkUpsert() throws Exception {
        List<ReplaceOneModel> models = Arrays.asList(new ReplaceOneModel(Filters.eq((String)"_id", (Object)1), (Object)TestUtils.json("_id: 1, a: 1"), new ReplaceOptions().upsert(true)), new ReplaceOneModel(Filters.eq((String)"_id", (Object)2), (Object)TestUtils.json("_id: 2, a: 1"), new ReplaceOptions().upsert(true)));
        BulkWriteResult result = collection.bulkWrite(models, new BulkWriteOptions().ordered(false));
        AbstractBackendTest.assertThat(result.getUpserts()).extracting(BulkWriteUpsert::getId).containsExactly((Object[])new BsonValue[]{new BsonInt32(1), new BsonInt32(2)});
        AbstractBackendTest.assertThat(result.getUpserts()).extracting(BulkWriteUpsert::getIndex).containsExactly((Object[])new Integer[]{0, 1});
        AbstractBackendTest.assertThat(collection.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 1"), TestUtils.json("_id: 2, a: 1")});
        models = Arrays.asList(new ReplaceOneModel(Filters.eq((String)"_id", (Object)1), (Object)TestUtils.json("_id: 1, a: 2"), new ReplaceOptions().upsert(true)), new ReplaceOneModel(Filters.eq((String)"_id", (Object)3), (Object)TestUtils.json("_id: 3, a: 2"), new ReplaceOptions().upsert(true)), new ReplaceOneModel(Filters.eq((String)"_id", (Object)2), (Object)TestUtils.json("_id: 2, a: 2"), new ReplaceOptions().upsert(true)));
        result = collection.bulkWrite(models, new BulkWriteOptions().ordered(false));
        AbstractBackendTest.assertThat(result.getUpserts()).extracting(BulkWriteUpsert::getId).containsExactly((Object[])new BsonValue[]{new BsonInt32(3)});
        AbstractBackendTest.assertThat(result.getUpserts()).extracting(BulkWriteUpsert::getIndex).containsExactly((Object[])new Integer[]{1});
        AbstractBackendTest.assertThat(collection.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 2"), TestUtils.json("_id: 2, a: 2"), TestUtils.json("_id: 3, a: 2")});
    }

    @Test
    public void testUpdateWithMultiplyOperator() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {a: 2}, $set: {b: 2}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 0, b: 2"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {b: 2.5}, $inc: {a: 0.5}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)TestUtils.json("_id: 1, a: 0.5, b: 5.0"));
    }

    @Test
    public void testUpdateWithIllegalMultiplyFails() throws Exception {
        Document object = TestUtils.json("_id: 1, foo: 'x', bar: 1");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {_id: 2}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {foo: 2}")), 14, "TypeMismatch", "Cannot apply $mul to a value of non-numeric type. {_id: 1} has the field 'foo' of non-numeric type string");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {bar: 'x'}")), 14, "TypeMismatch", "Cannot multiply with non-numeric argument: {bar: \"x\"}");
    }

    @Test
    public void testIsMaster() throws Exception {
        Document isMaster = this.runCommand("isMaster");
        AbstractBackendTest.assertThat(isMaster.getBoolean((Object)"ismaster")).isTrue();
        AbstractBackendTest.assertThat(isMaster.getDate((Object)"localTime")).isInstanceOf(Date.class);
        Integer maxBsonObjectSize = isMaster.getInteger((Object)"maxBsonObjectSize");
        AbstractBackendTest.assertThat(maxBsonObjectSize).isEqualTo(0x1000000);
        AbstractBackendTest.assertThat(isMaster.getInteger((Object)"maxMessageSizeBytes")).isGreaterThan((Comparable)maxBsonObjectSize);
    }

    @Test
    public void testFindWithNullOrNoFieldFilter() {
        collection.insertOne((Object)TestUtils.json("name: 'jon', group: 'group1'"));
        collection.insertOne((Object)TestUtils.json("name: 'leo', group: 'group1'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil1', group: 'group2'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil2', group: null"));
        collection.insertOne((Object)TestUtils.json("name: 'neil3'"));
        ((IterableAssert)AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("group: null"))).as("should have two neils (neil2, neil3)", new Object[0])).hasSize(2);
        ((IterableAssert)AbstractBackendTest.assertThat(collection.find(Filters.exists((String)"group", (boolean)false))).as("should have one neils (neil3)", new Object[0])).hasSize(1);
        ((IterableAssert)AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("other: null"))).as("should return all documents", new Object[0])).hasSize(5);
        ((IterableAssert)AbstractBackendTest.assertThat(collection.find(Filters.exists((String)"other", (boolean)false))).as("should return all documents", new Object[0])).hasSize(5);
    }

    @Test
    public void testInsertWithIllegalId() throws Exception {
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: [1, 2, 3]")), 2, "BadValue", "can't use an array for _id");
    }

    @Test
    public void testInsertsWithUniqueIndex() {
        collection.createIndex((Bson)new Document("uniqueKeyField", (Object)1), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc1', afield: 'avalue'"));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc2', afield: 'avalue'"));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc3', afield: 'avalue'"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc2', afield: 'avalue'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: uniqueKeyField_1 dup key: { uniqueKeyField: \"abc2\" }");
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 1"));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 1.1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("uniqueKeyField: 1.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: uniqueKeyField_1 dup key: { uniqueKeyField: 1.0 }");
    }

    @Test
    public void testInsertBinaryData() throws Exception {
        collection.insertOne((Object)new Document("test", (Object)new byte[]{1, 2, 3}));
    }

    @Test
    public void testUniqueIndexWithSubdocument() {
        collection.createIndex((Bson)TestUtils.json("'action.actionId': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, action: 'abc1'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, action: {actionId: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, action: {actionId: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, action: {actionId: 3}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("action: {actionId: 1.0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: action.actionId_1 dup key: { action.actionId: 1.0 }");
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("action: 'abc1'"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, action: 'abc1'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'action.actionId': 2"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, action: {actionId: 2}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("action: {actionId: 2}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, action: {actionId: 2}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'action.actionId.subKey': 23"))).isEmpty();
    }

    @Test
    public void testUniqueIndexWithDeepDocuments() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: {b: {c: 1, d: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: {b: {d: 1, c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: {b: 1, c: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {c: 1, d: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 9, a: {c: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: 0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: { b: 0 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: 0.00}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: { b: 0.0 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: -0.0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: { b: -0.0 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1.0}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: { b: { c: 1.0 } } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1, d: 1.0}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: { b: { c: 1, d: 1.0 } } }");
    }

    @Test
    public void testSecondaryUniqueIndexUpdate() throws Exception {
        collection.createIndex((Bson)TestUtils.json("text: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, text: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, text: 'def'"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 4")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { text: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'def'"))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { text: \"def\" }");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'xyz'")));
        collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'abc'")));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: null"))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { text: null }");
        collection.deleteOne((Bson)TestUtils.json("text: 'xyz'"));
        AbstractBackendTest.assertThat(collection.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, text: 'abc'"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testSecondarySparseUniqueIndex() throws Exception {
        collection.createIndex((Bson)TestUtils.json("text: 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, text: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, text: 'def'"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, text: null"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 6, text: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { text: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 7, text: 'abc'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { text: \"abc\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: null"))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { text: null }");
        collection.deleteOne((Bson)TestUtils.json("_id: 5"));
        collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: null")));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'def'")));
        collection.deleteMany((Bson)TestUtils.json("text: null"));
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, text: 'def'")});
    }

    @Test
    public void testCompoundSparseUniqueIndex() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: null"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 7, a: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: null, b: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 7, b: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: null, b: null }");
        collection.deleteMany((Bson)TestUtils.json("a: null, b: null"));
        AbstractBackendTest.assertThat(collection.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 10, b: 20"), TestUtils.json("_id: 2, a: 10"), TestUtils.json("_id: 3, b: 20")});
    }

    @Test
    public void testCompoundSparseUniqueIndexOnEmbeddedDocuments() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'a.x': 1, 'b.x': 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {x: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, b: {x: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: {x: 1}, b: {x: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: {x: 2}, b: {x: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {x: null}, b: {x: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 9"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 10, a: {x: 1.0}, b: {x: 2.0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.x_1_b.x_1 dup key: { a.x: 1.0, b.x: 2.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 11, a: {x: null}, b: {x: null}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.x_1_b.x_1 dup key: { a.x: null, b.x: null }");
        collection.deleteMany((Bson)TestUtils.json("a: {x: null}, b: {x: null}"));
        collection.deleteMany((Bson)TestUtils.json("a: 10"));
        collection.deleteMany((Bson)TestUtils.json("b: 20"));
        AbstractBackendTest.assertThat(collection.find()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 4, a: {x: 1}"), TestUtils.json("_id: 5, b: {x: 2}"), TestUtils.json("_id: 6, a: {x: 1}, b: {x: 2}"), TestUtils.json("_id: 7, a: {x: 2}, b: {x: 2}"), TestUtils.json("_id: 9")});
    }

    @Test
    public void testUpdateWithSparseUniqueIndex() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {a: 'x'}"));
        collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$set: {a: 'y'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {a: 'y'}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: \"y\" }");
        collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$unset: {a: 1}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {a: 'y'}"));
    }

    @Test
    public void testSparseUniqueIndexOnEmbeddedDocument() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'a.b.c': 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("a: 1"));
        collection.insertOne((Object)TestUtils.json("a: 1"));
        collection.insertOne((Object)TestUtils.json("a: null"));
        collection.insertOne((Object)TestUtils.json("a: null"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 2}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: null}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: 1}}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: null}}}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: null}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1, x: 100}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: 1}}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: { d: 1 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: null}}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: { d: null } }");
    }

    @Test
    public void testUniqueIndexOnArrayField() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, a: ['val1', 'val2']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: ['val3', 'val4']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: []"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: ['val5']"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: ['val1']")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: \"val1\" }'");
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val1']")))).isEmpty();
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val1', 'val3']")))).isEmpty();
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val1', 'val10']")))).isEmpty();
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val10']")))).isEmpty();
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val5']")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 4, a: ['val5']")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val1', 'val2']")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: ['val1', 'val2']")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val2', 'val1']")))).isEmpty();
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {$all: ['val1', 'val2']}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: ['val1', 'val2']")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {$all: ['val2', 'val1']}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: ['val1', 'val2']")});
    }

    @Test
    public void testUniqueIndexOnArrayField_updates() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, a: ['val1', 'val2']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: ['val3', 'val4']"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: ['val1', 'val3']")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: \"val3\" }'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$push: {a: 'val3'}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: \"val3\" }");
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: ['val1', 'val5']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: ['val2']"));
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val1', 'val5']")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: ['val1', 'val5']")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val2']")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: ['val2']")});
        collection.updateOne((Bson)TestUtils.json("a: ['val2']"), (Bson)TestUtils.json("$push: {a: 'val7'}"));
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: ['val2', 'val7']")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: ['val2', 'val7']")});
    }

    @Test
    public void testUniqueIndexOnArrayFieldInSubdocument() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'a.b': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: ['val1', 'val2']}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: ['val3', 'val4']}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: []"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {b: 'val5'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: ['val1']}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b_1 dup key: { a.b: \"val1\" }'");
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.b': 'val5'")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 4, a: {b: 'val5'}")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.b': ['val1', 'val2']")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: ['val1', 'val2']}")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {b: ['val1', 'val2']}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: ['val1', 'val2']}")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.b': ['val1']")))).isEmpty();
    }

    @Test
    public void testAddNonUniqueIndexOnNonIdField() {
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(1);
        collection.createIndex((Bson)new Document("someField", (Object)1), new IndexOptions().unique(false));
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(2);
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
    }

    @Test
    public void testAddSparseIndexOnNonIdField() {
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(1);
        collection.createIndex((Bson)new Document("someField", (Object)1), new IndexOptions().sparse(true));
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(2);
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
    }

    @Test
    public void testDeleteAllDocumentsWithUniqueSparseIndex() {
        collection.createIndex((Bson)new Document("someField.values", (Object)1), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, someField: {values: ['abc']}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, someField: {values: ['other']}"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, someField: ['abc']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, someField: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 6, someField: null"));
        collection.deleteMany((Bson)TestUtils.json(""));
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testAddPartialIndexOnNonIdField() {
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(1);
        collection.createIndex((Bson)new Document("someField", (Object)1), new IndexOptions().partialFilterExpression((Bson)TestUtils.json("someField: {$gt: 5}")));
        AbstractBackendTest.assertThat(collection.listIndexes()).hasSize(2);
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
    }

    @Test
    public void testCompoundUniqueIndices() {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'foo', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 'foo', b: 'bar'"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 'bar', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: {x: 1, y: 1}, b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {x: 1, y: 2}, b: 'foo'"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: 'foo', b: 'foo'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: \"foo\", b: \"foo\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("b: 'foo'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: null, b: \"foo\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {x: 1, y: 1}, b: 'foo'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: { x: 1, y: 1 }, b: \"foo\" }");
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: 'bar'"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 6, a: 'bar', b: 'foo'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("b: 'foo', a: 'bar'"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 6, a: 'bar', b: 'foo'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: 'foo'"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: 'foo'"), TestUtils.json("_id: 4, a: 'foo', b: 'foo'"), TestUtils.json("_id: 5, a: 'foo', b: 'bar'")});
    }

    @Test
    public void testCompoundUniqueIndices_Subdocument() {
        collection.createIndex((Bson)TestUtils.json("a: 1, 'b.c': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 'foo', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 'bar', b: {c: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'bar', b: {c: 2}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: 'bar', b: {c: 1}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b.c_1 dup key: { a: \"bar\", b.c: 1 }");
    }

    @Test
    public void testCompoundUniqueIndicesWithInQuery() {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'foo', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 'foo', b: 'bar'"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: 'foo', b: { $in: ['bar'] }"))).hasSize(1);
    }

    @Test
    public void testAddUniqueIndexOnExistingDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 'a'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 'b'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 'c'"));
        collection.createIndex((Bson)TestUtils.json("value: 1"), new IndexOptions().unique(true));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("value: 'c'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { value: \"c\" }");
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 'd'"));
    }

    @Test
    public void testAddUniqueIndexOnExistingDocuments_violatingUniqueness() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 'a'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 'b'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 'c'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 'b'"));
        Assertions.assertThatExceptionOfType(DuplicateKeyException.class).isThrownBy(() -> collection.createIndex((Bson)TestUtils.json("value: 1"), new IndexOptions().unique(true))).withMessage("Write failed with error code 11000 and error message 'E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { value: \"b\" }'");
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactly((Object[])new Document[]{TestUtils.json("name: '_id_', ns: 'testdb.testcoll', key: {_id: 1}, v: 2")});
        collection.insertOne((Object)TestUtils.json("_id: 5, value: 'a'"));
    }

    @Test
    public void testCursorOptionNoTimeout() throws Exception {
        try (MongoCursor cursor = collection.find().noCursorTimeout(true).iterator();){
            AbstractBackendTest.assertThat(cursor.hasNext()).isFalse();
        }
    }

    @Test
    public void testBulkInsert() throws Exception {
        ArrayList<InsertOneModel> inserts = new ArrayList<InsertOneModel>();
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 1")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 2")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 3")));
        BulkWriteResult result = collection.bulkWrite(inserts);
        AbstractBackendTest.assertThat(result.getInsertedCount()).isEqualTo(3);
    }

    @Test
    public void testLargeBulkInsert() throws Exception {
        ArrayList<InsertOneModel> inserts = new ArrayList<InsertOneModel>();
        for (int i = 0; i < 1000; ++i) {
            inserts.add(new InsertOneModel((Object)new Document("_id", (Object)(i + 1)).append("data", (Object)"some longer string too cause some data on the wire")));
        }
        BulkWriteResult result = collection.bulkWrite(inserts);
        AbstractBackendTest.assertThat(result.getInsertedCount()).isEqualTo(1000);
    }

    @Test
    public void testBulkInsert_withDuplicate() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        ArrayList<InsertOneModel> inserts = new ArrayList<InsertOneModel>();
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 1")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 2")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 3")));
        Assertions.assertThatExceptionOfType(MongoBulkWriteException.class).isThrownBy(() -> collection.bulkWrite(inserts)).withMessageContaining("BulkWriteError{index=1, code=11000, message='E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 2 }'");
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2")});
    }

    @Test
    public void testBulkInsert_unordered_withDuplicate() throws Exception {
        ArrayList<InsertOneModel> inserts = new ArrayList<InsertOneModel>();
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 1")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 2")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 2")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 3")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 3")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 4")));
        Assertions.assertThatExceptionOfType(MongoBulkWriteException.class).isThrownBy(() -> collection.bulkWrite(inserts, new BulkWriteOptions().ordered(false))).withMessageContaining("Write errors: [BulkWriteError{index=2, code=11000, message='E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 2 }', details={}}, BulkWriteError{index=4, code=11000, message='E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 3 }', details={}}].");
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3"), TestUtils.json("_id: 4")});
    }

    @Test
    public void testBulkUpdateOrdered() throws Exception {
        this.testBulkUpdate(true);
    }

    @Test
    public void testBulkUpdateUnordered() throws Exception {
        this.testBulkUpdate(false);
    }

    private void testBulkUpdate(boolean ordered) {
        this.insertUpdateInBulk(ordered);
        this.removeInBulk(ordered);
        this.insertUpdateInBulkNoMatch(ordered);
    }

    @Test
    public void testUpdateCurrentDateIllegalTypeSpecification() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: null}")), 2, "BadValue", "null is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: 123.456}")), 2, "BadValue", "double is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: 'foo'}")), 2, "BadValue", "string is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: {$type: 'foo'}}")), 2, "BadValue", "The '$type' string field is required to be 'date' or 'timestamp': {$currentDate: {field : {$type: 'date'}}}");
        AbstractBackendTest.assertThat((Document)collection.find((Bson)object).first()).isEqualTo((Object)object);
    }

    @Test
    public void testUpdateCurrentDate() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {'x.lastModified': true}"));
        AbstractBackendTest.assertThat(((Document)((Document)collection.find((Bson)object).first()).get((Object)"x")).get((Object)"lastModified")).isInstanceOf(Date.class);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {'x.lastModified': {$type: 'date'}}"));
        AbstractBackendTest.assertThat(((Document)((Document)collection.find((Bson)object).first()).get((Object)"x")).get((Object)"lastModified")).isInstanceOf(Date.class);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {'x.lastModified': {$type: 'timestamp'}}"));
        AbstractBackendTest.assertThat(((Document)((Document)collection.find((Bson)object).first()).get((Object)"x")).get((Object)"lastModified")).isInstanceOf(BsonTimestamp.class);
    }

    @Test
    public void testRenameField() throws Exception {
        Document object = TestUtils.json("_id: 1, foo: 'x', bar: 'y'");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: 'foo2', bar: 'bar2'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, foo2: 'x', bar2: 'y'"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'bar2': 'foo', foo2: 'bar'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, bar: 'x', foo: 'y'"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'bar': 'bar2', 'missing': 'foo'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, bar2: 'x', foo: 'y'"));
    }

    @Test
    public void testRenameField_embeddedDocument() {
        Document object = TestUtils.json("_id: 1, foo: { a: 1, b: 2 }, bar: { c: 3, d: 4 }}");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.a': 'foo.z', 'bar.c': 'bar.x'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, foo: { z: 1, b: 2 }, bar: { x: 3, d: 4 }}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.z': 'foo.a', 'bar.a': 'bar.b'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, foo: { a: 1, b: 2 }, bar: { x: 3, d: 4 }}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'missing.a': 'missing.b'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, foo: { a: 1, b: 2 }, bar: { x: 3, d: 4 }}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.a': 'a', 'bar.x': 'bar.c'}"));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, foo: { b: 2 }, bar: { c: 3, d: 4 }, a: 1}"));
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.b.c': 'foo.b.d'}")));
    }

    @Test
    public void testRenameFieldIllegalValue() throws Exception {
        Document object = TestUtils.json("_id: 1, foo: 'x', bar: 'y'");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: 12345}")), 2, "BadValue", "The 'to' field for $rename must be a string: foo: 12345");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'_id': 'id'}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: '_id'}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: 'bar', 'bar': 'bar2'}")), 40, "ConflictingUpdateOperators", "Updating the path 'bar' would create a conflict at 'bar'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {bar: 'foo', bar2: 'foo'}")), 40, "ConflictingUpdateOperators", "Updating the path 'foo' would create a conflict at 'foo'");
    }

    @Test
    public void testRenameCollection() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 30"));
        collection.createIndex((Bson)new Document("a", (Object)1), new IndexOptions().unique(true));
        collection.renameCollection(new MongoNamespace(collection.getNamespace().getDatabaseName(), "other-collection-name"));
        AbstractBackendTest.assertThat(db.listCollectionNames()).containsExactly((Object[])new String[]{"other-collection-name"});
        MongoCollection<Document> otherCollection = this.getCollection("other-collection-name");
        AbstractBackendTest.assertThat(otherCollection.countDocuments()).isEqualTo(3L);
        AbstractBackendTest.assertThat(otherCollection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("name: '_id_', ns: 'testdb.other-collection-name', key: {_id: 1}, v: 2"), TestUtils.json("name: 'a_1', ns: 'testdb.other-collection-name', key: {a: 1}, unique: true, v: 2")});
        AbstractBackendTest.assertThat(collection.listIndexes()).isEmpty();
    }

    @Test
    public void testRenameCollection_targetAlreadyExists() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        MongoCollection otherCollection = db.getCollection("other-collection-name");
        otherCollection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.renameCollection(new MongoNamespace(db.getName(), "other-collection-name"))).withMessageContaining("Command failed with error 48 (NamespaceExists): 'target namespace exists'");
        AbstractBackendTest.assertThat(db.listCollectionNames()).containsExactlyInAnyOrder((Object[])new String[]{this.getCollectionName(), "other-collection-name"});
        AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo(3L);
        AbstractBackendTest.assertThat(this.getCollection("other-collection-name").countDocuments()).isEqualTo(1L);
    }

    @Test
    public void testRenameCollection_dropTarget() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        MongoCollection otherCollection = db.getCollection("other-collection-name");
        otherCollection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertThat(collection.listIndexes()).extracting(index -> index.getString((Object)"name")).containsExactly((Object[])new String[]{"_id_"});
        collection.renameCollection(new MongoNamespace(db.getName(), "other-collection-name"), new RenameCollectionOptions().dropTarget(true));
        AbstractBackendTest.assertThat(db.listCollectionNames()).containsExactly((Object[])new String[]{"other-collection-name"});
        MongoCollection<Document> renamedCollection = this.getCollection("other-collection-name");
        AbstractBackendTest.assertThat(renamedCollection.listIndexes()).extracting(index -> index.getString((Object)"name")).containsExactly((Object[])new String[]{"_id_"});
        AbstractBackendTest.assertThat(renamedCollection.countDocuments()).isEqualTo(3L);
    }

    @Test
    public void testListIndexes_empty() throws Exception {
        AbstractBackendTest.assertThat(collection.listIndexes()).isEmpty();
    }

    @Test
    public void testListIndexes() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        MongoCollection other = db.getCollection("other");
        other.insertOne((Object)TestUtils.json("_id: 1"));
        collection.createIndex((Bson)TestUtils.json("bla: 1"));
        collection.createIndex((Bson)new Document("a", (Object)1), new IndexOptions().unique(true));
        collection.createIndex((Bson)new Document("a", (Object)1).append("b", (Object)-1.0), new IndexOptions().unique(true));
        AbstractBackendTest.assertThat(collection.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("name: '_id_', ns: 'testdb.testcoll', key: {_id: 1}, v: 2"), TestUtils.json("name: 'bla_1', ns: 'testdb.testcoll', key: {bla: 1}, v: 2"), TestUtils.json("name: 'a_1', ns: 'testdb.testcoll', key: {a: 1}, unique: true, v: 2"), TestUtils.json("name: 'a_1_b_-1', ns: 'testdb.testcoll', key: {a: 1, b: -1.0}, unique: true, v: 2")});
        AbstractBackendTest.assertThat(other.listIndexes()).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("name: '_id_', ns: 'testdb.other', key: {_id: 1}, v: 2")});
    }

    @Test
    public void testFieldSelection_deselectId() {
        collection.insertOne((Object)TestUtils.json("_id: 1, order:1, visits: 2"));
        Document document = (Document)collection.find((Bson)TestUtils.json("")).projection((Bson)TestUtils.json("_id: 0")).first();
        AbstractBackendTest.assertThat(document).isEqualTo((Object)TestUtils.json("order:1, visits:2"));
    }

    @Test
    public void testFieldSelection_deselectOneField() {
        Document obj = TestUtils.json("_id: 1, order:1, visits: 2, eid: 12345");
        collection.insertOne((Object)obj);
        Document document = (Document)collection.find((Bson)new Document()).projection((Bson)TestUtils.json("visits: 0")).first();
        AbstractBackendTest.assertThat(document).isEqualTo((Object)TestUtils.json("_id: 1, order:1, eid: 12345"));
    }

    @Test
    public void testFieldSelection_deselectTwoFields() {
        Document obj = TestUtils.json("_id: 1, order:1, visits: 2, eid: 12345");
        collection.insertOne((Object)obj);
        Document document = (Document)collection.find((Bson)new Document()).projection((Bson)TestUtils.json("visits: 0, eid: 0")).first();
        AbstractBackendTest.assertThat(document).isEqualTo((Object)TestUtils.json("_id: 1, order:1"));
    }

    @Test
    public void testFieldSelection_selectAndDeselectFields() {
        Document obj = TestUtils.json("_id: 1, order:1, visits: 2, eid: 12345");
        collection.insertOne((Object)obj);
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)new Document()).projection((Bson)TestUtils.json("visits: 0, eid: 1")).first()).withMessageContaining("Command failed with error 2 (BadValue): 'Projection cannot have a mix of inclusion and exclusion.'");
    }

    @Test
    public void testPullWithInPattern() {
        collection.insertOne((Object)TestUtils.json("_id: 1, tags: ['aa', 'bb', 'ab', 'cc']"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.pullByFilter((Bson)Filters.in((String)"tags", (Object[])new Pattern[]{Pattern.compile("a+")})));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, tags: ['bb', 'cc']"));
    }

    @Test
    public void testPullWithInPatternAnchored() {
        collection.insertOne((Object)TestUtils.json("_id: 1, tags: ['aa', 'bb', 'ab', 'cc']"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.pullByFilter((Bson)Filters.in((String)"tags", (Object[])new Pattern[]{Pattern.compile("^a+$")})));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, tags: ['bb', 'ab', 'cc']"));
    }

    @Test
    public void testPullWithInNumbers() {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [1, 2, 2.5, 3.0, 4]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.pullByFilter((Bson)Filters.in((String)"values", Arrays.asList(2.0, 3, 4L))));
        AbstractBackendTest.assertThat((Document)collection.find().first()).isEqualTo((Object)TestUtils.json("_id: 1, values: [1, 2.5]"));
    }

    @Test
    public void testDocumentWithHashMap() {
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("foo", OTHER_TEST_DATABASE_NAME);
        collection.insertOne((Object)new Document("_id", (Object)1).append("map", value));
        Bson document = (Bson)collection.find().first();
        AbstractBackendTest.assertThat(document).isEqualTo((Object)TestUtils.json("_id: 1, map: {foo: 'bar'}"));
    }

    @Test
    public void testFindAndOfOrs() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)1).append("published", (Object)true).append("startDate", (Object)TestUtils.instant("2015-03-01T13:20:05Z")));
        collection.insertOne((Object)new Document("_id", (Object)2).append("published", (Object)true).append("expiration", (Object)TestUtils.instant("2020-12-31T18:00:00Z")));
        collection.insertOne((Object)new Document("_id", (Object)3).append("published", (Object)true));
        collection.insertOne((Object)new Document("_id", (Object)4).append("published", (Object)false));
        collection.insertOne((Object)new Document("_id", (Object)5).append("published", (Object)true).append("startDate", (Object)TestUtils.instant("2017-01-01T00:00:00Z")));
        collection.insertOne((Object)new Document("_id", (Object)6).append("published", (Object)true).append("expiration", (Object)TestUtils.instant("2016-01-01T00:00:00Z")));
        Instant instant = TestUtils.instant("2016-01-01T00:00:00Z");
        Bson query = Filters.and((Bson[])new Bson[]{Filters.ne((String)"published", (Object)false), Filters.or((Bson[])new Bson[]{Filters.exists((String)"startDate", (boolean)false), Filters.lt((String)"startDate", (Object)instant)}), Filters.or((Bson[])new Bson[]{Filters.exists((String)"expiration", (boolean)false), Filters.gt((String)"expiration", (Object)instant)})});
        AbstractBackendTest.assertThat(collection.find(query).projection((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testInOperatorWithNullValue() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1, a: 1"), TestUtils.json("_id: 2, a: 2"), TestUtils.json("_id: 3, a: 3"), TestUtils.json("_id: 4, a: 4"), TestUtils.json("_id: 5")));
        Bson inQueryWithNull = Filters.in((String)"a", (Object[])new Integer[]{2, null, 3});
        AbstractBackendTest.assertThat(collection.find(inQueryWithNull).projection((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2"), TestUtils.json("_id: 3"), TestUtils.json("_id: 5")});
    }

    @Test
    public void testQueryWithReference() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        String collectionName = this.getCollectionName();
        collection.insertOne((Object)new Document("_id", (Object)2).append("ref", (Object)new DBRef(collectionName, (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)3).append("ref", (Object)new DBRef(collectionName, (Object)2)));
        Document doc = (Document)collection.find((Bson)new Document("ref", (Object)new DBRef(collectionName, (Object)1))).projection((Bson)TestUtils.json("_id: 1")).first();
        AbstractBackendTest.assertThat(doc).isEqualTo((Object)TestUtils.json("_id: 2"));
    }

    @Test
    public void testQueryWithIllegalReference() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        String collectionName = this.getCollectionName();
        collection.insertOne((Object)new Document("_id", (Object)2).append("ref", (Object)new DBRef(collectionName, (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)3).append("ref", (Object)new DBRef(collectionName, (Object)2)));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("ref: {$ref: 'coll'}")).first()).withMessageContaining("Command failed with error 2 (BadValue): 'unknown operator: $ref'");
    }

    @Test
    public void testAndOrNorWithEmptyArray() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find(Filters.and((Bson[])new Bson[0])).first()).withMessageContaining("Command failed with error 2 (BadValue): '$and/$or/$nor must be a nonempty array'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find(Filters.nor((Bson[])new Bson[0])).first()).withMessageContaining("Command failed with error 2 (BadValue): '$and/$or/$nor must be a nonempty array'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find(Filters.or((Bson[])new Bson[0])).first()).withMessageContaining("Command failed with error 2 (BadValue): '$and/$or/$nor must be a nonempty array'");
    }

    @Test
    public void testInsertLargeDocument() throws Exception {
        this.insertAndFindLargeDocument(100, 1);
        this.insertAndFindLargeDocument(1000, 2);
        this.insertAndFindLargeDocument(10000, 3);
    }

    @Test
    public void testInsertAndUpdateAsynchronously() throws Exception {
        int numDocuments = 1000;
        final CountDownLatch latch = new CountDownLatch(numDocuments);
        final LinkedBlockingQueue errors = new LinkedBlockingQueue();
        final Semaphore concurrentOperationsOnTheFly = new Semaphore(50);
        for (int i = 1; i <= numDocuments; ++i) {
            final Document document = new Document("_id", (Object)i);
            for (int j = 0; j < 10; ++j) {
                document.append("key-" + i + "-" + j, (Object)("value-" + i + "-" + j));
            }
            concurrentOperationsOnTheFly.acquire();
            asyncCollection.insertOne((Object)document).subscribe((Subscriber)new Subscriber<InsertOneResult>(){

                public void onSubscribe(Subscription s) {
                    s.request(Integer.MAX_VALUE);
                }

                public void onNext(InsertOneResult result) {
                    log.info("inserted {}", (Object)document);
                    final Document query = new Document("_id", (Object)document.getInteger((Object)"_id"));
                    AbstractTest.asyncCollection.updateOne((Bson)query, Updates.set((String)"updated", (Object)true)).subscribe((Subscriber)new Subscriber<UpdateResult>(){

                        public void onSubscribe(Subscription s) {
                            s.request(Integer.MAX_VALUE);
                        }

                        public void onNext(UpdateResult updateResult) {
                            log.info("updated {}: {}", (Object)query, (Object)updateResult);
                        }

                        public void onError(Throwable t) {
                            this.handleError("update", t);
                        }

                        public void onComplete() {
                            this.release();
                        }
                    });
                }

                public void onError(Throwable t) {
                    this.handleError("insert", t);
                }

                public void onComplete() {
                    log.info("insert completed");
                }

                private void handleError(String operation, Throwable t) {
                    log.error(operation + " of {} failed", (Object)document, (Object)t);
                    RuntimeException exception = new RuntimeException("Failed to " + operation + " " + document, t);
                    errors.add(exception);
                    this.release();
                    throw exception;
                }

                private void release() {
                    latch.countDown();
                    concurrentOperationsOnTheFly.release();
                }
            });
        }
        boolean success = latch.await(30L, TimeUnit.SECONDS);
        AbstractBackendTest.assertThat(success).isTrue();
        if (!errors.isEmpty()) {
            throw (RuntimeException)errors.poll();
        }
        log.info("finished");
        for (int i = 1; i <= numDocuments; ++i) {
            Document query = new Document("_id", (Object)i);
            Document document = (Document)collection.find((Bson)query).first();
            ((MapAssert)AbstractBackendTest.assertThat(document).describedAs(query.toJson(), new Object[0])).isNotNull();
            ((AbstractBooleanAssert)AbstractBackendTest.assertThat(document.getBoolean((Object)"updated")).describedAs(document.toJson(), new Object[0])).isTrue();
        }
        long count = collection.countDocuments();
        AbstractBackendTest.assertThat(count).isEqualTo((long)numDocuments);
    }

    @Test
    public void testAllQuery() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("5234cc89687ea597eabee675")).append("code", (Object)"xyz").append("tags", Arrays.asList("school", "book", "bag", "headphone", "appliance")).append("qty", Arrays.asList(new Document().append("size", (Object)"S").append("num", (Object)10).append("color", (Object)"blue"), new Document().append("size", (Object)"M").append("num", (Object)45).append("color", (Object)"blue"), new Document().append("size", (Object)"L").append("num", (Object)100).append("color", (Object)"green"))));
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("5234cc8a687ea597eabee676")).append("code", (Object)"abc").append("tags", Arrays.asList("appliance", "school", "book")).append("qty", Arrays.asList(new Document().append("size", (Object)"6").append("num", (Object)100).append("color", (Object)"green"), new Document().append("size", (Object)"6").append("num", (Object)50).append("color", (Object)"blue"), new Document().append("size", (Object)"8").append("num", (Object)100).append("color", (Object)"brown"))));
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("5234ccb7687ea597eabee677")).append("code", (Object)"efg").append("tags", Arrays.asList("school", "book")).append("qty", Arrays.asList(new Document().append("size", (Object)"S").append("num", (Object)10).append("color", (Object)"blue"), new Document().append("size", (Object)"M").append("num", (Object)100).append("color", (Object)"blue"), new Document().append("size", (Object)"L").append("num", (Object)100).append("color", (Object)"green"))));
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("52350353b2eff1353b349de9")).append("code", (Object)"ijk").append("tags", Arrays.asList("electronics", "school")).append("qty", Collections.singletonList(new Document().append("size", (Object)"M").append("num", (Object)100).append("color", (Object)"green"))));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("tags: {$all: ['appliance', 'school', 'book']}"))).extracting(d -> d.get((Object)"_id")).containsExactly(new Object[]{new ObjectId("5234cc89687ea597eabee675"), new ObjectId("5234cc8a687ea597eabee676")});
    }

    @Test
    public void testMatchesElementQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [82, 85, 88]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, results: [75, 88, 89]"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("results: {$elemMatch: {$gte: 80, $lt: 85}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, results: [82, 85, 88]")});
    }

    @Test
    public void testMatchesElementInEmbeddedDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [{product: 'abc', score: 10}, {product: 'xyz', score: 5}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, results: [{product: 'abc', score:  9}, {product: 'xyz', score: 7}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, results: [{product: 'abc', score:  7}, {product: 'xyz', score: 8}]"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("results: {$elemMatch: {product: 'xyz', score: {$gte: 8}}}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 3, results: [{product: 'abc', score:  7}, {product: 'xyz', score: 8}]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("results: {$elemMatch: {product: 'xyz'}}}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, results: [{product: 'abc', score: 10}, {product: 'xyz', score: 5}]"), TestUtils.json("_id: 2, results: [{product: 'abc', score:  9}, {product: 'xyz', score: 7}]"), TestUtils.json("_id: 3, results: [{product: 'abc', score:  7}, {product: 'xyz', score: 8}]")});
    }

    @Test
    public void testElemMatchWithExpression() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, languages: [{key: 'C'}, {key: 'Java'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, languages: [{key: 'Python'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, languages: [{key: 'C++'}, {key: 'C'}]"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("languages: {$elemMatch: {$or: [{key: 'C'}, {key: 'C++'}]}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, languages: [{key: 'C'}, {key: 'Java'}]"), TestUtils.json("_id: 3, languages: [{key: 'C++'}, {key: 'C'}]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("languages: {$elemMatch: {$and: [{key: 'Java'}, {key: {$ne: 'Python'}}]}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, languages: [{key: 'C'}, {key: 'Java'}]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("languages: {$elemMatch: {$nor: [{key: 'C'}, {key: 'C++'}, {key: 'Java'}]}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, languages: [{key: 'Python'}]")});
    }

    @Test
    public void testElemMatchAndAllQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, list: [{aa: 'bb'}, {cc: 'dd'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, list: [{aa: 'bb'}, {cc: 'ee'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, list: [{cc: 'dd'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, list: []"));
        collection.insertOne((Object)TestUtils.json("_id: 6, list: [{aa: 'bb'}, {cc: 'dd'}, {ee: 'ff'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, list: {aa: 'bb'}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("list: {$all: [{$elemMatch: {aa: 'bb'}}, {$elemMatch: {cc: 'dd'}}], $size: 2}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, list: [{aa: 'bb'}, {cc: 'dd'}]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("list: {$size: 2, $all: [{$elemMatch: {aa: 'bb'}}, {$elemMatch: {cc: 'dd'}}]}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, list: [{aa: 'bb'}, {cc: 'dd'}]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("list: {$all: [{$elemMatch: {aa: 'bb'}}], $size: 2}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, list: [{aa: 'bb'}, {cc: 'dd'}]"), TestUtils.json("_id: 2, list: [{aa: 'bb'}, {cc: 'ee'}]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("list: {$all: [{$elemMatch: {$and: [{aa: {$ne: 'bb'}}, {cc: {$ne: 'dd'}}]}}]}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, list: [{aa: 'bb'}, {cc: 'ee'}]"), TestUtils.json("_id: 6, list: [{aa: 'bb'}, {cc: 'dd'}, {ee: 'ff'}]")});
    }

    @Test
    public void testQueryWithElemMatch() {
        collection.insertOne((Object)TestUtils.json("_id: 1, materials: [{materialId: 'A'}, {materialId: 'B'}, {materialId: 'C'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, materials: [{materialId: 'B'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, materials: []"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, materials: 'ABC'"));
        collection.insertOne((Object)TestUtils.json("_id: 6, materials: {materialId: 'A'}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("materials: {$elemMatch: {materialId: 'A'}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, materials: [{materialId: 'A'}, {materialId: 'B'}, {materialId: 'C'}]")});
    }

    @Test
    public void testProjectionWithElemMatch() {
        collection.insertOne((Object)TestUtils.json("_id: 1, zipcode: 63109, students: [{name: 'john'}, {name: 'jess'}, {name: 'jeff'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, zipcode: 63110, students: [{name: 'ajax'}, {name: 'achilles'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, zipcode: 63109, students: [{name: 'ajax'}, {name: 'achilles'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, zipcode: 63109, students: [{name: 'barney'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, zipcode: 63109, students: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, zipcode: 63109, students: {name: 'achilles'}"));
        Document query = TestUtils.json("zipcode: 63109");
        Document projection = TestUtils.json("students: {$elemMatch: {name: 'achilles'}}");
        AbstractBackendTest.assertThat(collection.find((Bson)query).projection((Bson)projection)).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 3, students: [{name: 'achilles'}]"), TestUtils.json("_id: 4"), TestUtils.json("_id: 5"), TestUtils.json("_id: 6")});
    }

    @Test
    public void testProjectionWithElemMatch_BigSubdocument() {
        collection.insertOne((Object)TestUtils.json("_id: 1, zipcode: 63109, students: [              {name: 'john', school: 102, age: 10},              {name: 'jess', school: 102, age: 11},              {name: 'jeff', school: 108, age: 15}           ]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, zipcode: 63110, students: [              {name: 'ajax', school: 100, age: 7},              {name: 'achilles', school: 100, age: 8 }           ]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, zipcode: 63109, students: [              {name: 'ajax', school: 100, age: 7},              {name: 'achilles', school: 100, age: 8}           ]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, zipcode: 63109, students: [              {name: 'barney', school: 102, age: 7}           ]"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("zipcode: 63109")).projection((Bson)TestUtils.json("students: {$elemMatch: {school: 102}}}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, students: [{name: 'john', school: 102, age: 10}]"), TestUtils.json("_id: 3"), TestUtils.json("_id: 4, students: [{name: 'barney', school: 102, age: 7}]")});
    }

    @Test
    public void testQueryWithProjection_elemMatchAndPositionalOperator() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, states: [{state: 'A', key: 'abc'}, {state: 'B', key: 'efg'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, states: [{state: 'B', key: 'abc'}, {state: 'B', key: 'efg'}]"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("states: {$elemMatch: {state: {$eq: 'A'}, key: {$eq: 'abc'}}}")).projection((Bson)TestUtils.json("'states.$': 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, states: [{state: 'A', key: 'abc'}]")});
    }

    @Test
    public void testProjectionWithExclusion() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, states: [{state: 'A', key: 'abc'}, {state: 'B', key: 'efg'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, states: [{state: 'B', key: 'abc'}, {state: 'B', key: 'efg'}]"));
        AbstractBackendTest.assertThat(collection.find().projection((Bson)TestUtils.json("{'states.key': 0}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, states: [{state: 'A'}, {state: 'B'}]"), TestUtils.json("_id: 2, states: [{state: 'B'}, {state: 'B'}]")});
        AbstractBackendTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, states: [{state: 'A', key: 'abc'}, {state: 'B', key: 'efg'}]"), TestUtils.json("_id: 2, states: [{state: 'B', key: 'abc'}, {state: 'B', key: 'efg'}]")});
    }

    @Test
    public void testProjectionWithSlice() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: ['a', 'b', 'c', 'd', 'e']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: 'xyz'"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: 1}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: ['a']")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: ['xyz', 2]}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: ['a', 'b']")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [-3, 2]}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: ['c', 'd']")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("values: {$slice: 1}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, values: 'xyz'")});
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: ['$_id', '$_id']}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '$slice limit must be positive'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [1, 0]}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '$slice limit must be positive'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [1, 'xyz']}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '$slice limit must be positive'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [1, 2, 3]}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '$slice array wrong size'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: 'abc'}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '$slice only supports numbers and [skip, limit] arrays'");
    }

    @Test
    public void testMatchesNullOrMissing() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 123"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("x: null"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, x: null"), TestUtils.json("_id: 2")});
    }

    @Test
    public void testIllegalElementMatchQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [ 82, 85, 88 ]"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("results: {$elemMatch: [ 85 ]}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '$elemMatch needs an Object'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("results: {$elemMatch: 1}")).first()).withMessageContaining("Command failed with error 2 (BadValue): '$elemMatch needs an Object'");
    }

    @Test
    public void testQueryWithOperatorAndWithoutOperator() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: {y: 23}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 9"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 100"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("x: {$lt: 10, y: 23}")).first()).withMessageContaining("Command failed with error 2 (BadValue): 'unknown operator: y'");
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("x: {y: 23, $lt: 10}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("x: {y: {$lt: 100, z: 23}}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: 123, x: {y: {$lt: 100, z: 23}}"))).isEmpty();
    }

    @Test
    public void testQueryWithComment() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 4"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("x: {$mod: [2, 0 ]}, $comment: 'Find even values.'"))).extracting(d -> d.get((Object)"_id")).containsExactly(new Object[]{1, 3});
    }

    @Test
    public void testValidate() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)new Document("validate", (Object)this.getCollectionName()))).withMessageContaining("Command failed with error 26 (NamespaceNotFound): 'ns not found'");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.deleteOne((Bson)TestUtils.json("_id: 2"));
        Document result = db.runCommand((Bson)new Document("validate", (Object)this.getCollectionName()));
        AbstractBackendTest.assertThat(result.get((Object)"nrecords")).isEqualTo((Object)2);
    }

    @Test
    public void testGetLastError() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document actual = db.runCommand((Bson)TestUtils.json("getlasterror: 1"));
        AbstractBackendTest.assertThat(actual.get((Object)"n")).isEqualTo((Object)0);
        AbstractBackendTest.assertThat(actual).containsKey((Object)"err");
        AbstractBackendTest.assertThat(actual.get((Object)"err")).isNull();
        AbstractBackendTest.assertThat(actual.get((Object)"ok")).isEqualTo((Object)1.0);
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.insertOne((Object)TestUtils.json("_id: 1.0"))).withMessageContaining("E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 1.0 }");
        Document lastError = db.runCommand((Bson)TestUtils.json("getlasterror: 1"));
        AbstractBackendTest.assertThat(lastError.get((Object)"code")).isEqualTo((Object)11000);
        AbstractBackendTest.assertThat(lastError.getString((Object)"err")).contains(new CharSequence[]{"duplicate key"});
        AbstractBackendTest.assertThat(lastError.getString((Object)"codeName")).isEqualTo("DuplicateKey");
        AbstractBackendTest.assertThat(lastError.get((Object)"ok")).isEqualTo((Object)1.0);
    }

    @Test
    public void testResetError() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.insertOne((Object)TestUtils.json("_id: 1.0"))).withMessageContaining("duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 1.0 }");
        AbstractBackendTest.assertThat(db.runCommand((Bson)TestUtils.json("reseterror: 1"))).isEqualTo((Object)TestUtils.json("ok: 1.0"));
        AbstractBackendTest.assertThat(db.runCommand((Bson)TestUtils.json("getlasterror: 1"))).containsAllEntriesOf((Map)TestUtils.json("err: null, n: 0, ok: 1.0"));
    }

    @Test
    public void testIllegalTopLevelOperator() throws Exception {
        Document query = TestUtils.json("$illegalOperator: 1");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)query).first()).withMessageContaining("Command failed with error 2 (BadValue): 'unknown top level operator: $illegalOperator'");
    }

    @Test
    public void testExprQuery() throws Exception {
        Document query = TestUtils.json("$expr: {$gt: ['$spent', '$budget']}");
        AbstractBackendTest.assertThat(collection.find((Bson)query)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, category: 'food', budget: 400, spent: 450"));
        collection.insertOne((Object)TestUtils.json("_id: 2, category: 'drinks', budget: 100, spent: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 3, category: 'clothes', budget: 100, spent: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 4, category: 'misc', budget: 500, spent: 300"));
        collection.insertOne((Object)TestUtils.json("_id: 5, category: 'travel', budget: 200, spent: 650"));
        AbstractBackendTest.assertThat(collection.find((Bson)query)).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, category: 'food', budget: 400, spent: 450"), TestUtils.json("_id: 2, category: 'drinks', budget: 100, spent: 150"), TestUtils.json("_id: 5, category: 'travel', budget: 200, spent: 650")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$gt: 3}"))).hasSize(2);
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$gt: {$expr: {$literal: 3}}}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("$expr: {$eq: ['$budget', {$multiply: ['$spent', 2]}]}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, category: 'clothes', budget: 100, spent: 50")});
    }

    @Test
    public void testExprQuery_IllegalFieldPath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("$expr: {$eq: ['$a.', 10]}")).first()).withMessageContaining("Command failed with error 40353 (Location40353): 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("$expr: {$eq: ['$.a', 10]}")).first()).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find((Bson)TestUtils.json("$expr: {$eq: ['$a..1', 10]}")).first()).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
    }

    @Test
    public void testQueryEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, b: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, b: {c: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: {c: 123}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, b: {c: ['a', null, 'b']}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, b: {c: [1, 2, 3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 6"));
        collection.insertOne((Object)TestUtils.json("_id: 7, b: {c: 1, d: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c': 1"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 5, b: {c: [1, 2, 3]}"), TestUtils.json("_id: 7, b: {c: 1, d: 2}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("b: {c: 1}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c': null"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, b: null"), TestUtils.json("_id: 2, b: {c: null}"), TestUtils.json("_id: 4, b: {c: ['a', null, 'b']}"), TestUtils.json("_id: 6")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("b: {c: null}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, b: {c: null}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c': {d: 1}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c': {d: {$gte: 1}}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c': {d: {$gte: 1}, e: {$lte: 2}}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c.d': {$gte: 1}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c': {d: 1, e: 2}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'b.c.e': 2"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}")});
    }

    @Test
    public void testQueryWithEquivalentEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: {b: 1, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: 1, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1.0, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1, d: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: {b: 1}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {b: 1.0, c: -0.0}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1, c: 0}"), TestUtils.json("_id: 2, a: {b: 1, c: 0.0}"), TestUtils.json("_id: 3, a: {b: 1.0, c: 0.0}"), TestUtils.json("_id: 4, a: {b: 1.0, c: 0}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {b: {c: 1}}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 5, a: {b: {c: 1.0}}"), TestUtils.json("_id: 6, a: {b: {c: 1}}")});
    }

    @Test
    public void testOrderByMissingAndNull() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: null"));
        collection.insertOne((Object)TestUtils.json("_id:  2"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: null"));
        collection.insertOne((Object)TestUtils.json("_id:  5"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: null"), TestUtils.json("_id: 2"), TestUtils.json("_id: 4, a: null"), TestUtils.json("_id: 5"), TestUtils.json("_id: 3, a: {b: 1}")});
    }

    @Test
    public void testOrderByEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: {b: 1, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: 1, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1, c: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: 1.0, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: {b: {c: 0.0}}"));
        collection.insertOne((Object)TestUtils.json("_id: 12, a: {c: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 13, a: {b: null, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 14, a: {b: 'abc'}"));
        collection.insertOne((Object)TestUtils.json("_id: 15, a: null, b: 123"));
        collection.insertOne((Object)TestUtils.json("_id: 16, b: 123"));
        collection.insertOne((Object)TestUtils.json("_id: 17, a: null, b: 123"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 15, a: null, b: 123"), TestUtils.json("_id: 16, b: 123"), TestUtils.json("_id: 17, a: null, b: 123"), TestUtils.json("_id: 13, a: {b: null, c: 0}"), TestUtils.json("_id: 10, a: {b: 1}"), TestUtils.json("_id:  3, a: {b: 1, c: null}"), TestUtils.json("_id:  1, a: {b: 1, c: 0}"), TestUtils.json("_id:  2, a: {b: 1, c: 0.0}"), TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"), TestUtils.json("_id:  5, a: {b: 1.0, c: 0.0}"), TestUtils.json("_id:  6, a: {b: 1.0, c: 0}"), TestUtils.json("_id:  9, a: {c: 0}"), TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"), TestUtils.json("_id: 12, a: {c: 2}"), TestUtils.json("_id: 14, a: {b: 'abc'}"), TestUtils.json("_id: 11, a: {b: {c: 0.0}}"), TestUtils.json("_id:  7, a: {b: {c: 1.0}}")});
    }

    @Test
    public void testFindByListValue() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [2, 1]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: [2, 1.0]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [3, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: [2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: [3]"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: [3, 2]"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: [2, 1]"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: [2, 1]"), TestUtils.json("_id: 2, a: [2, 1.0]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: [1, 2]"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: [1, 2]")});
    }

    @Test
    public void testFindAndOrderByWithListValues() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: []"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: null"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: [2, 1]"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: [2, 1.0]"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: [1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: [3, 2]"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: [2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: [3]"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: [3, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: [null, 1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 12, a: [1, 'abc', 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 13"));
        collection.insertOne((Object)TestUtils.json("_id: 14, a: 'xyz'"));
        collection.insertOne((Object)TestUtils.json("_id: 15, a: {b: 5}"));
        collection.insertOne((Object)TestUtils.json("_id: 16, a: 1"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: -1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id:  1, a: []"), TestUtils.json("_id: 13"), TestUtils.json("_id: 11, a: [null, 1, 2]"), TestUtils.json("_id:  2, a: null"), TestUtils.json("_id: 16, a: 1"), TestUtils.json("_id: 12, a: [1, 'abc', 2]"), TestUtils.json("_id:  6, a: [1, 2, 3]"), TestUtils.json("_id:  5, a: [1, 2]"), TestUtils.json("_id:  4, a: [2, 1.0]"), TestUtils.json("_id:  3, a: [2, 1]"), TestUtils.json("_id: 10, a: [3, 2]"), TestUtils.json("_id:  8, a: [2, 3]"), TestUtils.json("_id:  7, a: [3, 2]"), TestUtils.json("_id:  9, a: [3]"), TestUtils.json("_id: 14, a: 'xyz'"), TestUtils.json("_id: 15, a: {b: 5}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id:  1, a: []"), TestUtils.json("_id:  2, a: null"), TestUtils.json("_id: 11, a: [null, 1, 2]"), TestUtils.json("_id: 13"), TestUtils.json("_id:  3, a: [2, 1]"), TestUtils.json("_id:  4, a: [2, 1.0]"), TestUtils.json("_id:  5, a: [1, 2]"), TestUtils.json("_id:  6, a: [1, 2, 3]"), TestUtils.json("_id: 12, a: [1, 'abc', 2]"), TestUtils.json("_id: 16, a: 1"), TestUtils.json("_id:  7, a: [3, 2]"), TestUtils.json("_id:  8, a: [2, 3]"), TestUtils.json("_id: 10, a: [3, 2]"), TestUtils.json("_id:  9, a: [3]"), TestUtils.json("_id: 14, a: 'xyz'"), TestUtils.json("_id: 15, a: {b: 5}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: -1, _id: -1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 15, a: {b: 5}"), TestUtils.json("_id: 14, a: 'xyz'"), TestUtils.json("_id: 12, a: [1, 'abc', 2]"), TestUtils.json("_id: 10, a: [3, 2]"), TestUtils.json("_id:  9, a: [3]"), TestUtils.json("_id:  8, a: [2, 3]"), TestUtils.json("_id:  7, a: [3, 2]"), TestUtils.json("_id:  6, a: [1, 2, 3]"), TestUtils.json("_id: 11, a: [null, 1, 2]"), TestUtils.json("_id:  5, a: [1, 2]"), TestUtils.json("_id:  4, a: [2, 1.0]"), TestUtils.json("_id:  3, a: [2, 1]"), TestUtils.json("_id: 16, a: 1"), TestUtils.json("_id: 13"), TestUtils.json("_id:  2, a: null"), TestUtils.json("_id:  1, a: []")});
    }

    @Test
    public void testDistinctEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: {b: 1, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1, c: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: 1.0, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: 1.0, c: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 0, b: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: {b: {c: 0.0}}"));
        collection.insertOne((Object)TestUtils.json("_id: 12"));
        collection.insertOne((Object)TestUtils.json("_id: 13, a: {c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 14, a: {c: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 15, a: null"));
        AbstractBackendTest.assertThat(collection.distinct("a", Document.class)).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("b: 1, c: 0"), TestUtils.json("b: null"), TestUtils.json("b: 1, c: null"), TestUtils.json("b: {c: 1.0}"), TestUtils.json("b: 1.0, c: 0"), TestUtils.json("b: null, c: 0"), TestUtils.json("b: 1"), TestUtils.json("b: {c: 0.0}"), TestUtils.json("c: 0"), TestUtils.json("c: null"), null});
    }

    @Test
    public void testEmptyArrayQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> collection.find(Filters.and((Bson[])new Bson[0])).first()).withMessageContaining("must be a nonempty array");
    }

    @Test
    public void testFindAllReferences() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)1).append("ref", (Object)new DBRef("coll1", (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)2).append("ref", (Object)new DBRef("coll1", (Object)2)));
        collection.insertOne((Object)new Document("_id", (Object)3).append("ref", (Object)new DBRef("coll2", (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)4).append("ref", (Object)new DBRef("coll2", (Object)2)));
        collection.insertOne((Object)TestUtils.json("_id: 5, ref: [1, 2, 3, 4]"));
        collection.insertOne((Object)TestUtils.json("_id: 6"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("ref: {$ref: 'coll1', $id: 1}")).projection((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1")});
    }

    @Test
    public void testInsertAndQueryNegativeZero() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: -0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: -0.0"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("value: -0.0"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, value: -0.0"), TestUtils.json("_id: 2, value: 0.0"), TestUtils.json("_id: 3, value: -0.0")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("value: {$lt: 0.0}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("value: 0")).sort((Bson)TestUtils.json("value: 1, _id: 1"))).extracting(doc -> doc.getDouble((Object)"value")).containsExactly((Object[])new Double[]{-0.0, 0.0, -0.0});
    }

    @Test
    public void testUniqueIndexWithNegativeZero() throws Exception {
        collection.createIndex((Bson)TestUtils.json("value: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, value: -0.0"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 2, value: 0.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { value: 0.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 3, value: -0.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { value: -0.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 4, value: 0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { value: 0 }");
    }

    @Test
    public void testDecimal128() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '1'}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '2'}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '3.0'}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '200000000000000000000000000000000.5'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '1'}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: 1 }");
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$eq: {'$numberDecimal': '3'}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: {'$numberDecimal': '3.0'}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$gt: {'$numberDecimal': '100000'}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: {'$numberDecimal': '200000000000000000000000000000000.5'}")});
    }

    @Test
    public void testDecimal128_Inc() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: {'$numberDecimal': '1'}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: {'$numberDecimal': '2'}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: {'$numberDecimal': '3.0'}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: {'$numberDecimal': '200000000000000000000000000000000.5'}"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$inc: {value: 1}"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: {'$numberDecimal': '2'}"), TestUtils.json("_id: 2, value: {'$numberDecimal': '3'}"), TestUtils.json("_id: 3, value: {'$numberDecimal': '4.0'}"), TestUtils.json("_id: 4, value: {'$numberDecimal': '200000000000000000000000000000001.5'}")});
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$inc: {value: {'$numberDecimal': '2.5'}}"));
        AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: {'$numberDecimal': '4.5'}"), TestUtils.json("_id: 2, value: {'$numberDecimal': '5.5'}"), TestUtils.json("_id: 3, value: {'$numberDecimal': '6.5'}"), TestUtils.json("_id: 4, value: {'$numberDecimal': '200000000000000000000000000000004.0'}")});
    }

    @Test
    public void testArrayNe() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 'a', values: [-1]"));
        collection.insertOne((Object)TestUtils.json("_id: 'b', values: [0]"));
        collection.insertOne((Object)TestUtils.json("_id: 'c', values: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 'd', values: {'$numberDecimal': '1.0'}"));
        collection.insertOne((Object)TestUtils.json("_id: 'e', values: {'$numberDecimal': '0.0'}"));
        collection.insertOne((Object)TestUtils.json("_id: 'f', values: [-0.0]"));
        collection.insertOne((Object)TestUtils.json("_id: 'g', values: [0, 1]"));
        collection.insertOne((Object)TestUtils.json("_id: 'h', values: 0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 'i', values: []"));
        collection.insertOne((Object)TestUtils.json("_id: 'j', values: null"));
        collection.insertOne((Object)TestUtils.json("_id: 'k'"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("values: {$ne: 0}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'a', values: [-1]"), TestUtils.json("_id: 'c', values: 1.0"), TestUtils.json("_id: 'd', values: {'$numberDecimal': '1.0'}"), TestUtils.json("_id: 'i', values: []"), TestUtils.json("_id: 'j', values: null"), TestUtils.json("_id: 'k'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("values: {$ne: []}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'a', values: [-1]"), TestUtils.json("_id: 'b', values: [0]"), TestUtils.json("_id: 'c', values: 1.0"), TestUtils.json("_id: 'd', values: {'$numberDecimal': '1.0'}"), TestUtils.json("_id: 'e', values: {'$numberDecimal': '0.0'}"), TestUtils.json("_id: 'f', values: [-0.0]"), TestUtils.json("_id: 'g', values: [0, 1]"), TestUtils.json("_id: 'h', values: 0.0"), TestUtils.json("_id: 'j', values: null"), TestUtils.json("_id: 'k'")});
    }

    @Test
    public void testExistsQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.b': {$exists: false}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: null"), TestUtils.json("_id: 4")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.b': {$exists: true}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 3, a: {b: null}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {b: {$exists: true}}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {$exists: true}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: null"), TestUtils.json("_id: 3, a: {b: null}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("b: {$exists: true}"))).isEmpty();
    }

    @Test
    public void testExistsQueryWithArray() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: ['x']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: []"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 7"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.1': {$exists: true}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.0': {$exists: false}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.0.1': {$exists: true}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.0.1': {$exists: false}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7")});
    }

    @Test
    public void testExistsQueryWithTrailingDot() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: ['x']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: []"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {b: {c: 'd'}}"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.': {$exists: true}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.1.': {$exists: true}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'.a': {$exists: true}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.b.': {$exists: true}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a..': {$exists: true}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.....111': {$exists: true}"))).isEmpty();
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.': {$exists: false}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7"), TestUtils.json("_id: 8, a: {b: {c: 'd'}}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a.1.': {$exists: false}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7"), TestUtils.json("_id: 8, a: {b: {c: 'd'}}")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("'a..': {$exists: false}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7"), TestUtils.json("_id: 8, a: {b: {c: 'd'}}")});
    }

    @Test
    public void testRegExQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 'one', name: 'karl'"));
        collection.insertOne((Object)TestUtils.json("_id: 'two', name: 'Karl'"));
        collection.insertOne((Object)TestUtils.json("_id: 'Three', name: 'KARL'"));
        collection.insertOne((Object)TestUtils.json("_id: null"));
        collection.insertOne((Object)TestUtils.json("_id: 123, name: ['karl', 'john']"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$regex: '^T.+$', $options: 'i'}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 'two', name: 'Karl'"), TestUtils.json("_id: 'Three', name: 'KARL'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$regex: 't.+'}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'two', name: 'Karl'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("_id: {$regex: '^(one|1.+)$'}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'one', name: 'karl'")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("name: {$regex: 'arl', $options: 'i'}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 'one', name: 'karl'"), TestUtils.json("_id: 'two', name: 'Karl'"), TestUtils.json("_id: 'Three', name: 'KARL'"), TestUtils.json("_id: 123, name: ['karl', 'john']")});
    }

    @Test
    public void testInsertAndFindJavaScriptContent() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)1).append("data", (Object)new BsonJavaScript("int i = 0")));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).extracting(document -> document.get("data")).isEqualTo((Object)new Code("int i = 0"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)new Document("data", (Object)new BsonJavaScript("int i = 0"))).first()).extracting(document -> document.get("_id")).isEqualTo((Object)1);
    }

    private void insertAndFindLargeDocument(int numKeyValues, int id) {
        Document document = new Document("_id", (Object)id);
        for (int i = 0; i < numKeyValues; ++i) {
            document.put("key-" + i, (Object)("value-" + i));
        }
        collection.insertOne((Object)document);
        Document persistentDocument = (Document)collection.find((Bson)new Document("_id", (Object)id)).first();
        AbstractBackendTest.assertThat(persistentDocument).hasSize(numKeyValues + 1);
    }

    private void insertUpdateInBulk(boolean ordered) {
        ArrayList<Object> ops = new ArrayList<Object>();
        ops.add(new InsertOneModel((Object)TestUtils.json("_id: 1, field: 'x'")));
        ops.add(new InsertOneModel((Object)TestUtils.json("_id: 2, field: 'x'")));
        ops.add(new InsertOneModel((Object)TestUtils.json("_id: 3, field: 'x'")));
        ops.add(new UpdateManyModel((Bson)TestUtils.json("field: 'x'"), Updates.set((String)"field", (Object)"y")));
        BulkWriteResult result = collection.bulkWrite(ops, new BulkWriteOptions().ordered(ordered));
        AbstractBackendTest.assertThat(result.getInsertedCount()).isEqualTo(3);
        AbstractBackendTest.assertThat(result.getDeletedCount()).isEqualTo(0);
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(3);
        AbstractBackendTest.assertThat(result.getMatchedCount()).isEqualTo(3);
        long totalDocuments = collection.countDocuments();
        AbstractBackendTest.assertThat(totalDocuments).isEqualTo(3L);
        long documentsWithY = collection.countDocuments((Bson)TestUtils.json("field: 'y'"));
        AbstractBackendTest.assertThat(documentsWithY).isEqualTo(3L);
    }

    private void insertUpdateInBulkNoMatch(boolean ordered) {
        collection.insertOne((Object)TestUtils.json("foo: 'bar'"));
        ArrayList<UpdateOneModel> ops = new ArrayList<UpdateOneModel>();
        ops.add(new UpdateOneModel(Filters.ne((String)"foo", (Object)OTHER_TEST_DATABASE_NAME), Updates.set((String)"field", (Object)"y")));
        BulkWriteResult result = collection.bulkWrite(ops, new BulkWriteOptions().ordered(ordered));
        AbstractBackendTest.assertThat(result.getInsertedCount()).isEqualTo(0);
        AbstractBackendTest.assertThat(result.getDeletedCount()).isEqualTo(0);
        AbstractBackendTest.assertThat(result.getModifiedCount()).isEqualTo(0);
        AbstractBackendTest.assertThat(result.getMatchedCount()).isEqualTo(0);
    }

    private void removeInBulk(boolean ordered) {
        DeleteManyModel deleteOp = new DeleteManyModel((Bson)TestUtils.json("field: 'y'"));
        BulkWriteResult result = collection.bulkWrite(Collections.singletonList(deleteOp), new BulkWriteOptions().ordered(ordered));
        AbstractBackendTest.assertThat(result.getDeletedCount()).isEqualTo(3);
        AbstractBackendTest.assertThat(collection.countDocuments()).isZero();
    }

    protected static void assertMongoWriteException(Callable callable, int expectedErrorCode, String expectedMessage) {
        AbstractBackendTest.assertMongoWriteException(callable, expectedErrorCode, "Location" + expectedErrorCode, expectedMessage);
    }

    protected static void assertMongoWriteException(Callable callable, int expectedErrorCode, String expectedCodeName, String expectedMessage) {
        try {
            callable.call();
            Assertions.fail((String)"MongoWriteException expected");
        }
        catch (MongoWriteException e) {
            AbstractBackendTest.assertThat(e).hasMessageContaining(expectedMessage);
            AbstractBackendTest.assertThat(e.getError().getCode()).isEqualTo(expectedErrorCode);
            Document actual = db.runCommand((Bson)TestUtils.json("getlasterror: 1"));
            AbstractBackendTest.assertThat(actual.getString((Object)"codeName")).isEqualTo(expectedCodeName);
        }
    }

    @Test
    public void testInsertWithoutId() throws Exception {
        DocumentCodec documentCodec = (DocumentCodec)Mockito.spy((Object)new DocumentCodec());
        ((DocumentCodec)Mockito.doAnswer((Answer)AdditionalAnswers.returnsFirstArg()).when((Object)documentCodec)).generateIdIfAbsentFromDocument((Document)Mockito.any());
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).codecRegistry(CodecRegistries.fromCodecs((Codec[])new Codec[]{documentCodec})).build();
        try (MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);){
            MongoDatabase database = mongoClient.getDatabase(db.getName());
            MongoCollection collection = database.getCollection(this.getCollectionName());
            collection.insertOne((Object)TestUtils.json("x: 1"));
            AbstractBackendTest.assertThat(((Document)collection.find((Bson)TestUtils.json("x: 1")).first()).get((Object)"_id")).isInstanceOf(ObjectId.class);
        }
        ((DocumentCodec)Mockito.verify((Object)documentCodec)).generateIdIfAbsentFromDocument((Document)Mockito.any());
    }

    @Test
    public void testMultikeyIndex_simpleArrayValues() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [4, 5, 4]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: [[1, 3], [4, 5]]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: [[2, 1], [4, 3]]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [1]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [6, 1]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [2.0, 4.0]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: 2.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [[1, 4], [3, 4]]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: [ 3, 4 ] }");
        collection.deleteOne((Bson)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: [2, 3]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: [3, 4]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: 3 }");
        collection.replaceOne((Bson)TestUtils.json("_id: 4"), (Object)TestUtils.json("_id: 4, a: ['x', 'y']"));
        collection.insertOne((Object)TestUtils.json("_id: 9, a: [4, 6]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 9"), (Bson)TestUtils.json("$push: {a: 2}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { a: 2 }");
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 8"), (Bson)TestUtils.json("$pull: {a: 2}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 8, a: [3]"));
        result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 9"), (Bson)TestUtils.json("$push: {a: 2}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 9, a: [4, 6, 2]"));
        result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 9"), (Bson)TestUtils.json("$push: {a: 2}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 9, a: [4, 6, 2, 2]"));
    }

    @Test
    public void testCompoundMultikeyIndex_simpleArrayValues() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [2, 3], b: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [4, 5], b: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [1, 2, 3, 4, 5], b: 2"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [1]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: 1, b: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [6, 2], b: 1")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: 2, b: 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: ['abc'], b: [1, 2, 3]")), 171, "CannotIndexParallelArrays", "cannot index parallel arrays [b] [a]");
        collection.deleteOne((Bson)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: [2, 3], b: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: [3, 4], b: 1")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { a: 3, b: 1 }");
        collection.replaceOne((Bson)TestUtils.json("_id: 4"), (Object)TestUtils.json("_id: 4, a: ['x', 'y'], b: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: [4, 6], b: 1"));
    }

    @Test
    public void testCompoundMultikeyIndex_threeKeys() throws Exception {
        collection.createIndex((Bson)TestUtils.json("b: 1, a: 1, c: 1"), new IndexOptions().unique(true));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("b: [1, 2, 3], a: ['abc'], c: ['x', 'y']")), 171, "CannotIndexParallelArrays", "cannot index parallel arrays [a] [b]");
    }

    @Test
    public void testCompoundMultikeyIndex_documents() throws Exception {
        collection.createIndex((Bson)TestUtils.json("item: 1, 'stock.size': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'abc', stock: [{size: 'S', color: 'red'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'abc', stock: [{size: 'L', color: 'black'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', stock: [{size: 'M'}, {size: 'XL'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, item: 'xyz', stock: [{size: 'S'}, {size: 'M'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, item: 'xyz', stock: [1, 2, 3]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { item: \"abc\", stock.size: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{color: 'black'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { item: \"abc\", stock.size: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{size: 'S'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { item: \"abc\", stock.size: \"S\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{size: 'XL'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { item: \"abc\", stock.size: \"XL\" }");
    }

    @Test
    public void testCompoundMultikeyIndex_multiple_document_keys() throws Exception {
        collection.createIndex((Bson)TestUtils.json("item: 1, 'stock.size': 1, 'stock.color': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'abc', stock: [{color: 'red'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', stock: [{size: 'L', color: 'red'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, item: 'abc', stock: [{size: 'L'}, {size: 'XL'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, item: 'abc', stock: [{size: 'S', color: 'red'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 8, item: 'xyz', stock: [{size: 'S', color: 'red'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 9, item: 'xyz', stock: [1, 2, 3]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1_stock.color_1 dup key: { item: \"abc\", stock.size: null, stock.color: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{color: 'red'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1_stock.color_1 dup key: { item: \"abc\", stock.size: null, stock.color: \"red\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{size: 'XL'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1_stock.color_1 dup key: { item: \"abc\", stock.size: \"XL\", stock.color: null }");
    }

    @Test
    public void testCompoundMultikeyIndex_deepDocuments() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'a.b.c': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: {c: 2}}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [{b: {c: 3}}, {b: {c: 4}}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [{b: [{c: 5}, {c: 6}]}, {b: [{c: 7}, {c: 8}]}]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: 1}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [{b: 1}, {b: 2}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: [1, 2]}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 4}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: 4 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 8}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { a.b.c: 8 }");
    }

    @Test
    public void testUpdateArrayWithPositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [95, 102, 90, 150]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[]': -10}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [85, 92, 80, 140]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[]': 'abc'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: ['abc', 'abc', 'abc', 'abc']"));
    }

    @Test
    public void testUpdateArrayWithPositionalAll_NullValue() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [1, 2, null, 3]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[]': 'abc'}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: ['abc', 'abc', 'abc', 'abc']"));
    }

    @Test
    public void testUpdateArrayWithPositionalAllAndArrayFilter() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [{x: [1, 2, 3]}, {x: [3, 4, 5]}, {x: [1, 2, 3]}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].x.$[element]': 1}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 3}"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{x: [1, 2, 4]}, {x: [4, 5, 6]}, {x: [1, 2, 4]}]"));
    }

    @Test
    public void testUpdateArrayOfDocumentsWithPositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [{value: 20}, {value: 30}, {value: 40}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].value': 10}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 30}, {value: 40}, {value: 50}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[].value': 10}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 10}, {value: 10}, {value: 10}]"));
    }

    @Test
    public void testIllegalUpdateWithPositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: [1, 2, 3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: 5}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.$[]': 'abc'}"))).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element a: { b: [ 1, 2, 3 ] }");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$set: {'a.b.$[]': 'abc'}"))).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element b: 5");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[].c': 'abc'}"))).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {0: 1}");
    }

    @Test
    public void testUpsertWithPositionalAll() throws Exception {
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1, a: [5, 8]"), (Bson)TestUtils.json("$set: {'a.$[]': 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: [1, 1]"));
    }

    @Test
    public void testFindOneAndUpdateWithReturnDocumentBeforeWhenDocumentDidNotExist() throws Exception {
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1, a: [5, 8]"), (Bson)TestUtils.json("$set: {'a.$[]': 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.BEFORE));
        AbstractBackendTest.assertThat(result).isNull();
    }

    @Test
    public void testFindOneAndReplaceWithReturnDocumentBeforeWhenDocumentDidNotExist() throws Exception {
        Document result = (Document)collection.findOneAndReplace((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: [5, 8]"), new FindOneAndReplaceOptions().upsert(true).returnDocument(ReturnDocument.BEFORE));
        AbstractBackendTest.assertThat(result).isNull();
    }

    @Test
    public void testFindOneAndUpdateWithReturnDocumentBeforeWhenDocumentExists() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [5, 8]"));
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1, a: [5, 8]"), (Bson)TestUtils.json("$set: {'a.$[]': 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.BEFORE));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: [5, 8]"));
    }

    @Test
    public void testFindOneAndReplaceWithReturnDocumentBeforeWhenDocumentExists() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [5, 8]"));
        Document result = (Document)collection.findOneAndReplace((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: [3, 3]"), new FindOneAndReplaceOptions().upsert(true).returnDocument(ReturnDocument.BEFORE));
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("_id: 1, a: [5, 8]"));
    }

    @Test
    public void testUpdateWithMultipleArrayFiltersInOnePath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [{value: 10, x: [1, 2]}, {value: 20, x: [3, 4]}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element].x.$[]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'element.value': {$gt: 10}"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 10, x: [1, 2]}, {value: 20, x: ['abc', 'abc']}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.0.x.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'element': {$gt: 1}"))));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 10, x: [1, 'abc']}, {value: 20, x: ['abc', 'abc']}]"));
    }

    @Test
    public void testUpdateArrayWithMultiplePositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, grades: [{c: [1, 2]}, {c: [3, 4]}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, grades: [{c: [1, 2]}, {c: [3, 4]}, {d: [5, 6]}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].$[]': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [[2, 3], [4, 5]]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$inc: {'grades.$[].c.$[]': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 2")).first()).isEqualTo((Object)TestUtils.json("_id: 2, grades: [{c: [2, 3]}, {c: [4, 5]}]"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$inc: {'grades.$[].c.$[]': 1}"))).withMessageContaining("Command failed with error 2 (BadValue): 'The path 'grades.2.c' must exist in the document in order to apply array updates.");
    }

    @Test
    public void testUpdateArrayWithMultiplePositionalAll_Simple() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [[1, 2], [3, 4]]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[].$[]': 1}"));
        AbstractBackendTest.assertThat((Document)collection.find((Bson)TestUtils.json("_id: 1")).first()).isEqualTo((Object)TestUtils.json("_id: 1, grades: [[1, 1], [1, 1]]"));
    }

    @Test
    public void testUpdateArrayWithIllegalMultiplePositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [[[1, 2], [3, 4]], [[4, 5], [2, 3]]]"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].$[]': 1}"))).withMessageContaining("Command failed with error 14 (TypeMismatch): 'Cannot apply $inc to a value of non-numeric type. {_id: 1} has the field '0' of non-numeric type array");
    }

    @Test
    public void testGetKeyValues_multiKey_document_nested_objects() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'stock.size': 1, 'stock.quantity': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("stock: [{size: 'S', quantity: 10}]"));
        collection.insertOne((Object)TestUtils.json("stock: [{size: 'M', quantity: 10}, {size: 'L', quantity: 10}]"));
        collection.insertOne((Object)TestUtils.json("stock: [{size: 'S', quantity: 20}]"));
        collection.insertOne((Object)TestUtils.json("stock: [{quantity: 20}]"));
        collection.insertOne((Object)TestUtils.json("stock: [{size: 'M'}]"));
        collection.insertOne((Object)TestUtils.json("stock: {size: ['XL', 'XXL']}"));
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.insertOne((Object)TestUtils.json("stock: {size: ['S', 'M'], quantity: [30, 40]}"))).withMessageContaining("cannot index parallel arrays [quantity] [size]");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("stock: {size: 'S', quantity: 10}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: stock.size_1_stock.quantity_1 dup key: { stock.size: \"S\", stock.quantity: 10 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("stock: [{size: 'XL', quantity: 7}, {size: 'M', quantity: 10}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: stock.size_1_stock.quantity_1 dup key: { stock.size: \"M\", stock.quantity: 10 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("stock: [{size: 'M'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: stock.size_1_stock.quantity_1 dup key: { stock.size: \"M\", stock.quantity: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("stock: {size: 'XL'}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: stock.size_1_stock.quantity_1 dup key: { stock.size: \"XL\", stock.quantity: null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("stock: [{quantity: 20}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: stock.size_1_stock.quantity_1 dup key: { stock.size: null, stock.quantity: 20 }");
    }

    @Test
    public void testComparisons() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 'x'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {$gt: 1}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: 10")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {$gte: 1}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: 10"), TestUtils.json("_id: 3, a: 1")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {$lt: 10}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 3, a: 1")});
        AbstractBackendTest.assertThat(collection.find((Bson)TestUtils.json("a: {$lte: 10}"))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: 10"), TestUtils.json("_id: 3, a: 1")});
    }

    @Test
    public void testMinKeyComparison() {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 123"));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("value", (Object)new MinKey()));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5").append("value", (Object)new MaxKey()));
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$gt", (Object)new MinKey())))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, value: null"), TestUtils.json("_id: 2, value: 123"), TestUtils.json("_id: 4"), TestUtils.json("_id: 5").append("value", (Object)new MaxKey())});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$gte", (Object)new MinKey())))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, value: null"), TestUtils.json("_id: 2, value: 123"), TestUtils.json("_id: 3").append("value", (Object)new MinKey()), TestUtils.json("_id: 4"), TestUtils.json("_id: 5").append("value", (Object)new MaxKey())});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$lte", (Object)new MinKey())))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3").append("value", (Object)new MinKey())});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$lt", (Object)new MinKey())))).isEmpty();
    }

    @Test
    public void testMaxKeyComparison() {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 123"));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("value", (Object)new MaxKey()));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5").append("value", (Object)new MinKey()));
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$lt", (Object)new MaxKey())))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, value: null"), TestUtils.json("_id: 2, value: 123"), TestUtils.json("_id: 4"), TestUtils.json("_id: 5").append("value", (Object)new MinKey())});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$lte", (Object)new MaxKey())))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, value: null"), TestUtils.json("_id: 2, value: 123"), TestUtils.json("_id: 3").append("value", (Object)new MaxKey()), TestUtils.json("_id: 4"), TestUtils.json("_id: 5").append("value", (Object)new MinKey())});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$gte", (Object)new MaxKey())))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3").append("value", (Object)new MaxKey())});
        AbstractBackendTest.assertThat(collection.find((Bson)new Document("value", (Object)new Document("$gt", (Object)new MaxKey())))).isEmpty();
    }

    @Test
    public void testMinMaxKeyRangeQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: {id1: 10, id2: 20}"));
        collection.insertOne((Object)TestUtils.json("_id: {id1: 20, id2: 50}"));
        collection.insertOne((Object)TestUtils.json("_id: {id1: 10, id2: 100}"));
        collection.insertOne((Object)TestUtils.json("_id: {id1: 10}"));
        collection.insertOne((Object)TestUtils.json("_id: {id1: 10, id2: null}"));
        collection.insertOne((Object)TestUtils.json("_id: {id2: 20}"));
        Document rangeQuery = TestUtils.json("{_id: {'$gt': {id1: 10, id2: {'$minKey': 1}}, '$lt': {id1: 10, id2: {'$maxKey': 1}}}}");
        AbstractBackendTest.assertThat(collection.find((Bson)rangeQuery).sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: {id1: 10, id2: null}"), TestUtils.json("_id: {id1: 10, id2: 20}"), TestUtils.json("_id: {id1: 10, id2: 100}")});
        AbstractBackendTest.assertThat(collection.find((Bson)rangeQuery).sort((Bson)TestUtils.json("_id: -1"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: {id1: 10, id2: 100}"), TestUtils.json("_id: {id1: 10, id2: 20}"), TestUtils.json("_id: {id1: 10, id2: null}")});
    }

    @Test
    public void testOldAndNewUuidTypes() throws Exception {
        Document document1 = new Document("_id", (Object)UUID.fromString("5542cbb9-7833-96a2-b456-f13b6ae1bc80"));
        MongoClientSettings legacyUuidSettings = MongoClientSettings.builder().applyConnectionString(connectionString).uuidRepresentation(UuidRepresentation.JAVA_LEGACY).build();
        try (MongoClient clientWithLegacyUuid = MongoClients.create((MongoClientSettings)legacyUuidSettings);){
            MongoCollection collectionWithLegacyUuid = clientWithLegacyUuid.getDatabase(collection.getNamespace().getDatabaseName()).getCollection(collection.getNamespace().getCollectionName());
            collectionWithLegacyUuid.insertOne((Object)document1);
            AbstractBackendTest.assertMongoWriteException(() -> collectionWithLegacyUuid.insertOne((Object)document1), 11000, null, "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: BinData(3, A2963378B9CB425580BCE16A3BF156B4) }");
            collection.insertOne((Object)document1);
            AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)document1), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: UUID(\"5542cbb9-7833-96a2-b456-f13b6ae1bc80\") }");
            Document document2 = new Document("_id", (Object)UUID.fromString("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"));
            collection.insertOne((Object)document2);
            collectionWithLegacyUuid.deleteOne((Bson)document1);
            AbstractBackendTest.assertThat(collection.find().sort((Bson)TestUtils.json("_id: 1"))).containsExactly((Object[])new Document[]{document1, document2});
        }
    }

    @ParameterizedTest
    @EnumSource(value=UuidRepresentation.class)
    void testUuidRepresentations(UuidRepresentation uuidRepresentation) throws Exception {
        Assumptions.assumeTrue((uuidRepresentation != UuidRepresentation.UNSPECIFIED ? 1 : 0) != 0);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).uuidRepresentation(uuidRepresentation).build();
        try (MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);){
            MongoDatabase database = mongoClient.getDatabase("testdb");
            database.drop();
            MongoCollection collection = database.getCollection("testcollection");
            collection.insertOne((Object)TestUtils.json("_id: 1").append("key", (Object)UUID.fromString("5542cbb9-7833-96a2-b456-f13b6ae1bc80")));
            AbstractBackendTest.assertThat((Document)collection.find().first()).hasToString("Document{{_id=1, key=5542cbb9-7833-96a2-b456-f13b6ae1bc80}}");
        }
    }

    @Test
    void testConnectionStatus() throws Exception {
        Document result = this.runCommand("connectionStatus");
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("ok: 1.0, authInfo: {authenticatedUsers: [], authenticatedUserRoles: []}"));
    }

    @Test
    void testHostInfo() throws Exception {
        Document result = this.runCommand("hostInfo");
        AbstractBackendTest.assertThat(result.get((Object)"ok")).isEqualTo((Object)1.0);
        AbstractBackendTest.assertThat(result).containsKeys((Object[])new String[]{"os", "system", "extra"});
    }

    @Test
    void testGetCmdLineOpts() throws Exception {
        Document result = this.runCommand("getCmdLineOpts");
        AbstractBackendTest.assertThat(result.get((Object)"ok")).isEqualTo((Object)1.0);
        AbstractBackendTest.assertThat(result).containsOnlyKeys((Object[])new String[]{"ok", "argv", "parsed"});
    }

    @Test
    void testGetFreeMonitoringStatus() throws Exception {
        Document result = this.runCommand("getFreeMonitoringStatus");
        AbstractBackendTest.assertThat(result).isEqualTo((Object)TestUtils.json("ok: 1.0, state: 'undecided'"));
    }

    @Test
    public void testUpdateWithExpressionIsNotPossible() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {x: {$expr: {$add: ['$_id', 10]}}}")), 52, "DollarPrefixedFieldName", "The dollar ($) prefixed field '$expr' in 'x.$expr' is not valid for storage.");
    }

    @Test
    public void testEndSessions() {
        Document result = this.getAdminDb().runCommand((Bson)new Document("endSessions", Arrays.asList(new Document("id", (Object)UUID.randomUUID()))));
        AbstractBackendTest.assertThat(result.get((Object)"ok")).isEqualTo((Object)1.0);
    }

    @Test
    public void testLongIndex() {
        long id1 = 223372036854775806L;
        long id2 = 223372036854775800L;
        AbstractBackendTest.assertThat((Document)collection.find(Filters.eq((Object)id1)).first()).isNull();
        AbstractBackendTest.assertThat((Document)collection.find(Filters.eq((Object)id2)).first()).isNull();
        collection.insertOne((Object)new Document("_id", (Object)id1).append("name", (Object)"item 1"));
        AbstractBackendTest.assertThat((Document)collection.find(Filters.eq((Object)id1)).first()).isNotNull();
        AbstractBackendTest.assertThat((Document)collection.find(Filters.eq((Object)id2)).first()).isNull();
    }

    @Test
    void testQueryWithLargeLongValue() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)223372036854775806L).append("name", (Object)"item 1"));
        collection.insertOne((Object)new Document("_id", (Object)223372036854775807L).append("name", (Object)"item 2"));
        collection.insertOne((Object)new Document("_id", (Object)223372036854775808L).append("name", (Object)"item 3"));
        collection.insertOne((Object)new Document("_id", (Object)10.5).append("name", (Object)"item 4"));
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find(Filters.lt((String)"_id", (Object)223372036854775807L)))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 223372036854775806, name: 'item 1'"), TestUtils.json("_id: 10.5, name: 'item 4'")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find(Filters.lte((String)"_id", (Object)223372036854775807L)))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 223372036854775806, name: 'item 1'"), TestUtils.json("_id: 223372036854775807, name: 'item 2'"), TestUtils.json("_id: 10.5, name: 'item 4'")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find(Filters.gt((String)"_id", (Object)223372036854775807L)))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 223372036854775808, name: 'item 3'")});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find(Filters.gte((String)"_id", (Object)223372036854775807L)))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 223372036854775807, name: 'item 2'"), TestUtils.json("_id: 223372036854775808, name: 'item 3'")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCreateIndicesAndInsertDocumentsConcurrently(TestInfo testInfo) throws Exception {
        int numberOfThreads = 4;
        int numberOfDocumentsPerThread = 10;
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(testInfo.getDisplayName());
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, (ThreadFactory)threadFactory);
        try {
            for (int repetition = 0; repetition < 50; ++repetition) {
                ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
                for (int i = 0; i < numberOfThreads; ++i) {
                    int n = (i + 1) * 100;
                    futures.add(executorService.submit(() -> {
                        collection.createIndex((Bson)TestUtils.json("data: 1"));
                        for (int j = 0; j < numberOfDocumentsPerThread; ++j) {
                            Document document = new Document("_id", (Object)(baseIndex + j)).append("data", (Object)"abc");
                            collection.insertOne((Object)document);
                        }
                        return null;
                    }));
                }
                for (Future future : futures) {
                    future.get(DEFAULT_TEST_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
                }
                AbstractBackendTest.assertThat(TestUtils.toArray(collection.listIndexes())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}, name: '_id_', ns: 'testdb.testcoll', v: 2"), TestUtils.json("key: {data: 1}, name: 'data_1', ns: 'testdb.testcoll', v: 2")});
                AbstractBackendTest.assertThat(collection.countDocuments()).isEqualTo((long)(numberOfThreads * numberOfDocumentsPerThread));
                db.drop();
            }
        }
        finally {
            executorService.shutdown();
            boolean success = executorService.awaitTermination(DEFAULT_TEST_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            AbstractBackendTest.assertThat(success).isTrue();
        }
    }

    @Test
    void testFindDocumentByNestedByArray() throws Exception {
        Document document1 = new Document("_id", (Object)new Binary(new byte[]{32, 33, 34}));
        Document document2 = new Document("_id", (Object)new Binary(new byte[]{33, 34, 35}));
        collection.insertOne((Object)document1);
        collection.insertOne((Object)document2);
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)document1))).containsExactly((Object[])new Document[]{document1});
        AbstractBackendTest.assertThat(TestUtils.toArray(collection.find((Bson)document2))).containsExactly((Object[])new Document[]{document2});
    }

    @Test
    void testInsertDuplicate_byteArray() throws Exception {
        Document document = new Document("_id", (Object)new Binary(new byte[]{32, 33, 34}));
        collection.insertOne((Object)document);
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)document), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { _id: BinData(0, 202122) }");
    }

    @FunctionalInterface
    protected static interface Callable {
        public void call();
    }
}

