/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.TestUtils;
import de.bwaldvogel.mongo.entity.Account;
import de.bwaldvogel.mongo.entity.Person;
import de.bwaldvogel.mongo.entity.SubEntity;
import de.bwaldvogel.mongo.entity.TestEntity;
import de.bwaldvogel.mongo.repository.AccountRepository;
import de.bwaldvogel.mongo.repository.PersonRepository;
import de.bwaldvogel.mongo.repository.TestRepository;
import java.math.BigDecimal;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mongodb.config.AbstractMongoClientConfiguration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={TestConfig.class})
public abstract class AbstractBackendSpringDataTest {
    private static final String DATABASE_NAME = "testdb";
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private PersonRepository personRepository;
    @Autowired
    private AccountRepository accountRepository;
    @Autowired
    private TestRepository testRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    @BeforeEach
    void deleteAll() throws Exception {
        this.accountRepository.deleteAll();
        this.personRepository.deleteAll();
        this.testRepository.deleteAll();
    }

    @Test
    public void testSaveFindModifyAndUpdate() throws Exception {
        Person billy = (Person)this.personRepository.save(new Person("Billy", 123));
        this.personRepository.save(new Person("Joe", 456));
        this.testRepository.save(new TestEntity("abc", "some data"));
        Person savedBilly = this.personRepository.findOneByName(billy.getName());
        Assertions.assertThat((Comparable)savedBilly.getId()).isNotNull();
        Assertions.assertThat((String)savedBilly.getName()).isEqualTo(billy.getName());
        Assertions.assertThat((int)savedBilly.getSocialSecurityNumber()).isEqualTo(billy.getSocialSecurityNumber());
        Assertions.assertThat(savedBilly.getAccounts()).isNull();
        for (Person person : this.personRepository.findAll()) {
            person.addAccount((Account)this.accountRepository.save(new Account(BigDecimal.ZERO)));
            this.personRepository.save(person);
        }
        savedBilly = this.personRepository.findOneByName(billy.getName());
        savedBilly.addAccount((Account)this.accountRepository.save(new Account(new BigDecimal("8915.35"))));
        this.personRepository.save(savedBilly);
        Person updatedPerson = this.personRepository.findOneByName(billy.getName());
        Assertions.assertThat(updatedPerson.getAccounts()).hasSize(2);
        Assertions.assertThat((Iterable)this.mongoClient.listDatabaseNames()).containsExactly((Object[])new String[]{DATABASE_NAME});
        MongoDatabase database = this.mongoClient.getDatabase(DATABASE_NAME);
        Assertions.assertThat((Iterable)database.listCollectionNames()).containsExactlyInAnyOrder((Object[])new String[]{"person", "account", "test"});
        Assertions.assertThat((Iterable)this.personRepository.findAll()).hasSize(2);
        Assertions.assertThat((long)this.personRepository.count()).isEqualTo(2L);
        Assertions.assertThat((long)this.accountRepository.count()).isEqualTo(3L);
    }

    @Test
    public void testInsertDuplicateThrows() throws Exception {
        this.personRepository.save(new Person("Billy", 1));
        this.personRepository.save(new Person("Alice", 2));
        MongoDatabase database = this.mongoClient.getDatabase(DATABASE_NAME);
        List indexes = TestUtils.toArray(database.getCollection("person").listIndexes());
        Assertions.assertThat(indexes).extracting(index -> index.get((Object)"name")).containsExactlyInAnyOrder(new Object[]{"_id_", "unique_ssn"});
        Assertions.assertThatExceptionOfType(DataIntegrityViolationException.class).isThrownBy(() -> this.personRepository.save(new Person("Joe", 1))).withMessageContaining("E11000 duplicate key error");
    }

    @Test
    public void testDeleteWithUniqueIndexes() throws Exception {
        TestEntity document = (TestEntity)this.testRepository.save(new TestEntity("DOC_1", "Text1"));
        document.setText("Text1 (updated)");
        this.testRepository.save(document);
        Assertions.assertThat((List)this.testRepository.findAll()).hasSize(1);
        this.testRepository.deleteById("DOC_1");
        Assertions.assertThat((List)this.testRepository.findAll()).isEmpty();
        this.testRepository.save(new TestEntity("DOC_1", "Text1"));
    }

    @Test
    public void testCountByValueData() throws Exception {
        this.testRepository.save(new TestEntity("DOC_1", "Text1").withValue(new SubEntity("v1")));
        this.testRepository.save(new TestEntity("DOC_2", "Text2").withValue(new SubEntity("v1")));
        this.testRepository.save(new TestEntity("DOC_3", "Text3").withValue(new SubEntity("v2")));
        Assertions.assertThat((int)this.testRepository.countByValueData("v1")).isEqualTo(2);
        Assertions.assertThat((int)this.testRepository.countByValueData("v2")).isEqualTo(1);
        Assertions.assertThat((int)this.testRepository.countByValueData("v3")).isEqualTo(0);
    }

    @Test
    void testAggregation() throws Exception {
        this.testRepository.save(new TestEntity("1", "text"));
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria("id").exists(true).ne(null)), Aggregation.group((String[])new String[]{"id"}).last("value").as("value")});
        List results = this.mongoTemplate.aggregate(agg, TestEntity.class, TestEntity.class).getMappedResults();
        Assertions.assertThat((List)results).hasSize(1);
        Assertions.assertThat((String)((TestEntity)results.get(0)).getId()).isEqualTo("1");
    }

    @Configuration
    @EnableMongoRepositories(value={"de.bwaldvogel.mongo.repository"})
    static class TestConfig
    extends AbstractMongoClientConfiguration {
        @Autowired
        private MongoBackend backend;

        TestConfig() {
        }

        @Bean(destroyMethod="shutdown")
        MongoServer mongoServer() {
            return new MongoServer(this.backend);
        }

        @Bean
        public MongoClient mongoClient() {
            String connectionString = this.mongoServer().bindAndGetConnectionString();
            return MongoClients.create((String)connectionString);
        }

        public boolean autoIndexCreation() {
            return true;
        }

        protected String getDatabaseName() {
            return AbstractBackendSpringDataTest.DATABASE_NAME;
        }
    }
}

