/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.Function;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.TestUtils;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.Document;
import java.sql.Date;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractAggregationTest
extends AbstractTest {
    @BeforeEach
    void dropAllDatabasesBeforeEachTest() {
        this.dropAllDatabases();
    }

    @Test
    void testUnrecognizedAggregatePipelineStage() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unknown: {}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 40324 (Location40324): 'Unrecognized pipeline stage name: '$unknown'");
    }

    @Test
    void testIllegalAggregatePipelineStage() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unknown: {}, bar: 1");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 40323 (Location40323): 'A pipeline stage specification object must contain exactly one field.'");
    }

    @Test
    void testAggregateWithMissingCursor() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)TestUtils.json("aggregate: 'collection', pipeline: [{$match: {}}]"))).withMessageContaining("Command failed with error 9 (FailedToParse): 'The 'cursor' option is required, except for aggregate with the explain argument'");
    }

    @Test
    void testAggregateWithIllegalPipeline() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)TestUtils.json("aggregate: 'collection', cursor: {}, pipeline: 123"))).withMessageContaining("Command failed with error 14 (TypeMismatch): ''pipeline' option must be specified as an array'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)TestUtils.json("aggregate: 'collection', cursor: {}, pipeline: [1, 2, 3]"))).withMessageContaining("Command failed with error 14 (TypeMismatch): 'Each element of the 'pipeline' array must be an object");
    }

    @Test
    void testAggregateWithComplexGroupBySumPipeline() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, n: {$sum: 1}, sumOfA: {$sum: '$a'}, sumOfB: {$sum: '$b.value'}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 30, b: {value: 20}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 15, b: {value: 10.5}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: {value: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {value: 5}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, n: 4, sumOfA: 45, sumOfB: 31.5")});
    }

    @Test
    void testAggregateWithGroupByMinAndMax() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, minA: {$min: '$a'}, maxB: {$max: '$b.value'}, maxC: {$max: '$c'}, minC: {$min: '$c'}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 30, b: {value: 20}, c: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 15, b: {value: 10}, c: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, c: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, c: 'aaa'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, minA: 15, maxB: 20, minC: 1.0, maxC: 'zzz'")});
    }

    @Test
    void testAggregateWithGroupByMinAndMaxOnArrayField() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, min: {$min: '$v'}, max: {$max: '$v'}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, v: [10, 20, 30]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: [3, 40]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: [11, 25]"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, max: [11, 25], min: [3, 40]")});
    }

    @Test
    void testAggregateWithGroupByMinAndMaxOnArrayFieldAndNonArrayFields() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, min: {$min: '$v'}, max: {$max: '$v'}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, v: [10, 20, 30]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: [3, 40]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: [11, 25]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, v: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 5, v: null"));
        collection.insertOne((Object)TestUtils.json("_id: 6"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, max: [11, 25], min: 50")});
    }

    @Test
    void testAggregateWithGroupByNonExistingMinAndMax() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, minOfA: {$min: '$doesNotExist'}, maxOfB: {$max: '$doesNotExist'}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 30, b: {value: 20}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 15, b: {value: 10}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, minOfA: null, maxOfB: null")});
    }

    @Test
    void testMinMaxAvgProjectionOfArrayValues() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {min: {$min: '$v'}, max: {$max: '$v'}, avg: {$avg: '$v'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, v: [10, 20, 30]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: [3, 40]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: [11, 25]"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, min: 10, max: 30, avg: 20.0"), TestUtils.json("_id: 2, min: 3, max: 40, avg: 21.5"), TestUtils.json("_id: 3, min: 11, max: 25, avg: 18.0")});
    }

    @Test
    void testMinMaxAvgProjectionOfNonArrayValue() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {min: {$min: '$v'}, max: {$max: '$v'}, avg: {$avg: '$v'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, v: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, min: 'abc', max: 'abc', avg: null"), TestUtils.json("_id: 2, min: null, max: null, avg: null")});
    }

    @Test
    void testMinMaxAvgProjectionWithTwoParameters() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {min: {$min: ['$v', 2]}, max: {$max: ['$v', 2]}, avg: {$avg: ['$v', 2]}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, v: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: 0"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, v: 'abc'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, min: 2, max: 10, avg: 6.0"), TestUtils.json("_id: 2, min: 0, max: 2, avg: 1.0"), TestUtils.json("_id: 3, min: 2, max: 2, avg: 2.0"), TestUtils.json("_id: 4, min: 2, max: 'abc', avg: 2.0")});
    }

    @Test
    void testMinMaxAvgProjectionWithOneParameter() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {min: {$min: 'abc'}, max: {$max: 'def'}, avg: {$avg: 10}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, min: 'abc', max: 'def', avg: 10.0")});
    }

    @Test
    void testAggregateWithUnknownGroupOperator() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, n: {$foo: 1}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 15952 (Location15952): 'unknown group operator '$foo''");
    }

    @Test
    void testAggregateWithTooManyGroupOperators() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, n: {$sum: 1, $max: 1}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 40238 (Location40238): 'The field 'n' must specify one accumulator'");
    }

    @Test
    void testAggregateWithEmptyPipeline() throws Exception {
        AbstractAggregationTest.assertThat(collection.aggregate(Collections.emptyList())).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        AbstractAggregationTest.assertThat(collection.aggregate(Collections.emptyList())).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2")});
    }

    @Test
    void testAggregateWithMissingIdInGroupSpecification() throws Exception {
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)TestUtils.json("n: {$sum: 1}")));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 15955 (Location15955): 'a group specification must include an _id'");
    }

    @Test
    void testAggregateWithGroupBySumPipeline() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, n: {$sum: 1}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, n: 2")});
        query.putAll((Map)TestUtils.json("n: {$sum: 'abc'}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, n: 0")});
        query.putAll((Map)TestUtils.json("n: {$sum: 2}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, n: 4")});
        query.putAll((Map)TestUtils.json("n: {$sum: 1.75}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, n: 3.5")});
        query.putAll((Map)new org.bson.Document("n", (Object)new org.bson.Document("$sum", (Object)10000000000L)));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, n: 20000000000")});
        query.putAll((Map)new org.bson.Document("n", (Object)new org.bson.Document("$sum", (Object)Float.valueOf(-2.5f))));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, n: -5.0")});
    }

    @Test
    void testAggregateWithGroupByAvg() throws Exception {
        org.bson.Document query = TestUtils.json("_id: null, avg: {$avg: 1}");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$group", (Object)query));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 6.0, b: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 3.0, b: 'aaa'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, avg: 1.0")});
        query.putAll((Map)TestUtils.json("avg: {$avg: '$a'}, avgB: {$avg: '$b'}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, avg: 4.5, avgB: null")});
    }

    @Test
    void testAggregateWithGroupByKey() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {_id: '$a', count: {$sum: 1}, avg: {$avg: '$b'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 2, b: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 2, b: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 5, b: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 7, c: 'a'"));
        collection.insertOne((Object)TestUtils.json("_id: 7"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, count: 2, avg: null"), TestUtils.json("_id: 2, count: 2, avg: 3.5"), TestUtils.json("_id: 5, count: 1, avg: 10.0"), TestUtils.json("_id: 7, count: 1, avg: null"), TestUtils.json("_id: null, count: 1, avg: null")});
    }

    @Test
    void testAggregateWithGroupByNumberEdgeCases() throws Exception {
        String groupBy = "$group: {_id: '$a', count: {$sum: 1}, avg: {$avg: '$a'}, min: {$min: '$a'}, max: {$max: '$a'}}";
        List<org.bson.Document> pipeline = TestUtils.jsonList(groupBy);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: -0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 0"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 1.5"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: null"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: -0.0, count: 3, avg: 0.0, min: -0.0, max: -0.0"), TestUtils.json("_id: 1.0, count: 2, avg: 1.0, min: 1.0, max: 1.0"), TestUtils.json("_id: 1.5, count: 1, avg: 1.5, min: 1.5, max: 1.5"), TestUtils.json("_id: null, count: 1, avg: null, min: null, max: null")});
    }

    @Test
    void testAggregateWithGroupByDocuments() throws Exception {
        String groupBy = "$group: {_id: '$a', count: {$sum: 1}}";
        String sort = "$sort: {_id: 1}";
        List<org.bson.Document> pipeline = Arrays.asList(TestUtils.json(groupBy), TestUtils.json(sort));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id:  1, a: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1, c: 1}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1.0, d: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {b: {d: 1, c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 1, b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: {b: 1, c: 1}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, count: 1"), TestUtils.json("_id: 1.0, count: 1"), TestUtils.json("_id: {b: 1}, count: 2"), TestUtils.json("_id: {b: 1, c: 1}, count: 2"), TestUtils.json("_id: {c: 1, b: 1}, count: 1"), TestUtils.json("_id: {b: {c: 1}}, count: 2"), TestUtils.json("_id: {b: {c: 1.0, d: 1}}, count: 1"), TestUtils.json("_id: {b: {d: 1, c: 1.0}}, count: 1")});
    }

    @Test
    void testAggregateWithGroupByIllegalKey() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$group: {_id: '$a.'}")).first()).withMessageContaining("Command failed with error 40353 (Location40353): 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$group: {_id: '$a..1'}")).first()).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
    }

    @Test
    void testAggregateWithSimpleExpressions() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {_id: {$abs: '$value'}, count: {$sum: 1}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 1"));
        collection.insertOne((Object)TestUtils.json("_id: -2, value: -1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 5, value: -2.5"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, count: 2"), TestUtils.json("_id: 2, count: 2"), TestUtils.json("_id: 2.5, count: 1")});
    }

    @Test
    void testAggregateWithMultipleExpressionsInKey() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {_id: {abs: {$abs: '$value'}, sum: {$subtract: ['$end', '$start']}}, count: {$sum: 1}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: NaN"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 1, start: 5, end: 8"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: -1, start: 4, end: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 2, start: 9, end: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 5, value: 2, start: 6, end: 7"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: {abs: NaN, sum: null}, count: 1"), TestUtils.json("_id: {abs: 1, sum: 3}, count: 1"), TestUtils.json("_id: {abs: 1, sum: 0}, count: 1"), TestUtils.json("_id: {abs: 2, sum: -2}, count: 1"), TestUtils.json("_id: {abs: 2, sum: 1}, count: 1")});
    }

    @Test
    void testAggregateWithAddToSet() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {_id: { day: { $dayOfYear: '$date'}, year: { $year: '$date' } }, itemsSold: { $addToSet: '$item' }}", "$sort: {_id: 1}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'zzz', price:  5, quantity: 10").append("date", (Object)TestUtils.instant("2014-02-15T09:12:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'abc', price: 10, quantity:  2").append("date", (Object)TestUtils.instant("2014-01-01T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'jkl', price: 20, quantity:  1").append("date", (Object)TestUtils.instant("2014-02-03T09:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'xyz', price:  5, quantity:  5").append("date", (Object)TestUtils.instant("2014-02-03T09:05:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', price: 10, quantity: 10").append("date", (Object)TestUtils.instant("2014-02-15T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 6, item: 'xyz', price:  5, quantity: 10").append("date", (Object)TestUtils.instant("2014-02-15T09:12:00Z")));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline).map(AbstractAggregationTest.withSortedStringList("itemsSold"))).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: { day:  1, year: 2014 }, itemsSold: [ 'abc' ]"), TestUtils.json("_id: { day: 34, year: 2014 }, itemsSold: [ 'jkl', 'xyz' ]"), TestUtils.json("_id: { day: 46, year: 2014 }, itemsSold: [ 'abc', 'xyz', 'zzz' ]")});
    }

    @Test
    void testAggregateWithEmptyAddToSet() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {_id: 1, set: { $addToSet: '$foo' }}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, set: [ ]")});
    }

    @Test
    void testAggregateWithAddToSetAndMissingValue() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {\n    _id: '$_id', \n    sources: {\n        $addToSet: {\n            key: '$content.key',\n            missing: '$content.missing'\n        }\n    }\n}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, content: {key: 'value', key2: 'value2'}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, sources: [{key: 'value'}]")});
    }

    @Test
    void testAggregateWithAdd() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: { item: 1, total: { $add: [ '$price', '$fee' ] } }");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', price: 10, fee: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', price: 20, fee: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'xyz', price: 5, fee: 0"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, item: 'abc', total: 12"), TestUtils.json("_id: 2, item: 'jkl', total: 21"), TestUtils.json("_id: 3, item: 'xyz', total: 5 ")});
    }

    @Test
    void testAggregateWithSort() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$sort: { price: -1, fee: 1 }");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, fee: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 20, fee: 0"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 10, fee: 0"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 2, price: 20, fee: 0"), TestUtils.json("_id: 3, price: 10, fee: 0"), TestUtils.json("_id: 1, price: 10, fee: 1")});
    }

    @Test
    void testAggregateWithProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 1, value: '$x', n: '$foo.bar', other: null}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10, foo: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 30, foo: {bar: 7.3}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, value: 10, other: null"), TestUtils.json("_id: 2, value: 20, other: null"), TestUtils.json("_id: 3, value: 30, n: 7.3, other: null")});
    }

    @Test
    void testAggregateWithNestedExclusiveProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 0, 'x.b': 0}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: {a: 1, b: 2, c: 3}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, x: ['abc', {a: 1, b: 2}, {a: 2, b: 3, c: 4}]"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("x: {a: 1, c: 3}"), TestUtils.json("x: 20"), TestUtils.json(""), TestUtils.json("x: ['abc', {a: 1}, {a: 2, c: 4}]")});
    }

    @Test
    void testAggregateWithNestedExclusiveProjection_array() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 0, 'a.b.c': 0}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{b: {c: 1}}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: [{x: 1, y: 2, c: 3}, {c: 4}]}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [{b: {c: [1, 2, 3]}}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {b: {c: [1, 2, 3]}}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("a: [{b: {}}]"), TestUtils.json("a: {b: [{x: 1, y: 2}, {}]}"), TestUtils.json("a: [{b: {}}]"), TestUtils.json("a: {b: {}}")});
    }

    @Test
    void testAggregateWithNestedInclusiveProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {'x.b': 1, 'x.c': 1}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: {b: 2, c: 3}"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, x: {b: 2, c: 3}"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    void testAggregateWithIllegalProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {'x.b': 1, 'x.c': 1, 'x.d': 0, y: 0}");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 40178 (Location40178): 'Bad projection specification, cannot exclude fields other than '_id' in an inclusion projection: { x.b: 1, x.c: 1, x.d: 0, y: 0 }'");
    }

    @Test
    void testAggregateWithProjection_IllegalFieldPath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 0, v: '$x.1.'}")).first()).withMessageContaining("Command failed with error 40353 (Location40353): 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 0, v: '$x..1'}")).first()).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
    }

    @Test
    void testAggregateWithProjection_arrayElemAt() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, items: [{foo: 'bar'}, {foo: 'bas'}, {foo: 'bat'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, items: [{}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, items: [{foo: null}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, items: []"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        AbstractAggregationTest.assertThat(collection.aggregate(TestUtils.jsonList("$project: {value: {$arrayElemAt: ['$items.foo', 0]}}"))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, value: 'bar'"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3, value: null"), TestUtils.json("_id: 4"), TestUtils.json("_id: 5, value: null")});
        AbstractAggregationTest.assertThat(collection.aggregate(TestUtils.jsonList("$project: {value: {$arrayElemAt: ['$items.foo', -1]}}"))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, value: 'bat'"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3, value: null"), TestUtils.json("_id: 4"), TestUtils.json("_id: 5, value: null")});
        AbstractAggregationTest.assertThat(collection.aggregate(TestUtils.jsonList("$project: {value: {$arrayElemAt: ['$items.foo', 10]}}"))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3"), TestUtils.json("_id: 4"), TestUtils.json("_id: 5, value: null")});
    }

    @Test
    void testAggregateWithExpressionProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 0, idHex: {$toString: '$_id'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)new org.bson.Document("_id", (Object)new ObjectId("abcd01234567890123456789")));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("idHex: 'abcd01234567890123456789'")});
    }

    @Test
    void testAggregateWithStrLenExpressionProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 0, lenCP: {$strLenCP: '$a'}, lenBytes: {$strLenBytes: '$a'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("a: 'caf\u00e9t\u00e9ria', b: 123"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("lenCP: 9, lenBytes: 11")});
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {len: {$strLenCP: '$x'}}")).first()).withMessageContaining("Command failed with error 34471 (Location34471): '$strLenCP requires a string argument, found: missing'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {len: {$strLenCP: '$b'}}")).first()).withMessageContaining("Command failed with error 34471 (Location34471): '$strLenCP requires a string argument, found: int'");
    }

    @Test
    void testAggregateWithSubstringExpressionProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 0, a: {$substr: ['$v', 0, -1]}, b: {$substr: ['$v', 1, -3]}, c: {$substr: ['$v', 5, 5]}, d: {$substr: [123, 0, -1]}, e: {$substr: [null, 0, -1]}f: {$substr: ['abc', 4, -1]}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("v: 'some value'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("a: 'some value', b: 'ome value', c: 'value', d: '123', e: '', f: ''")});
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {x: {$substr: 'abc'}}")).first()).withMessageContaining("Command failed with error 16020 (Location16020): 'Expression $substrBytes takes exactly 3 arguments. 1 were passed in.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {x: {$substr: ['abc', 'abc', 3]}}")).first()).withMessageContaining("Command failed with error 16034 (Location16034): 'Failed to optimize pipeline :: caused by :: $substrBytes:  starting index must be a numeric type (is BSON type string)");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {x: {$substr: ['abc', 3, 'abc']}}")).first()).withMessageContaining("Command failed with error 16035 (Location16035): 'Failed to optimize pipeline :: caused by :: $substrBytes:  length must be a numeric type (is BSON type string)");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {x: {$substrCP: 'abc'}}")).first()).withMessageContaining("Command failed with error 16020 (Location16020): 'Expression $substrCP takes exactly 3 arguments. 1 were passed in.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {x: {$substrCP: ['abc', 'abc', 3]}}")).first()).withMessageContaining("Command failed with error 34450 (Location34450): 'Failed to optimize pipeline :: caused by :: $substrCP: starting index must be a numeric type (is BSON type string)");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {x: {$substrCP: ['abc', 3, 'abc']}}")).first()).withMessageContaining("Command failed with error 34452 (Location34452): 'Failed to optimize pipeline :: caused by :: $substrCP: length must be a numeric type (is BSON type string)");
    }

    @Test
    void testAggregateWithSubstringUnicodeExpressionProjection() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 0, a: {$substrBytes: ['$v', 0, 5]}, b: {$substrCP: ['$v', 0, 5]}, c: {$substrBytes: ['$v', 5, 4]}, d: {$substrCP: ['$v', 5, 4]}, }");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("v: 'caf\u00e9t\u00e9ria'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("a: 'caf\u00e9', b: 'caf\u00e9t', c: 't\u00e9r', d: '\u00e9ria'")});
    }

    @Test
    void testAggregateWithAddFields() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$addFields: {value: '$x'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 123"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, x: 10, value: 10"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    void testAggregateWithMultipleMatches() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {price: {$lt: 100}}", "$match: {quality: {$gt: 10}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, quality: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 150, quality: 500"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 50, quality: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 4, price: 10, quality: 5"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, price: 10, quality: 50"), TestUtils.json("_id: 3, price: 50, quality: 150")});
    }

    @Test
    void testAggregateWithLogicalAndInMatch() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {$and: [{price: {$lt: 100}}, {quality: {$gt: 10}}]}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, quality: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 150, quality: 500"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 50, quality: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 4, price: 10, quality: 5"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, price: 10, quality: 50"), TestUtils.json("_id: 3, price: 50, quality: 150")});
    }

    @Test
    void testAggregateWithLogicalAndInMatchExpr() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {$expr: {$and: [{$lt: ['$price', 100]}, {$gt: ['$quality', 10]}]}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, quality: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 150, quality: 500"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 50, quality: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 4, price: 10, quality: 5"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, price: 10, quality: 50"), TestUtils.json("_id: 3, price: 50, quality: 150")});
    }

    @Test
    void testAggregateWithLogicalOrInMatchExpr() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {$expr: {$or: [{$gt: ['$price', 100]}, {$gt: ['$quality', 70]}]}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, quality: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 150, quality: 500"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 50, quality: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 4, price: 10, quality: 5"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 2, price: 150, quality: 500"), TestUtils.json("_id: 3, price: 50, quality: 150")});
    }

    @Test
    void testAggregateWithLogicalOrInMatch() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {$or: [{$and: [{price: {$lt: 50}}, {quality: {$gt: 10}}]}, {quality: {$gt: 200}}]}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, quality: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 150, quality: 500"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 50, quality: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 4, price: 10, quality: 5"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, price: 10, quality: 50"), TestUtils.json("_id: 2, price: 150, quality: 500")});
    }

    @Test
    void testAggregateWithCeil() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {a: 1, ceil: {$ceil: '$a'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 9.25"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 8.73"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 4.32"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: -5.34"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, a: 9.25, ceil: 10.0"), TestUtils.json("_id: 2, a: 8.73, ceil: 9.0"), TestUtils.json("_id: 3, a: 4.32, ceil: 5.0"), TestUtils.json("_id: 4, a: -5.34, ceil: -5.0")});
    }

    @Test
    void testAggregateWithNumericOperators() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {a: 1, exp: {$exp: '$a'}, ln: {$ln: '$a'}, log10: {$log10: '$a'}, sqrt: {$sqrt: '$a'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, a: 1, exp: 2.718281828459045, ln: 0.0, log10: 0.0, sqrt: 1.0")});
    }

    @Test
    void testAggregateWithCount() throws Exception {
        org.bson.Document match = TestUtils.json("$match: {score: {$gt: 80}}");
        org.bson.Document count = TestUtils.json("$count: 'passing_scores'");
        List<org.bson.Document> pipeline = Arrays.asList(match, count);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, subject: 'History', score: 88"));
        collection.insertOne((Object)TestUtils.json("_id: 2, subject: 'History', score: 92"));
        collection.insertOne((Object)TestUtils.json("_id: 3, subject: 'History', score: 97"));
        collection.insertOne((Object)TestUtils.json("_id: 4, subject: 'History', score: 71"));
        collection.insertOne((Object)TestUtils.json("_id: 5, subject: 'History', score: 79"));
        collection.insertOne((Object)TestUtils.json("_id: 6, subject: 'History', score: 83"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("passing_scores: 4")});
    }

    @Test
    void testAggregateWithFirstAndLast() throws Exception {
        org.bson.Document sort = TestUtils.json("$sort: { item: 1, date: 1 }");
        org.bson.Document group = TestUtils.json("$group: {_id: '$item', firstSale: { $first: '$date' }, lastSale: { $last: '$date'} }");
        List<org.bson.Document> pipeline = Arrays.asList(sort, group);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', price: 10, quantity:  2").append("date", (Object)TestUtils.instant("2014-01-01T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', price: 20, quantity:  1").append("date", (Object)TestUtils.instant("2014-02-03T09:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'xyz', price:  5, quantity:  5").append("date", (Object)TestUtils.instant("2014-02-03T09:05:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'abc', price: 10, quantity: 10").append("date", (Object)TestUtils.instant("2014-02-15T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'xyz', price:  5, quantity: 10").append("date", (Object)TestUtils.instant("2014-02-15T09:12:00Z")));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 'abc'").append("firstSale", (Object)TestUtils.date("2014-01-01T08:00:00Z")).append("lastSale", (Object)TestUtils.date("2014-02-15T08:00:00Z")), TestUtils.json("_id: 'jkl'").append("firstSale", (Object)TestUtils.date("2014-02-03T09:00:00Z")).append("lastSale", (Object)TestUtils.date("2014-02-03T09:00:00Z")), TestUtils.json("_id: 'xyz'").append("firstSale", (Object)TestUtils.date("2014-02-03T09:05:00Z")).append("lastSale", (Object)TestUtils.date("2014-02-15T09:12:00Z"))});
    }

    @Test
    void testAggregateWithFirstAndLast_Missing() throws Exception {
        org.bson.Document group = TestUtils.json("$group: {_id: '$_id', first: { $first: '$field1' }, last: { $last: '$field2'} }");
        List<org.bson.Document> pipeline = Collections.singletonList(group);
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, field1: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, field2: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, field1: 'abc', field2: 'abc'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, first: null, last: null"), TestUtils.json("_id: 2, first: 'abc', last: null"), TestUtils.json("_id: 3, first: null, last: 'abc'"), TestUtils.json("_id: 4, first: 'abc', last: 'abc'")});
    }

    @Test
    void testAggregateWithGroupingAndFirstMissing() throws Exception {
        org.bson.Document sort = TestUtils.json("$sort: {_id: 1}");
        org.bson.Document group = TestUtils.json("$group: {_id: '$group', first: { $first: '$field1' }}");
        List<org.bson.Document> pipeline = Arrays.asList(sort, group);
        collection.insertOne((Object)TestUtils.json("_id: 1, group: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, group: 1, field1: 'abc'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, first: null")});
    }

    @Test
    void testAggregateWithGroupingAndLastMissing() throws Exception {
        org.bson.Document sort = TestUtils.json("$sort: {_id: 1}");
        org.bson.Document group = TestUtils.json("$group: {_id: '$group', last: { $last: '$field1' }}");
        List<org.bson.Document> pipeline = Arrays.asList(sort, group);
        collection.insertOne((Object)TestUtils.json("_id: 1, group: 1, field1: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, group: 1"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, last: null")});
    }

    @Test
    void testAggregateWithPush() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {_id: null, a: {$push: '$a'}, b: {$push: {v: '$b'}}, c: {$push: '$c'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10, b: 0.1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 20, b: 0.2"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, a: [10, 20], b: [{v: 0.1}, {v: 0.2}], c: []")});
    }

    @Test
    void testAggregateWithUndefinedVariable() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {result: '$$UNDEFINED'}");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 17276 (Location17276): 'Use of undefined variable: UNDEFINED'");
    }

    @Test
    void testAggregateWithRootVariable() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 0, doc: '$$ROOT', a: '$$ROOT.a', a_v: '$$ROOT.a.v'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {v: 10}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("doc: {_id: 1, a: {v: 10}}, a: {v: 10}, a_v: 10")});
    }

    @Test
    void testAggregateWithRootVariable_IllegalFieldPath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: '$$ROOT.a.'}")).first()).withMessageContaining("Command failed with error 40353 (Location40353): 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: '$$ROOT.a..1'}")).first()).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
    }

    @Test
    void testAggregateWithSetOperations() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {union: {$setUnion: ['$a', '$b']}, diff: {$setDifference: ['$a', '$b']}, intersection: {$setIntersection: ['$a', '$b']}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [3, 2, 1]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: [1.0, -0.0], b: [3, 2, 0]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [{a: 0}, {a: 1}], b: [{a: 0.0}, {a: 0.5}]"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, diff: null, intersection: null, union: null"), TestUtils.json("_id: 2, diff: [1.0], intersection: [-0.0], union: [-0.0, 1.0, 2, 3]"), TestUtils.json("_id: 3, diff: [{a: 1}], intersection: [{a: 0}], union: [{a: 0}, {a: 0.5}, {a: 1}]")});
    }

    @Test
    void testAggregateWithComparisonOperations() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, v: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: null"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 4, v: [10, 20, 30]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, v: ['abc']"));
        collection.insertOne((Object)TestUtils.json("_id: 6, v: [30, 40]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, v: [5]"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {cmp1: {$cmp: ['$v', 10]}, cmp2: {$cmp: ['$v', [10]]}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, cmp1:  1, cmp2: -1"), TestUtils.json("_id: 2, cmp1: -1, cmp2: -1"), TestUtils.json("_id: 3, cmp1:  0, cmp2: -1"), TestUtils.json("_id: 4, cmp1:  1, cmp2:  1"), TestUtils.json("_id: 5, cmp1:  1, cmp2:  1"), TestUtils.json("_id: 6, cmp1:  1, cmp2:  1"), TestUtils.json("_id: 7, cmp1:  1, cmp2: -1")});
        org.bson.Document project = TestUtils.json("$project: {gt1: {$gt: ['$v', 10]}, gt2: {$gt: ['$v', [10]]}}");
        pipeline = Collections.singletonList(project);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, gt1: true, gt2: false"), TestUtils.json("_id: 2, gt1: false, gt2: false"), TestUtils.json("_id: 3, gt1: false, gt2: false"), TestUtils.json("_id: 4, gt1: true, gt2: true"), TestUtils.json("_id: 5, gt1: true, gt2: true"), TestUtils.json("_id: 6, gt1: true, gt2: true"), TestUtils.json("_id: 7, gt1: true, gt2: false")});
        project = TestUtils.json("$project: {lt1: {$lt: ['$v', 10]}, lt2: {$lt: ['$v', [10]]}}");
        pipeline = Collections.singletonList(project);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrder((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, lt1: false, lt2: true"), TestUtils.json("_id: 2, lt1: true, lt2: true"), TestUtils.json("_id: 3, lt1: false, lt2: true"), TestUtils.json("_id: 4, lt1: false, lt2: false"), TestUtils.json("_id: 5, lt1: false, lt2: false"), TestUtils.json("_id: 6, lt1: false, lt2: false"), TestUtils.json("_id: 7, lt1: false, lt2: true")});
    }

    @Test
    void testAggregateWithSlice() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {name: 1, threeFavorites: {$slice: ['$favorites', 3]}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, name: 'dave123', favorites: ['chocolate', 'cake', 'butter', 'apples']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, name: 'li', favorites: ['apples', 'pudding', 'pie']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, name: 'ahn', favorites: ['pears', 'pecans', 'chocolate', 'cherries']"));
        collection.insertOne((Object)TestUtils.json("_id: 4, name: 'ty', favorites: ['ice cream']"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, name: 'dave123', threeFavorites: ['chocolate', 'cake', 'butter']"), TestUtils.json("_id: 2, name: 'li', threeFavorites: ['apples', 'pudding', 'pie']"), TestUtils.json("_id: 3, name: 'ahn', threeFavorites: ['pears', 'pecans', 'chocolate']"), TestUtils.json("_id: 4, name: 'ty', threeFavorites: ['ice cream']")});
    }

    @Test
    void testAggregateWithSplit() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 1, names: {$split: ['$name', ' ']}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, name: 'first document'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, name: 'second document'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, names: ['first', 'document']"), TestUtils.json("_id: 2, names: ['second', 'document']")});
    }

    @Test
    void testAggregateWithUnwind() throws Exception {
        this.testAggregateWithUnwind(TestUtils.json("$unwind: '$sizes'"));
    }

    @Test
    void testAggregateWithUnwind_Path() throws Exception {
        this.testAggregateWithUnwind(TestUtils.json("$unwind: {path: '$sizes'}"));
    }

    private void testAggregateWithUnwind(org.bson.Document unwind) throws Exception {
        List<org.bson.Document> pipeline = Collections.singletonList(unwind);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'"), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'")});
    }

    @Test
    void testAggregateWithUnwind_preserveNullAndEmptyArrays() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', preserveNullAndEmptyArrays: true}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'"), TestUtils.json("_id: 2, item: 'EFG'"), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"), TestUtils.json("_id: 4, item: 'LMN'"), TestUtils.json("_id: 5, item: 'XYZ', sizes: null")});
    }

    @Test
    void testAggregateWithUnwind_IncludeArrayIndex() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', includeArrayIndex: 'idx'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'").append("idx", (Object)0L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'").append("idx", (Object)1L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'").append("idx", (Object)2L), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'").append("idx", null)});
    }

    @Test
    void testAggregateWithUnwind_IncludeArrayIndex_OverwriteExistingField() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', includeArrayIndex: 'item'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, sizes: 'S'").append("item", (Object)0L), TestUtils.json("_id: 1, sizes: 'M'").append("item", (Object)1L), TestUtils.json("_id: 1, sizes: 'L'").append("item", (Object)2L), TestUtils.json("_id: 3, sizes: 'M'").append("item", null)});
    }

    @Test
    void testAggregateWithUnwind_IncludeArrayIndex_NestedIndexField() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', includeArrayIndex: 'item.idx'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: {value: 'ABC'}, sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: {value: 'EFG'}, sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: {value: 'IJK'}, sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: {value: 'LMN'}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: {value: 'XYZ'}, sizes: null"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, sizes: 'S'").append("item", (Object)TestUtils.json("value: 'ABC'").append("idx", (Object)0L)), TestUtils.json("_id: 1, sizes: 'M'").append("item", (Object)TestUtils.json("value: 'ABC'").append("idx", (Object)1L)), TestUtils.json("_id: 1, sizes: 'L'").append("item", (Object)TestUtils.json("value: 'ABC'").append("idx", (Object)2L)), TestUtils.json("_id: 3, sizes: 'M'").append("item", (Object)TestUtils.json("value: 'IJK'").append("idx", null))});
    }

    @Test
    void testAggregateWithUnwind_preserveNullAndEmptyArraysAndIncludeArrayIndex() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', preserveNullAndEmptyArrays: true, includeArrayIndex: 'idx'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'").append("idx", (Object)0L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'").append("idx", (Object)1L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'").append("idx", (Object)2L), TestUtils.json("_id: 2, item: 'EFG'").append("idx", null), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'").append("idx", null), TestUtils.json("_id: 4, item: 'LMN'").append("idx", null), TestUtils.json("_id: 5, item: 'XYZ', sizes: null").append("idx", null)});
    }

    @Test
    void testAggregateWithUnwind_subdocumentArray() throws Exception {
        List<org.bson.Document> pipeline = Collections.singletonList(TestUtils.json("$unwind: {path: '$items.sizes'}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, items: [{sizes: ['S', 'M', 'L']}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, items: [{sizes: 'M'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, items: {sizes: ['XL', 'S']}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, items: [{sizes: ['M', 'L']}]"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 3, items: {sizes: 'XL'}"), TestUtils.json("_id: 3, items: {sizes: 'S'}")});
    }

    @Test
    void testAggregateWithLookup() {
        MongoCollection authorsCollection = db.getCollection("authors");
        authorsCollection.insertOne((Object)TestUtils.json("_id: 1, name: 'Uncle Bob'"));
        authorsCollection.insertOne((Object)TestUtils.json("_id: 2, name: 'Martin Fowler'"));
        authorsCollection.insertOne((Object)TestUtils.json("_id: null, name: 'Null Author'"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$lookup: {from: 'authors', localField: 'authorId', foreignField: '_id', as: 'author'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 4, title: 'Unknown author', authorId: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 5, title: 'No author', authorId: null"));
        collection.insertOne((Object)TestUtils.json("_id: 6, title: 'Missing author'"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2, author: [{_id: 2, name: 'Martin Fowler'}]"), TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1, author: [{_id: 1, name: 'Uncle Bob'}]"), TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1, author: [{_id: 1, name: 'Uncle Bob'}]"), TestUtils.json("_id: 4, title: 'Unknown author', authorId: 3, author: []"), TestUtils.json("_id: 5, title: 'No author', authorId: null, author: [{_id: null, name: 'Null Author'}]"), TestUtils.json("_id: 6, title: 'Missing author', author: [{_id: null, name: 'Null Author'}]")});
    }

    @Test
    void testAggregateWithLookup_collectionDoesNotExist() {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$lookup: {from: 'authors', localField: 'authorId', foreignField: '_id', as: 'author'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2, author: []"), TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1, author: []"), TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1, author: []")});
    }

    @Test
    void testAggregateWithIllegalLookupStage() {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$lookup: {from: 'coll', let: 'abc', pipeline: [], as: 'data'}")).first()).withMessageContaining("Command failed with error 9 (FailedToParse): '$lookup argument 'let: \"abc\"' must be an object, is type string'");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$lookup: {from: 'coll', let: {}, pipeline: 'abc', as: 'data'}")).first()).withMessageContaining("Command failed with error 14 (TypeMismatch): ''pipeline' option must be specified as an array'");
    }

    @Test
    void testAggregateWithLookupAndPipeline() {
        MongoCollection ordersCollection = db.getCollection("orders");
        MongoCollection itemsCollection = db.getCollection("items");
        List<org.bson.Document> pipeline = TestUtils.jsonList("$lookup: {from: 'items', pipeline: [{$project: {item: 1, _id: 0}}], as: 'items'}");
        AbstractAggregationTest.assertThat(ordersCollection.aggregate(pipeline)).isEmpty();
        ordersCollection.insertOne((Object)TestUtils.json("_id: 1, order: 100"));
        ordersCollection.insertOne((Object)TestUtils.json("_id: 2, order: 101"));
        ordersCollection.insertOne((Object)TestUtils.json("_id: 3, order: 102"));
        itemsCollection.insertOne((Object)TestUtils.json("_id: 1, item: 'A'"));
        itemsCollection.insertOne((Object)TestUtils.json("_id: 2, item: 'B'"));
        AbstractAggregationTest.assertThat(ordersCollection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, order: 100, items: [{item: 'A'}, {item: 'B'}]"), TestUtils.json("_id: 2, order: 101, items: [{item: 'A'}, {item: 'B'}]"), TestUtils.json("_id: 3, order: 102, items: [{item: 'A'}, {item: 'B'}]")});
    }

    @Test
    void testAggregateWithLookupAndUncorrelatedSubqueries() {
        MongoCollection ordersCollection = db.getCollection("orders");
        MongoCollection warehousesCollection = db.getCollection("warehouses");
        List<org.bson.Document> pipeline = TestUtils.jsonList("$lookup: {from: 'warehouses', let: { order_item: '$item', order_qty: '$ordered' }, pipeline: [{$match:\n                 {$expr:\n                    {$and:\n                       [\n                         {$eq: ['$stock_item',  '$$order_item']},\n                         {$gte: ['$instock', '$$order_qty']}\n                       ]\n                    }\n                 }\n              },\n              {$project: {stock_item: 0, _id: 0}}], as: 'stockdata'}");
        AbstractAggregationTest.assertThat(ordersCollection.aggregate(pipeline)).isEmpty();
        ordersCollection.insertOne((Object)TestUtils.json("_id: 1, item: 'almonds', price: 12, ordered: 2"));
        ordersCollection.insertOne((Object)TestUtils.json("_id: 2, item: 'pecans', price: 20, ordered: 1"));
        ordersCollection.insertOne((Object)TestUtils.json("_id: 3, item: 'pecans', price: 10, ordered: 60"));
        warehousesCollection.insertOne((Object)TestUtils.json("_id: 1, stock_item: 'almonds', warehouse: 'A', instock: 120"));
        warehousesCollection.insertOne((Object)TestUtils.json("_id: 2, stock_item: 'pecans', warehouse: 'A', instock: 80"));
        warehousesCollection.insertOne((Object)TestUtils.json("_id: 3, stock_item: 'almonds', warehouse: 'B', instock: 60"));
        warehousesCollection.insertOne((Object)TestUtils.json("_id: 4, stock_item: 'cookies', warehouse: 'B', instock: 40"));
        warehousesCollection.insertOne((Object)TestUtils.json("_id: 5, stock_item: 'cookies', warehouse: 'A', instock: 80"));
        AbstractAggregationTest.assertThat(ordersCollection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, item: 'almonds', price: 12, ordered: 2, stockdata: [{instock: 120, warehouse: 'A'}, {instock: 60, warehouse: 'B'}]"), TestUtils.json("_id: 2, item: 'pecans', price: 20, ordered: 1, stockdata: [{instock: 80, warehouse: 'A'}]"), TestUtils.json("_id: 3, item: 'pecans', price: 10, ordered: 60, stockdata: [{instock: 80, warehouse: 'A'}]")});
    }

    @Test
    void testAggregateWithReplaceRoot() {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$replaceRoot: { newRoot: '$a.b' }");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: { b: { c: 10 } }"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("c: 10")});
    }

    @Test
    void testAggregateWithIllegalReplaceRoot() {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$replaceRoot: { newRoot: '$a.b' }");
        collection.insertOne((Object)TestUtils.json("_id: 1, a: { b: 10 }, c: 123"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 40228 (Location40228): ''newRoot' expression must evaluate to an object, but resulting value was: 10. Type of resulting value: 'int'.").withMessageContaining("a: {b: 10}");
    }

    @Test
    void testAggregateWithProjectingReplaceRoot() {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$replaceRoot: { newRoot: { x: '$a.b' } }");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: { b: { c: 10 } }"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("x: { c: 10 }")});
    }

    @Test
    void testAggregateWithMergeObjects() throws Exception {
        MongoCollection orders = db.getCollection("orders");
        orders.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', 'price': 12, ordered: 2"));
        orders.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', 'price': 20, ordered: 1"));
        MongoCollection items = db.getCollection("items");
        items.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', description: 'product 1', instock: 120"));
        items.insertOne((Object)TestUtils.json("_id: 2, item: 'def', description: 'product 2', instock: 80"));
        items.insertOne((Object)TestUtils.json("_id: 3, item: 'jkl', description: 'product 3', instock: 60"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$lookup: {from: 'items', localField: 'item', foreignField: 'item', as: 'fromItems'}", "$replaceRoot: {newRoot: {$mergeObjects: [{$arrayElemAt: ['$fromItems', 0 ]}, '$$ROOT']}}", "$project: { fromItems: 0 }");
        AbstractAggregationTest.assertThat(orders.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, description: 'product 1', instock: 120, item: 'abc', ordered: 2, price: 12"), TestUtils.json("_id: 2, description: 'product 3', instock: 60, item: 'jkl', ordered: 1, price: 20")});
    }

    @Test
    void testAggregateWithSortByCount() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', 'price': 12, ordered: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', 'price': 20, ordered: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'jkl', 'price': 20, ordered: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'jkl', 'price': 40, ordered: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', 'price': 90, ordered: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 6"));
        collection.insertOne((Object)TestUtils.json("_id: 7, item: null"));
        collection.insertOne((Object)TestUtils.json("_id: 8, item: 'aaa'"));
        collection.insertOne((Object)TestUtils.json("_id: 9, item: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 10, item: 'abc'"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$sortByCount: '$item'");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 'abc', count: 4"), TestUtils.json("_id: 'jkl', count: 3"), TestUtils.json("_id: null, count: 2"), TestUtils.json("_id: 'aaa', count: 1")});
    }

    @Test
    void testAggregateWithGraphLookup() {
        collection.insertOne((Object)TestUtils.json("_id: 1, name: 'folderA'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, name: 'subfolderA1', parent: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, name: 'File A11', parent: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 4, name: 'File A12', parent: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 5, name: 'subfolderA2', parent: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 6, name: 'File A21', parent: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 7, name: 'folderB'"));
        collection.insertOne((Object)TestUtils.json("_id: 8, name: 'subfolderB1', parent: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 9, name: 'File B11', parent: 8"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {name: {$regex: 'File A1.*'}}", "$graphLookup: {from: 'testcoll', startWith: '$parent', connectFromField: 'parent', connectToField: '_id', as: 'hierarchy', depthField: 'depth'}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline).map(AbstractAggregationTest.withSortedDocuments("hierarchy")).map(org.bson.Document::toJson)).containsExactly((Object[])new String[]{"{\"_id\": 3, \"name\": \"File A11\", \"parent\": 2, \"hierarchy\": [{\"_id\": 1, \"name\": \"folderA\", \"depth\": 1}, {\"_id\": 2, \"name\": \"subfolderA1\", \"parent\": 1, \"depth\": 0}]}", "{\"_id\": 4, \"name\": \"File A12\", \"parent\": 2, \"hierarchy\": [{\"_id\": 1, \"name\": \"folderA\", \"depth\": 1}, {\"_id\": 2, \"name\": \"subfolderA1\", \"parent\": 1, \"depth\": 0}]}"});
    }

    @Test
    void testObjectToArrayExpression() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {_id: 1, a: {$objectToArray: '$value'}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 40390 (Location40390): '$objectToArray requires a document input, found: int'");
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, value: {a: 1, b: 'foo', c: {x: 10}}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, a: [{k: 'a', v: 1}, {k: 'b', v: 'foo'}, {k: 'c', v: {x: 10}}]")});
        org.bson.Document illegalQuery = TestUtils.json("$project: {_id: 1, a: {$objectToArray: ['$value', 1]}}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(Collections.singletonList(illegalQuery)).first()).withMessageContaining("Command failed with error 16020 (Location16020): 'Expression $objectToArray takes exactly 1 arguments. 2 were passed in.'");
    }

    @Test
    void testArrayToObjectExpression() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: 'xyz', kv: [['a', 'b'], ['c', 'd']]"));
        AbstractAggregationTest.assertThat(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [['a', 'foo']]}}}"))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, x: {a: 'foo'}")});
        AbstractAggregationTest.assertThat(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: '$kv'}}"))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, x: {a: 'b', c: 'd'}")});
        AbstractAggregationTest.assertThat(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 'k1', v: 'v1'}, {k: 'k2', v: 'v2'}]}}}"))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, x: {k1: 'v1', k2: 'v2'}")});
        AbstractAggregationTest.assertThat(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 'k1', v: 'v1'}, {k: 'k1', v: 'v2'}]}}}"))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, x: {k1: 'v2'}")});
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: 'illegal-type'}}")).first()).withMessageContaining("Command failed with error 40386 (Location40386): 'Failed to optimize pipeline :: caused by :: $arrayToObject requires an array input, found: string'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: []}}")).first()).withMessageContaining("Command failed with error 16020 (Location16020): 'Expression $arrayToObject takes exactly 1 arguments. 0 were passed in.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [['foo']]}}}}")).first()).withMessageContaining("Command failed with error 40397 (Location40397): 'Failed to optimize pipeline :: caused by :: $arrayToObject requires an array of size 2 arrays,found array of size: 1'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [123, 456]}}}}")).first()).withMessageContaining("Command failed with error 40398 (Location40398): 'Failed to optimize pipeline :: caused by :: Unrecognised input type format for $arrayToObject: int'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [[123, 456]]}}}}")).first()).withMessageContaining("Command failed with error 40395 (Location40395): 'Failed to optimize pipeline :: caused by :: $arrayToObject requires an array of key-value pairs, where the key must be of type string. Found key type: int'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{}]}}}}")).first()).withMessageContaining("Command failed with error 40392 (Location40392): 'Failed to optimize pipeline :: caused by :: $arrayToObject requires an object keys of 'k' and 'v'. Found incorrect number of keys:0'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 123, v: 'value'}]}}}}")).first()).withMessageContaining("Command failed with error 40394 (Location40394): 'Failed to optimize pipeline :: caused by :: $arrayToObject requires an object with keys 'k' and 'v', where the value of 'k' must be of type string. Found type: int'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 'key', z: 'value'}]}}}}")).first()).withMessageContaining("Command failed with error 40393 (Location40393): 'Failed to optimize pipeline :: caused by :: $arrayToObject requires an object with keys 'k' and 'v'. Missing either or both keys from: {k: \"key\", z: \"value\"}'");
    }

    @Test
    void testAggregateWithReduceOperation() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {}");
        Utils.changeSubdocumentValue((Object)pipeline.get(0), (String)"$project.res", (Object)TestUtils.json("$reduce: {input: ['a', 'b', 'c'], initialValue: '', in: {$concat: ['$$value', '$$this'] }}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, res: 'abc'")});
        Utils.changeSubdocumentValue((Object)pipeline.get(0), (String)"$project.res", (Object)TestUtils.json("$reduce: {input: [1, 2, 3, 4], initialValue: { sum: 5, product: 2 }, in: {\n     sum: {$add: ['$$value.sum', '$$this']},\n     product: {$multiply: ['$$value.product', '$$this']}\n }}"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, res: {sum: 15, product: 48}")});
    }

    @Test
    void testAggregateWithMatchProjectReduceConcatAndCond() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, name: 'Melissa', hobbies: ['softball', 'drawing', 'reading']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, name: 'Brad', hobbies: ['gaming', 'skateboarding']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, name: 'Scott', hobbies: ['basketball', 'music', 'fishing']"));
        collection.insertOne((Object)TestUtils.json("_id: 4, name: 'Tracey', hobbies: ['acting', 'yoga']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, name: 'Josh', hobbies: ['programming']"));
        collection.insertOne((Object)TestUtils.json("_id: 6, name: 'Claire'"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {hobbies: {$gt: []}}", "$project: {\n  name: 1,\n  bio: {\n    $reduce: {\n      input: '$hobbies',\n      initialValue: 'My hobbies include:',\n      in: {\n        $concat: [\n          '$$value',\n          {\n            $cond: {\n              if: { $eq: ['$$value', 'My hobbies include:']},\n              then: ' ',\n              else: ', '\n            }\n          },\n          '$$this'\n        ]\n      }\n    }\n  }\n}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, name: 'Melissa', bio: 'My hobbies include: softball, drawing, reading'"), TestUtils.json("_id: 2, name: 'Brad', bio: 'My hobbies include: gaming, skateboarding'"), TestUtils.json("_id: 3, name: 'Scott', bio: 'My hobbies include: basketball, music, fishing'"), TestUtils.json("_id: 4, name: 'Tracey', bio: 'My hobbies include: acting, yoga'"), TestUtils.json("_id: 5, name: 'Josh', bio: 'My hobbies include: programming'")});
    }

    @Test
    void testAggregateWithBucketStage() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, title: 'The Pillars of Society', artist: 'Grosz', year: 1926, price: 199.99"));
        collection.insertOne((Object)TestUtils.json("_id: 2, title: 'Melancholy III', artist: 'Munch', year: 1902, price: 280.00"));
        collection.insertOne((Object)TestUtils.json("_id: 3, title: 'Dancer', artist: 'Miro', year: 1925, price: 76.04"));
        collection.insertOne((Object)TestUtils.json("_id: 4, title: 'The Great Wave off Kanagawa', artist: 'Hokusai', price: 167.30"));
        collection.insertOne((Object)TestUtils.json("_id: 5, title: 'The Persistence of Memory', artist: 'Dali', year: 1931, price: 483.00"));
        collection.insertOne((Object)TestUtils.json("_id: 6, title: 'Composition VII', artist: 'Kandinsky', year: 1913, price: 385.00"));
        collection.insertOne((Object)TestUtils.json("_id: 7, title: 'The Scream', artist: 'Munch', year: 1893"));
        collection.insertOne((Object)TestUtils.json("_id: 8, title: 'Blue Flower', artist: 'O\u2019Keefe', year: 1918, price: 118.42"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$bucket: {\n  groupBy: '$price',\n  boundaries: [0, 200, 400],\n  default: 'Other',\n  output: {\n    count: { $sum: 1 },\n    titles: { $push: '$title' }\n  }\n}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 0, count: 4, titles: ['The Pillars of Society', 'Dancer', 'The Great Wave off Kanagawa', 'Blue Flower']"), TestUtils.json("_id: 200, count: 2, titles: ['Melancholy III', 'Composition VII']"), TestUtils.json("_id: 'Other', count: 2, titles: ['The Persistence of Memory', 'The Scream']")});
        List<org.bson.Document> pipelineWithoutDefault = TestUtils.jsonList("$match: {price: {$lt: 400}}", "$bucket: {\n  groupBy: '$price',\n  boundaries: [0, 200, 400],\n  output: {count: { $sum: 1 }}\n}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipelineWithoutDefault)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 0, count: 4"), TestUtils.json("_id: 200, count: 2")});
        List<org.bson.Document> pipelineWithoutOutput = TestUtils.jsonList("$match: {price: {$lt: 400}}", "$bucket: {\n  groupBy: '$price',\n  boundaries: [0, 200.0, 400]}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipelineWithoutOutput)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 0, count: 4"), TestUtils.json("_id: 200.0, count: 2")});
        List<org.bson.Document> pipelineWithAlphabeticBoundaries = TestUtils.jsonList("$bucket: {\n  groupBy: {$toLower: '$artist'},\n  boundaries: ['a', 'd', 'g', 'j'],\n  default: null}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipelineWithAlphabeticBoundaries)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: null, count: 5"), TestUtils.json("_id: 'd', count: 1"), TestUtils.json("_id: 'g', count: 2")});
    }

    @Test
    void testAggregateWithIllegalBucketStage() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: [100, 200, 400]}")).first()).withMessageContaining("Command failed with error 40066 (Location40066): '$switch could not find a matching branch for an input, and no default was specified.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: [0, 400], default: 200}")).first()).withMessageContaining("Command failed with error 40199 (Location40199): 'The $bucket 'default' field must be less than the lowest boundary or greater than or equal to the highest boundary.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: [0, 400, 200]}")).first()).withMessageContaining("Command failed with error 40194 (Location40194): 'The 'boundaries' option to $bucket must be sorted, but elements 1 and 2 are not in ascending order (400 is not less than 200).'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: [0, 400], output: 'a'}")).first()).withMessageContaining("Command failed with error 40196 (Location40196): 'The $bucket 'output' field must be an object, but found type: string.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: [0]}")).first()).withMessageContaining("Command failed with error 40192 (Location40192): 'The $bucket 'boundaries' field must have at least 2 values, but found 1 value(s).'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: 'abc'}")).first()).withMessageContaining("Command failed with error 40200 (Location40200): 'The $bucket 'boundaries' field must be an array, but found type: string.");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: [1, 2], boundaries: 'abc'}")).first()).withMessageContaining("Command failed with error 40202 (Location40202): 'The $bucket 'groupBy' field must be defined as a $-prefixed path or an expression, but found: [ 1, 2 ].'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id'}")).first()).withMessageContaining("Command failed with error 40198 (Location40198): '$bucket requires 'groupBy' and 'boundaries' to be specified.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {}")).first()).withMessageContaining("Command failed with error 40198 (Location40198): '$bucket requires 'groupBy' and 'boundaries' to be specified.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: ['abc', 123]}")).first()).withMessageContaining("Command failed with error 40193 (Location40193): 'All values in the the 'boundaries' option to $bucket must have the same type. Found conflicting types string and int.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$bucket: {groupBy: '$_id', boundaries: [0, null]}")).first()).withMessageContaining("Command failed with error 40193 (Location40193): 'All values in the the 'boundaries' option to $bucket must have the same type. Found conflicting types int and null.'");
    }

    @Test
    void testAggregateWithFacetStage() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, title: 'The Pillars of Society', price: 199.99, tags: ['painting', 'Expressionism']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, title: 'Melancholy III', price: 280.00, tags: ['Expressionism']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, title: 'Dancer', price: 76.04, tags: ['oil', 'painting']"));
        collection.insertOne((Object)TestUtils.json("_id: 4, title: 'The Great Wave off Kanagawa', price: 167.30, tags: ['woodblock']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, title: 'The Persistence of Memory', price: 483.00, tags: ['painting', 'oil']"));
        collection.insertOne((Object)TestUtils.json("_id: 6, title: 'Composition VII', price: 385.00, tags: ['oil', 'painting', 'abstract']"));
        collection.insertOne((Object)TestUtils.json("_id: 7, title: 'The Scream', tags: ['Expressionism', 'painting', 'oil']"));
        collection.insertOne((Object)TestUtils.json("_id: 8, title: 'Blue Flower', price: 118.42, tags: ['abstract', 'painting']"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$facet: {\n  'categorizedByTags': [\n    { $unwind: '$tags' },\n    { $sortByCount: '$tags' }\n  ],\n  'categorizedByPrice': [\n    { $match: { price: { $exists: 1 } } },\n    {\n      $bucket: {\n        groupBy: '$price',\n        boundaries: [0, 150, 200, 300, 400],\n        default: 'Other',\n        output: {\n          'count': { $sum: 1 },\n          'titles': { $push: '$title' }\n        }\n      }\n    }\n  ]\n}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("'categorizedByPrice': [\n    {\n      _id: 0,\n      count: 2,\n      titles: ['Dancer', 'Blue Flower']\n    },\n    {\n      _id: 150,\n      count: 2,\n      titles: ['The Pillars of Society', 'The Great Wave off Kanagawa']\n    },\n    {\n      _id: 200,\n      count: 1,\n      titles: ['Melancholy III']\n    },\n    {\n      _id: 300,\n      count: 1,\n      titles: ['Composition VII']\n    },\n    {\n      _id: 'Other',\n      count: 1,\n      titles: ['The Persistence of Memory']\n    }\n  ],\n  'categorizedByTags': [\n    { _id: 'painting', count: 6 },\n    { _id: 'oil', count: 4 },\n    { _id: 'Expressionism', count: 3 },\n    { _id: 'abstract', count: 2 },\n    { _id: 'woodblock', count: 1 }\n  ]")});
    }

    @Test
    void testAggregateWithMatchAndFacetStage() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, title: 'The Pillars of Society', price: 199.99, tags: ['painting', 'Expressionism']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, title: 'Melancholy III', price: 280.00, tags: ['Expressionism']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, title: 'Dancer', price: 76.04, tags: ['oil', 'painting']"));
        collection.insertOne((Object)TestUtils.json("_id: 4, title: 'The Great Wave off Kanagawa', price: 167.30, tags: ['woodblock']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, title: 'The Persistence of Memory', price: 483.00, tags: ['painting']"));
        collection.insertOne((Object)TestUtils.json("_id: 6, title: 'Composition VII', price: 385.00, tags: ['painting', 'abstract']"));
        collection.insertOne((Object)TestUtils.json("_id: 7, title: 'The Scream', tags: ['Expressionism', 'painting', 'oil']"));
        collection.insertOne((Object)TestUtils.json("_id: 8, title: 'Blue Flower', price: 118.42, tags: ['abstract', 'painting']"));
        List<org.bson.Document> pipeline = TestUtils.jsonList("$match: {price: {$gt: 300}}", "$facet: {\n  'categorizedByTags': [\n    { $unwind: '$tags' },\n    { $sortByCount: '$tags' }\n  ],\n  'categorizedByPrice': [\n    {$bucket: {groupBy: '$price', boundaries: [300, 400, 500]}}\n  ]\n}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("'categorizedByPrice': [\n    {_id: 300, count: 1},\n    {_id: 400, count: 1}\n  ],\n  'categorizedByTags': [\n    {_id: 'painting', count: 2},\n    {_id: 'abstract', count: 1}\n  ]")});
    }

    @Test
    void testAggregateWithUnsetStage() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$unset: ['field1', 'fields.field2']");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, field1: 'value1', field2: 'value2'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, field1: 'value1', fields: { field2: 'value2'}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, fields: { field1: 'value1', field2: 'value2'}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, fields: {}"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, field2: 'value2'"), TestUtils.json("_id: 2, fields: {}"), TestUtils.json("_id: 3, fields: { field1: 'value1' }"), TestUtils.json("_id: 4, fields: {}"), TestUtils.json("_id: 5")});
    }

    @Test
    void testAggregateWithUnsetStage_illegalInput() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$unset: [123]")).first()).withMessageStartingWith("Command failed with error 31120 (Location31120): '$unset specification must be a string or an array containing only string values'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$unset: ['']")).first()).withMessageStartingWith("Command failed with error 40352 (Location40352): 'Invalid $project :: caused by :: FieldPath cannot be constructed with empty string'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$unset: ['field1', 123]")).first()).withMessageStartingWith("Command failed with error 31120 (Location31120): '$unset specification must be a string or an array containing only string values'");
    }

    @Test
    void testAggregateWithIndexStats() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$indexStats: {}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        org.bson.Document indexStats = (org.bson.Document)CollectionUtils.getSingleElement((Iterable)collection.aggregate(pipeline));
        ((MapAssert)((MapAssert)((MapAssert)AbstractAggregationTest.assertThat(indexStats).containsOnlyKeys((Object[])new String[]{"name", "key", "host", "accesses", "spec"})).containsEntry((Object)"name", (Object)"_id_")).containsEntry((Object)"key", (Object)TestUtils.json("_id: 1"))).containsEntry((Object)"spec", (Object)TestUtils.json("key: {_id: 1}, name: '_id_', ns: 'testdb.testcoll', v: 2"));
        AbstractAggregationTest.assertThat((org.bson.Document)indexStats.get((Object)"accesses")).containsEntry((Object)"ops", (Object)0L);
    }

    @Test
    void testAggregateWithOut() {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$group: {_id: '$author', books: {$push: '$title'}}", "$out : 'authors'");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 8751, title: 'The Banquet', author: 'Dante', copies: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 8752, title: 'Divine Comedy', author: 'Dante', copies: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 8645, title: 'Eclogues', author: 'Dante', copies: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 7000, title: 'The Odyssey', author: 'Homer', copies: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 7020, title: 'Iliad', author: 'Homer', copies: 10"));
        List<org.bson.Document> expectedDocuments = Arrays.asList(TestUtils.json("_id: 'Homer', books: ['The Odyssey', 'Iliad']"), TestUtils.json("_id: 'Dante', books: ['The Banquet', 'Divine Comedy', 'Eclogues']"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrderElementsOf(expectedDocuments);
        AbstractAggregationTest.assertThat(db.getCollection("authors").find((Bson)TestUtils.json(""))).containsExactlyInAnyOrderElementsOf(expectedDocuments);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsExactlyInAnyOrderElementsOf(expectedDocuments);
        AbstractAggregationTest.assertThat(db.getCollection("authors").find((Bson)TestUtils.json(""))).containsExactlyInAnyOrderElementsOf(expectedDocuments);
    }

    @Test
    void testAggregateWithOut_illegal() {
        collection.insertOne((Object)TestUtils.json("_id: 8751, title: 'The Banquet', author: 'Dante', copies: 2"));
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$out : 123")).first()).withMessage("Cannot return a cursor when the value for $out stage is not a string or namespace document");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$out : ''")).first()).withMessage("state should be: collectionName is not empty");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$out : 'some$collection'")).first()).withMessageContaining("Command failed with error 17385 (Location17385): 'Can't $out to special collection: some$collection'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$out : 'one'", "$out : 'other'")).first()).withMessageContaining("Command failed with error 40601 (Location40601): '$out can only be the final stage in the pipeline'");
    }

    @Test
    void testAggregateWithRedact() {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$redact: {$cond: {if: {$eq: [\"$_id\", 1]}, then: \"$$KEEP\", else: \"$$PRUNE\"}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1")});
    }

    @Test
    void testProjectWithCondition() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {numItems: {$cond : [{$isArray : '$item'}, {$size: '$item'}, 0]}}");
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: [1, 2, 3]"));
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1, numItems: 0"), TestUtils.json("_id: 2, numItems: 0"), TestUtils.json("_id: 3, numItems: 3")});
    }

    @Test
    public void testAggregateWithGeoNear() throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$geoNear: {}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error -1: '$geoNear is not yet implemented. See https://github.com/bwaldvogel/mongo-java-server/issues/138'");
    }

    private static Stream<Arguments> aggregateWithToDoubleArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"12", 12.0}), Arguments.of((Object[])new Object[]{"7.5", 7.5}), Arguments.of((Object[])new Object[]{9, 9.0}), Arguments.of((Object[])new Object[]{9.5, 9.5}), Arguments.of((Object[])new Object[]{false, 0.0}), Arguments.of((Object[])new Object[]{true, 1.0}), Arguments.of((Object[])new Object[]{Missing.getInstance(), null}), Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{Instant.ofEpochMilli(1234567890L), 1.23456789E9}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToDoubleArguments"})
    void testAggregateWithToInt(Object given, Double expected) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toDouble: '$x'}}");
        org.bson.Document document = TestUtils.json("_id: 1");
        if (!(given instanceof Missing)) {
            document.put("x", given);
        }
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", (Object)expected)});
    }

    private static Stream<Arguments> aggregateWithToDoubleArguments_illegalValue() {
        return Stream.of(Arguments.of((Object[])new Object[]{"abc", "'Failed to parse number 'abc' in $convert with no onError value"}), Arguments.of((Object[])new Object[]{Arrays.asList(123), "'Unsupported conversion from array to double in $convert with no onError value'"}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToDoubleArguments_illegalValue"})
    void testAggregateWithConvertToDouble_illegalValue(Object given, String expectedMessagePart) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toDouble: '$x'}}");
        collection.insertOne((Object)TestUtils.json("_id: 1").append("x", given));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 241 (ConversionFailure): " + expectedMessagePart);
    }

    private static Stream<Arguments> aggregateWithToDateArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{Missing.getInstance(), null}), Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{1234567890L, Instant.ofEpochMilli(1234567890L)}), Arguments.of((Object[])new Object[]{1.23456789E9, Instant.ofEpochMilli(1234567890L)}), Arguments.of((Object[])new Object[]{"2020-07", Instant.parse("2020-07-01T00:00:00Z")}), Arguments.of((Object[])new Object[]{"2020-07-13", Instant.parse("2020-07-13T00:00:00Z")}), Arguments.of((Object[])new Object[]{"2020-07-13T14:30:57Z", Instant.parse("2020-07-13T14:30:57Z")}), Arguments.of((Object[])new Object[]{"2020-07-13T14:30:57.123Z", Instant.parse("2020-07-13T14:30:57.123Z")}), Arguments.of((Object[])new Object[]{"2020-07-13T14:30:57+0500", ZonedDateTime.parse("2020-07-13T14:30:57+05:00").toInstant()}), Arguments.of((Object[])new Object[]{"2020-07-13T14:30:57.123+0500", ZonedDateTime.parse("2020-07-13T14:30:57.123+05:00").toInstant()}), Arguments.of((Object[])new Object[]{"2020-07-13T14:30:57-0500", ZonedDateTime.parse("2020-07-13T14:30:57-05:00").toInstant()}), Arguments.of((Object[])new Object[]{Instant.ofEpochMilli(1234567890L), Instant.ofEpochMilli(1234567890L)}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToDateArguments"})
    void testAggregateWithToDate(Object given, Instant expected) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toDate: '$x'}}");
        org.bson.Document document = TestUtils.json("_id: 1");
        if (!(given instanceof Missing)) {
            document.put("x", given);
        }
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", (Object)(expected != null ? Date.from(expected) : null))});
    }

    private static Stream<Arguments> aggregateWithToDateArguments_illegalValue() {
        return Stream.of(Arguments.of((Object[])new Object[]{"abc", "'Error parsing date string 'abc';"}), Arguments.of((Object[])new Object[]{123, "'Unsupported conversion from int to date in $convert with no onError value'"}), Arguments.of((Object[])new Object[]{"123456789", "'Error parsing date string '123456789';"}), Arguments.of((Object[])new Object[]{"2020-07-13T14", "'Error parsing date string '2020-07-13T14';"}), Arguments.of((Object[])new Object[]{Arrays.asList(123), "'Unsupported conversion from array to date in $convert with no onError value'"}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToDateArguments_illegalValue"})
    void testAggregateWithConvertToDate_illegalValue(Object given, String expectedMessagePart) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toDate: '$x'}}");
        collection.insertOne((Object)TestUtils.json("_id: 1").append("x", given));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 241 (ConversionFailure): " + expectedMessagePart);
    }

    private static Stream<Arguments> aggregateWithToIntArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"12", 12}), Arguments.of((Object[])new Object[]{9, 9}), Arguments.of((Object[])new Object[]{false, 0}), Arguments.of((Object[])new Object[]{true, 1}), Arguments.of((Object[])new Object[]{Missing.getInstance(), null}), Arguments.of((Object[])new Object[]{null, null}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToIntArguments"})
    void testAggregateWithToInt(Object given, Integer expected) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toInt: '$x'}}");
        org.bson.Document document = TestUtils.json("_id: 1");
        if (!(given instanceof Missing)) {
            document.put("x", given);
        }
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", (Object)expected)});
    }

    private static Stream<Arguments> aggregateWithToIntArguments_illegalValue() {
        return Stream.of(Arguments.of((Object[])new Object[]{"abc", "'Failed to parse number 'abc' in $convert with no onError value"}), Arguments.of((Object[])new Object[]{Arrays.asList(123), "'Unsupported conversion from array to int in $convert with no onError value'"}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToIntArguments_illegalValue"})
    void testAggregateWithConvertToInt_illegalValue(Object given, String expectedMessagePart) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toInt: '$x'}}");
        collection.insertOne((Object)TestUtils.json("_id: 1").append("x", given));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 241 (ConversionFailure): " + expectedMessagePart);
    }

    private static Stream<Arguments> aggregateWithToBoolArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"abc", true}), Arguments.of((Object[])new Object[]{9, true}), Arguments.of((Object[])new Object[]{0, false}), Arguments.of((Object[])new Object[]{-1, true}), Arguments.of((Object[])new Object[]{0L, false}), Arguments.of((Object[])new Object[]{1L, true}), Arguments.of((Object[])new Object[]{-1L, true}), Arguments.of((Object[])new Object[]{-2L, true}), Arguments.of((Object[])new Object[]{2L, true}), Arguments.of((Object[])new Object[]{false, false}), Arguments.of((Object[])new Object[]{true, true}), Arguments.of((Object[])new Object[]{Missing.getInstance(), null}), Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{0.5, true}), Arguments.of((Object[])new Object[]{0.1, true}), Arguments.of((Object[])new Object[]{0.0, false}), Arguments.of((Object[])new Object[]{-0.0, false}), Arguments.of((Object[])new Object[]{-0.5, true}), Arguments.of((Object[])new Object[]{5, true}), Arguments.of((Object[])new Object[]{new ObjectId(), true}), Arguments.of((Object[])new Object[]{Instant.ofEpochMilli(123456L), true}), Arguments.of((Object[])new Object[]{Arrays.asList(false, true), true}), Arguments.of((Object[])new Object[]{new ArrayList(), true}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToBoolArguments"})
    void testAggregateWithToBool(Object given, Boolean expected) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toBool: '$x'}}");
        org.bson.Document document = TestUtils.json("_id: 1");
        if (!(given instanceof Missing)) {
            document.put("x", given);
        }
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", (Object)expected)});
    }

    private static Stream<Arguments> aggregateWithToLongArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"12", 12L}), Arguments.of((Object[])new Object[]{9, 9L}), Arguments.of((Object[])new Object[]{9.5, 9L}), Arguments.of((Object[])new Object[]{false, 0L}), Arguments.of((Object[])new Object[]{true, 1L}), Arguments.of((Object[])new Object[]{Missing.getInstance(), null}), Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{Instant.ofEpochMilli(123456789L), 123456789L}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToLongArguments"})
    void testAggregateWithToLong(Object given, Long expected) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toLong: '$x'}}");
        org.bson.Document document = TestUtils.json("_id: 1");
        if (!(given instanceof Missing)) {
            document.put("x", given);
        }
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", (Object)expected)});
    }

    private static Stream<Arguments> aggregateWithToLongArguments_illegalValue() {
        return Stream.of(Arguments.of((Object[])new Object[]{"abc", "'Failed to parse number 'abc' in $convert with no onError value"}), Arguments.of((Object[])new Object[]{Arrays.asList(123), "'Unsupported conversion from array to long in $convert with no onError value'"}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToLongArguments_illegalValue"})
    void testAggregateWithConvertToLong_illegalValue(Object given, String expectedMessagePart) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toLong: '$x'}}");
        collection.insertOne((Object)TestUtils.json("_id: 1").append("x", given));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 241 (ConversionFailure): " + expectedMessagePart);
    }

    private static Stream<Arguments> aggregateWithToObjectIdArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"5ab9cbfa31c2ab715d42129e", new ObjectId("5ab9cbfa31c2ab715d42129e")}), Arguments.of((Object[])new Object[]{Missing.getInstance(), null}), Arguments.of((Object[])new Object[]{null, null}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToObjectIdArguments"})
    void testAggregateWithToObjectId(Object given, ObjectId expected) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toObjectId: '$x'}}");
        org.bson.Document document = TestUtils.json("_id: 1");
        if (!(given instanceof Missing)) {
            document.put("x", given);
        }
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", (Object)expected)});
    }

    private static Stream<Arguments> aggregateWithToObjectIdArguments_illegalValue() {
        return Stream.of(Arguments.of((Object[])new Object[]{"5ab9cbfa31c2ab715d42129", "'Failed to parse objectId '5ab9cbfa31c2ab715d42129' in $convert with no onError value"}), Arguments.of((Object[])new Object[]{"5ab9cbfa31c2ab715d42129z", "'Failed to parse objectId '5ab9cbfa31c2ab715d42129z' in $convert with no onError value"}), Arguments.of((Object[])new Object[]{123, "'Unsupported conversion from int to objectId in $convert with no onError value'"}), Arguments.of((Object[])new Object[]{Arrays.asList("5ab9cbfa31c2ab715d421290"), "'Unsupported conversion from array to objectId in $convert with no onError value'"}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithToObjectIdArguments_illegalValue"})
    void testAggregateWithConvertToObjectId_illegalValue(Object given, String expectedMessagePart) throws Exception {
        List<org.bson.Document> pipeline = TestUtils.jsonList("$project: {value: {$toObjectId: '$x'}}");
        collection.insertOne((Object)TestUtils.json("_id: 1").append("x", given));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error 241 (ConversionFailure): " + expectedMessagePart);
    }

    private static Stream<Arguments> aggregateWithConvertArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"input: 1.5, to: null", null}), Arguments.of((Object[])new Object[]{"input: 1.5, to: 'double'", 1.5}), Arguments.of((Object[])new Object[]{"input: 1.5, to: 1", 1.5}), Arguments.of((Object[])new Object[]{"input: 25, to: 'string'", "25"}), Arguments.of((Object[])new Object[]{"input: 25, to: 2", "25"}), Arguments.of((Object[])new Object[]{"input: 'cafebabedeadbeefcafebabe', to: 'objectId'", new ObjectId("cafebabedeadbeefcafebabe")}), Arguments.of((Object[])new Object[]{"input: 'cafebabedeadbeefcafebabe', to: 7", new ObjectId("cafebabedeadbeefcafebabe")}), Arguments.of((Object[])new Object[]{"input: true, to: 'bool'", true}), Arguments.of((Object[])new Object[]{"input: true, to: 8", true}), Arguments.of((Object[])new Object[]{"input: '2020-10-07', to: 'date'", Date.from(Instant.parse("2020-10-07T00:00:00Z"))}), Arguments.of((Object[])new Object[]{"input: '2020-10-07', to: 9", Date.from(Instant.parse("2020-10-07T00:00:00Z"))}), Arguments.of((Object[])new Object[]{"input: '27', to: 'int'", 27}), Arguments.of((Object[])new Object[]{"input: '27', to: 16", 27}), Arguments.of((Object[])new Object[]{"input: '27', to: 'long'", 27L}), Arguments.of((Object[])new Object[]{"input: '27', to: 18", 27L}), Arguments.of((Object[])new Object[]{"input: '27.8', to: 'long', onError: 29", 29}), Arguments.of((Object[])new Object[]{"input: null, to: 'long', onNull: 29", 29}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithConvertArguments"})
    void testAggregateWithConvert_literals(String given, Object expected) throws Exception {
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$project", (Object)new org.bson.Document("value", (Object)new org.bson.Document("$convert", (Object)TestUtils.json(given)))));
        org.bson.Document document = TestUtils.json("_id: 1");
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", expected)});
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithConvertArguments"})
    void testAggregateWithConvert_indirect(String given, Object expected) throws Exception {
        org.bson.Document convertDocument = TestUtils.json(given);
        Object inputValue = convertDocument.put("input", (Object)"$x");
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$project", (Object)new org.bson.Document("value", (Object)new org.bson.Document("$convert", (Object)convertDocument))));
        org.bson.Document document = TestUtils.json("_id: 1").append("x", inputValue);
        collection.insertOne((Object)document);
        AbstractAggregationTest.assertThat(collection.aggregate(pipeline)).containsOnly((Object[])new org.bson.Document[]{TestUtils.json("_id: 1").append("value", expected)});
    }

    private static Stream<Arguments> aggregateWithConvertArguments_illegalValue() {
        return Stream.of(Arguments.of((Object[])new Object[]{"input: 123, to: 'unknown'", "Command failed with error 2 (BadValue): 'Failed to optimize pipeline :: caused by :: Unknown type name: unknown'"}), Arguments.of((Object[])new Object[]{"input: 123, to: 12.5", "Command failed with error 9 (FailedToParse): 'Failed to optimize pipeline :: caused by :: In $convert, numeric 'to' argument is not an integer'"}), Arguments.of((Object[])new Object[]{"input: 123, to: [1, 2]", "Command failed with error 9 (FailedToParse): 'Failed to optimize pipeline :: caused by :: $convert's 'to' argument must be a string or number, but is array'"}), Arguments.of((Object[])new Object[]{"x: 123", "Command failed with error 9 (FailedToParse): '$convert found an unknown argument: x'"}), Arguments.of((Object[])new Object[]{"to: 'int'", "Command failed with error 9 (FailedToParse): 'Missing 'input' parameter to $convert'"}), Arguments.of((Object[])new Object[]{"input: 123, onError: 123", "Command failed with error 9 (FailedToParse): 'Missing 'to' parameter to $convert'"}), Arguments.of((Object[])new Object[]{"input: 123, to: 'int', onElse: 123", "Command failed with error 9 (FailedToParse): '$convert found an unknown argument: onElse'"}));
    }

    @ParameterizedTest
    @MethodSource(value={"aggregateWithConvertArguments_illegalValue"})
    void testAggregateWithConvert_illegalValue(String given, String expectedMessageStartingWith) throws Exception {
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$project", (Object)new org.bson.Document("value", (Object)new org.bson.Document("$convert", (Object)TestUtils.json(given)))));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageStartingWith(expectedMessageStartingWith);
    }

    @Test
    void testAggregateWithConvert_noDocument() throws Exception {
        List<org.bson.Document> pipeline = Collections.singletonList(new org.bson.Document("$project", (Object)new org.bson.Document("value", (Object)new org.bson.Document("$convert", (Object)123))));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageStartingWith("Command failed with error 9 (FailedToParse): '$convert expects an object of named arguments but found: int'");
    }

    @Test
    void testSampleAggregation() throws Exception {
        for (int i = 0; i < 20; ++i) {
            collection.insertOne((Object)TestUtils.json("flag: 1"));
        }
        AbstractAggregationTest.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$sample: { size: 3 }}", "$project: { _id: 0 }")))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("flag: 1"), TestUtils.json("flag: 1"), TestUtils.json("flag: 1")});
        AbstractAggregationTest.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$sample: { size: 2.5 }}", "$project: { _id: 0 }")))).containsExactly((Object[])new org.bson.Document[]{TestUtils.json("flag: 1"), TestUtils.json("flag: 1")});
        AbstractAggregationTest.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$sample: { size: 0 }}")))).isEmpty();
        AbstractAggregationTest.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$sample: { size: -0.3 }}")))).isEmpty();
    }

    @Test
    void testSampleAggregation_illegalParameters() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$sample: 3}")).first()).withMessageStartingWith("Command failed with error 28745 (Location28745): 'the $sample stage specification must be an object'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$sample: [1, 2]}")).first()).withMessageStartingWith("Command failed with error 28745 (Location28745): 'the $sample stage specification must be an object'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$sample: { size: 'a' }}")).first()).withMessageStartingWith("Command failed with error 28746 (Location28746): 'size argument to $sample must be a number'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$sample: { size: null }}")).first()).withMessageStartingWith("Command failed with error 28746 (Location28746): 'size argument to $sample must be a number'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$sample: { size: -1 }}")).first()).withMessageStartingWith("Command failed with error 28747 (Location28747): 'size argument to $sample must not be negative'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$sample: { size: 1, bla: 2}}")).first()).withMessageStartingWith("Command failed with error 28748 (Location28748): 'unrecognized option to $sample: bla'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(TestUtils.jsonList("$sample: {}}")).first()).withMessageStartingWith("Command failed with error 28749 (Location28749): '$sample stage must specify a size'");
    }

    private static Function<org.bson.Document, org.bson.Document> withSortedStringList(String key) {
        return document -> {
            List list = (List)document.get((Object)key);
            list.sort(ValueComparator.asc());
            return document;
        };
    }

    private static Function<org.bson.Document, org.bson.Document> withSortedDocuments(String key) {
        return document -> {
            List list = (List)document.get((Object)key);
            list.sort((o1, o2) -> {
                Document d1 = AbstractAggregationTest.toDocument(o1);
                Document d2 = AbstractAggregationTest.toDocument(o2);
                return ValueComparator.asc().compare((Object)d1, (Object)d2);
            });
            return document;
        };
    }

    private static Document toDocument(org.bson.Document document) {
        return new Document((Map)document);
    }
}

