/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class MongoServerTest {
    private static final int TEST_TIMEOUT_SECONDS = 10;
    private MongoServer server;

    protected abstract MongoBackend createBackend() throws Exception;

    @BeforeEach
    void setUp() throws Exception {
        this.server = new MongoServer(this.createBackend());
    }

    @AfterEach
    void tearDown() {
        this.server.shutdown();
    }

    @Test
    void testToString() throws Exception {
        Assertions.assertThat((Object)this.server).hasToString("MongoServer()");
        InetSocketAddress inetSocketAddress = this.server.bind();
        Assertions.assertThat((Object)this.server).hasToString("MongoServer(port: " + inetSocketAddress.getPort() + ", ssl: false)");
    }

    @Test
    void testBindAndConnect() throws Exception {
        InetSocketAddress inetSocketAddress = this.server.bind();
        try (MongoClient mongoClient = MongoClients.create((String)("mongodb://" + inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort()));){
            mongoClient.getDatabase("abc").createCollection("def");
            Assertions.assertThat(TestUtils.toArray(mongoClient.listDatabaseNames())).containsExactly((Object[])new String[]{"abc"});
        }
    }

    @Test
    void testBindAndGetConnectionStringThenConnect() throws Exception {
        String connectionString = this.server.bindAndGetConnectionString();
        try (MongoClient mongoClient = MongoClients.create((String)connectionString);){
            mongoClient.getDatabase("abc").createCollection("def");
            Assertions.assertThat(TestUtils.toArray(mongoClient.listDatabaseNames())).containsExactly((Object[])new String[]{"abc"});
        }
    }

    @Test
    @Timeout(value=10L)
    void testStopListening() throws Exception {
        String connectionString = this.server.bindAndGetConnectionString();
        try (MongoClient client = MongoClients.create((String)connectionString);){
            this.pingServer(client);
            this.server.stopListening();
            this.pingServer(client);
            Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> {
                try (Socket socket = new Socket();){
                    String host = (String)CollectionUtils.getSingleElement((Iterable)new ConnectionString(connectionString).getHosts());
                    socket.connect(new InetSocketAddress(host, 1234));
                }
            });
        }
    }

    @Test
    @Timeout(value=10L)
    void testShutdownNow() throws Exception {
        String connectionString = this.server.bindAndGetConnectionString();
        MongoClient client = MongoClients.create((String)connectionString);
        this.pingServer(client);
        this.server.shutdownNow();
    }

    @Test
    @Timeout(value=10L)
    void testGetLocalAddress() throws Exception {
        Assertions.assertThat((Object)this.server.getLocalAddress()).isNull();
        InetSocketAddress serverAddress = this.server.bind();
        InetSocketAddress localAddress = this.server.getLocalAddress();
        Assertions.assertThat((Object)localAddress).isEqualTo((Object)serverAddress);
        this.server.shutdownNow();
        Assertions.assertThat((Object)this.server.getLocalAddress()).isNull();
    }

    @Test
    @Timeout(value=10L)
    void testShutdownAndRestart() throws Exception {
        String connectionString = this.server.bindAndGetConnectionString();
        InetSocketAddress serverAddress = this.server.getLocalAddress();
        try (MongoClient client = MongoClients.create((String)connectionString);){
            this.pingServer(client);
            this.server.shutdownNow();
            Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> this.pingServer(client));
            this.server.bind((SocketAddress)serverAddress);
            this.pingServer(client);
        }
    }

    @Test
    @Timeout(value=10L)
    void testSsl() throws Exception {
        this.server.enableSsl(this.getPrivateKey(), null, new X509Certificate[]{this.getCertificate()});
        String connectionString = this.server.bindAndGetConnectionString();
        Assertions.assertThat((String)connectionString).endsWith((CharSequence)"?tls=true");
        InetSocketAddress inetSocketAddress = TestUtils.toInetSocketAddress(connectionString);
        int port = inetSocketAddress.getPort();
        Assertions.assertThat((Object)this.server).hasToString("MongoServer(port: " + port + ", ssl: true)");
        SSLContext sslContext = this.createSslContext(this.loadTestKeyStore());
        MongoClientSettings clientSettings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString)).applyToSslSettings(builder -> {
            builder.enabled(true);
            builder.context(sslContext);
        }).build();
        try (MongoClient client = MongoClients.create((MongoClientSettings)clientSettings);){
            this.pingServer(client);
        }
    }

    @Test
    void testEnableSslAfterAlreadyStarted() throws Exception {
        this.server.bindAndGetConnectionString();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.server.enableSsl(this.getPrivateKey(), null, new X509Certificate[]{this.getCertificate()})).withMessage("Server already started");
    }

    @Test
    void testEnableSslWithEmptyKeyCertChain() throws Exception {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.server.enableSsl(null, null, new X509Certificate[0])).withMessage("Param 'keyCertChain' must not be empty");
    }

    @Test
    void testEnableSslWithMissingPrivateKey() throws Exception {
        X509Certificate certificate = this.getCertificate();
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.server.enableSsl(null, null, new X509Certificate[]{certificate})).withMessage("key required for servers");
    }

    private PrivateKey getPrivateKey() throws Exception {
        return (PrivateKey)this.loadTestKeyStore().getKey("localhost", new char[0]);
    }

    private X509Certificate getCertificate() throws Exception {
        return (X509Certificate)this.loadTestKeyStore().getCertificate("localhost");
    }

    private KeyStore loadTestKeyStore() throws Exception {
        try (InputStream keyStoreStream = this.getClass().getResourceAsStream("/test-keystore.jks");){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreStream, new char[0]);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private SSLContext createSslContext(KeyStore keyStore) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    private void pingServer(MongoClient client) {
        client.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
    }
}

